/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats;

import com.github.mnesikos.simplycats.SCReference;
import com.github.mnesikos.simplycats.block.SCBlocks;
import com.github.mnesikos.simplycats.client.color.ColorEvents;
import com.github.mnesikos.simplycats.client.model.entity.SimplyCatModel;
import com.github.mnesikos.simplycats.client.render.entity.SimplyCatRenderer;
import com.github.mnesikos.simplycats.compat.FarmersRespiteCompat;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.data.SCAdvancementProvider;
import com.github.mnesikos.simplycats.data.SCBlockLoot;
import com.github.mnesikos.simplycats.data.SCBlockModels;
import com.github.mnesikos.simplycats.data.SCBlockStates;
import com.github.mnesikos.simplycats.data.SCRecipeProvider;
import com.github.mnesikos.simplycats.data.SCTags;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.event.SCEvents;
import com.github.mnesikos.simplycats.event.SCSounds;
import com.github.mnesikos.simplycats.item.SCComposting;
import com.github.mnesikos.simplycats.item.SCItems;
import com.github.mnesikos.simplycats.worldgen.villages.SCVillagers;
import com.github.mnesikos.simplycats.worldgen.villages.SCWorldGen;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="simplycats")
public class SimplyCats {
    public static final String MOD_ID = "simplycats";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"simplycats");
    public static final RegistryObject<CreativeModeTab> ITEM_GROUP = CREATIVE_MODE_TABS.register("simplycats.tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.simplycats.tab")).m_257737_(() -> ((Item)SCItems.PET_CARRIER.get()).m_7968_()).m_257501_((parameters, output) -> {
        ItemStack catCarrier = new ItemStack((ItemLike)SCItems.PET_CARRIER.get(), 1, new CompoundTag());
        catCarrier.m_41721_(3);
        output.m_246342_(catCarrier);
        SCItems.REGISTRAR.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get()));
        if (SCReference.isFarmersRespiteLoaded()) {
            FarmersRespiteCompat.ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get()));
        }
    }).m_257652_());
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"simplycats");
    public static final RegistryObject<EntityType<SimplyCatEntity>> CAT = ENTITIES.register("cat", () -> EntityType.Builder.m_20704_(SimplyCatEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.8f).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(1).m_20712_("cat"));

    public SimplyCats() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SCConfig.SPEC);
        ENTITIES.register(bus);
        SCBlocks.REGISTRAR.register(bus);
        SCItems.REGISTRAR.register(bus);
        if (SCReference.isFarmersRespiteLoaded()) {
            FarmersRespiteCompat.register(bus);
        }
        CREATIVE_MODE_TABS.register(bus);
        SCSounds.REGISTRAR.register(bus);
        SCVillagers.POI_TYPES.register(bus);
        SCVillagers.PROFESSIONS.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::registerAttributes);
        bus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(SCWorldGen::setupVillageWorldGen);
        MinecraftForge.EVENT_BUS.addListener(SCEvents::onLivingChangeTargetEvent);
        bus.addListener(this::setupClient);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(ColorEvents::registerColorHandlerBlocks);
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CAT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        event.enqueueWork(() -> {
            SCVillagers.registerTrades();
            SCComposting.registerCompostables();
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)CAT.get()), SimplyCatRenderer::new);
        SCBlocks.setRenderLayers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SimplyCatModel.LAYER_LOCATION, SimplyCatModel::createBodyLayer);
    }

    public void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CAT.get(), SimplyCatEntity.createAttributes().m_22265_());
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new SCBlockModels(packOutput, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new SCBlockStates(packOutput, event.getExistingFileHelper()));
        SCTags.SCBlockTags blockTagsProvider = new SCTags.SCBlockTags(packOutput, event.getLookupProvider(), event.getExistingFileHelper());
        dataGenerator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new SCTags.SCItemTags(packOutput, event.getLookupProvider(), blockTagsProvider, event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new SCTags.SCPoiTypeTags(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SCBlockLoot::new, LootContextParamSets.f_81421_))));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new SCRecipeProvider(packOutput));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new SCAdvancementProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
    }
}

