/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.compat;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public static final ResourceLocation CAT_TIMERS = new ResourceLocation("simplycats", "cat_timers");

    public void register(IWailaCommonRegistration registration) {
        registration.registerEntityDataProvider((IServerDataProvider)CatTimersProvider.INSTANCE, SimplyCatEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerEntityComponent((IEntityComponentProvider)CatTimersProvider.INSTANCE, SimplyCatEntity.class);
    }

    public static enum CatTimersProvider implements IEntityComponentProvider,
    IServerDataProvider<EntityAccessor>
    {
        INSTANCE;


        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            String timerInfo;
            if (!entityAccessor.getServerData().m_128425_("Timer", 3)) {
                return;
            }
            SimplyCatEntity cat = (SimplyCatEntity)entityAccessor.getEntity();
            boolean catIsFemale = cat.getSex() == Genetics.Sex.FEMALE;
            int timer = entityAccessor.getServerData().m_128451_("Timer");
            String string = catIsFemale ? (cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.HEAT) ? "chat.info.in_heat" : "chat.info.not_in_heat") : (timerInfo = "chat.info.male");
            if (cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.PREGNANT)) {
                timerInfo = cat.getBreedingStatus(SimplyCatEntity.BreedingStatus.HEAT) ? "chat.info.pregnant_heat" : "chat.info.pregnant";
            }
            iTooltip.add((Component)Component.m_237115_((String)(catIsFemale ? "cat.sex.female.name" : "cat.sex.male.name")).m_7220_((Component)(cat.isFixed() && entityAccessor.showDetails() ? Component.m_237113_((String)", ").m_7220_((Component)Component.m_237115_((String)"cat.fixed.name")) : Component.m_237119_())).m_7220_((Component)(!cat.isFixed() && !cat.m_6162_() && entityAccessor.showDetails() ? Component.m_237113_((String)", ").m_7220_((Component)Component.m_237110_((String)timerInfo, (Object[])new Object[]{IThemeHelper.get().seconds(timer)})) : Component.m_237119_())));
        }

        public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
            Entity entity = entityAccessor.getEntity();
            if (entity instanceof SimplyCatEntity) {
                SimplyCatEntity cat = (SimplyCatEntity)entity;
                compoundTag.m_128405_("Timer", cat.getMateTimer());
            }
        }

        public ResourceLocation getUid() {
            return CAT_TIMERS;
        }
    }
}

