/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity;

import com.github.mnesikos.simplycats.SCReference;
import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.github.mnesikos.simplycats.entity.goal.CatAttackGoal;
import com.github.mnesikos.simplycats.entity.goal.CatBirthGoal;
import com.github.mnesikos.simplycats.entity.goal.CatFollowParentGoal;
import com.github.mnesikos.simplycats.entity.goal.CatMateGoal;
import com.github.mnesikos.simplycats.entity.goal.CatSeekCatnipGoal;
import com.github.mnesikos.simplycats.entity.goal.CatSitGoal;
import com.github.mnesikos.simplycats.entity.goal.CatTargetNearestGoal;
import com.github.mnesikos.simplycats.entity.goal.CatWanderGoal;
import com.github.mnesikos.simplycats.entity.goal.SCAvoidEntityGoal;
import com.github.mnesikos.simplycats.entity.goal.SCLieOnBedGoal;
import com.github.mnesikos.simplycats.entity.goal.SCRelaxOnOwnerGoal;
import com.github.mnesikos.simplycats.entity.goal.SCSitOnBlockGoal;
import com.github.mnesikos.simplycats.entity.goal.SCTemptGoal;
import com.github.mnesikos.simplycats.item.SCItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SimplyCatEntity
extends TamableAnimal {
    private static final EntityDataAccessor<String> EYE_COLOR = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> FUR_LENGTH = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> EUMELANIN = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PHAEOMELANIN = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DILUTION = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DILUTE_MOD = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> AGOUTI = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TABBY = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> SPOTTED = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TICKED = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> INHIBITOR = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> COLORPOINT = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> BOBTAIL = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_0 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_1 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_2 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_PAWS_0 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_PAWS_1 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_PAWS_2 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WHITE_PAWS_3 = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final String[] whiteTexturesArray = new String[3];
    private final String[] whitePawTexturesArray = new String[4];
    private String texturePrefix;
    private final String[] catTexturesArray = new String[13];
    @Nullable
    BlockPos homePos;
    public static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> MATE_TIMER = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KITTENS = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> MOTHER = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> FATHER = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> AGE_TRACKER = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> MATURE_TIMER = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_RESTING_STATE = SynchedEntityData.m_135353_(SimplyCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private SCTemptGoal temptGoal;
    private SCAvoidEntityGoal<Player> avoidPlayersGoal;
    private SimplyCatEntity followParent;
    private Vec3 nearestLaser;

    public SimplyCatEntity(EntityType<? extends TamableAnimal> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.temptGoal = new SCTemptGoal(this, this.m_21824_() ? 1.2 : 0.6, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SCItems.CATNIP.get(), (ItemLike)SCItems.TREAT_BAG.get()}), true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new CatSitGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SCRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(5, (Goal)new SCLieOnBedGoal(this, 1.1, 8));
        this.f_21345_.m_25352_(6, (Goal)new CatFollowParentGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new CatBirthGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new SCSitOnBlockGoal(this, 0.8, 8));
        this.f_21345_.m_25352_(7, (Goal)new CatSeekCatnipGoal(this, 1.1, 8));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(9, (Goal)new CatAttackGoal((Mob)this));
        if (!this.isFixed()) {
            this.f_21345_.m_25352_(10, (Goal)new CatMateGoal(this, 1.2));
        }
        this.f_21345_.m_25352_(11, (Goal)new CatWanderGoal(this, 0.8, 1.0000001E-5f));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 7.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new CatTargetNearestGoal<LivingEntity>(this, LivingEntity.class, true, entity -> {
            EntityType entityType = entity.m_6095_();
            if (entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_()) {
                return false;
            }
            return !(entity instanceof SimplyCatEntity) && !(entity instanceof Player) && !(entity instanceof Enemy) && !entity.m_7307_((Entity)this) && ((List)SCConfig.prey_list.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType).toString());
        }));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 0.7).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EYE_COLOR, (Object)Genetics.EyeColor.COPPER.toString());
        this.f_19804_.m_135372_(FUR_LENGTH, (Object)"L-L");
        this.f_19804_.m_135372_(EUMELANIN, (Object)"B-B");
        this.f_19804_.m_135372_(PHAEOMELANIN, (Object)"Xo-Xo");
        this.f_19804_.m_135372_(DILUTION, (Object)"D-D");
        this.f_19804_.m_135372_(DILUTE_MOD, (Object)"dm-dm");
        this.f_19804_.m_135372_(AGOUTI, (Object)"a-a");
        this.f_19804_.m_135372_(TABBY, (Object)"Mc-Mc");
        this.f_19804_.m_135372_(SPOTTED, (Object)"sp-sp");
        this.f_19804_.m_135372_(TICKED, (Object)"ta-ta");
        this.f_19804_.m_135372_(INHIBITOR, (Object)"i-i");
        this.f_19804_.m_135372_(COLORPOINT, (Object)"C-C");
        this.f_19804_.m_135372_(WHITE, (Object)"w-w");
        this.f_19804_.m_135372_(BOBTAIL, (Object)"Jb-Jb");
        this.f_19804_.m_135372_(WHITE_0, (Object)"");
        this.f_19804_.m_135372_(WHITE_1, (Object)"");
        this.f_19804_.m_135372_(WHITE_2, (Object)"");
        this.f_19804_.m_135372_(WHITE_PAWS_0, (Object)"");
        this.f_19804_.m_135372_(WHITE_PAWS_1, (Object)"");
        this.f_19804_.m_135372_(WHITE_PAWS_2, (Object)"");
        this.f_19804_.m_135372_(WHITE_PAWS_3, (Object)"");
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(MATE_TIMER, (Object)0);
        this.f_19804_.m_135372_(KITTENS, (Object)0);
        this.f_19804_.m_135372_(MOTHER, Optional.empty());
        this.f_19804_.m_135372_(FATHER, Optional.empty());
        this.f_19804_.m_135372_(AGE_TRACKER, (Object)0);
        this.f_19804_.m_135372_(MATURE_TIMER, (Object)Float.valueOf(168000.0f));
        this.f_19804_.m_135372_(DATA_RESTING_STATE, (Object)0);
    }

    protected void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d0 == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag compound) {
        ServerLevel serverLevel;
        entityData = super.m_6518_(world, difficulty, spawnReason, entityData, compound);
        this.setPhenotype();
        if (!this.m_9236_().f_46443_ && this.m_21824_()) {
            this.m_21839_(!this.m_21827_());
        }
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setHeatCycle(false, this.f_19796_.m_188503_(((Integer)SCConfig.heat_cooldown.get()).intValue()));
        }
        if ((serverLevel = world.m_6018_()).m_215010_().m_220491_(this.m_20183_(), StructureTags.f_215888_).m_73603_()) {
            this.m_21530_();
        }
        return entityData;
    }

    public boolean m_6785_(double distance) {
        return !this.m_21824_() && !this.m_20194_().m_129783_().m_8736_(this.m_20183_(), 2) && this.f_19797_ > 2400;
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new SCAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
        }
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.7f : 1.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.f_19804_.m_135352_()) {
            this.f_19804_.m_135378_();
            this.resetTexturePrefix();
        }
        if (this.m_21515_()) {
            boolean inWater;
            if (this.getNearestLaser() != null) {
                this.m_21839_(false);
                this.setRestingState(RestingState.AWAKE.ordinal());
                this.m_21573_().m_26519_(this.getNearestLaser().f_82479_, this.getNearestLaser().f_82480_, this.getNearestLaser().f_82481_, 1.2);
                this.m_21563_().m_24950_(this.getNearestLaser().f_82479_, this.getNearestLaser().f_82480_, this.getNearestLaser().f_82481_, 10.0f, (float)this.m_21529_());
            }
            if (!this.m_6162_() && !this.isFixed() && this.getSex() == Genetics.Sex.FEMALE) {
                if (this.getBreedingStatus(BreedingStatus.HEAT) && this.getMateTimer() <= 0) {
                    if (!this.getBreedingStatus(BreedingStatus.PREGNANT)) {
                        this.setHeatCycle(false, (Integer)SCConfig.heat_cooldown.get());
                    } else {
                        this.setMateTimer((Integer)SCConfig.pregnancy_timer.get());
                        this.setBreedingStatus(BreedingStatus.HEAT, false);
                    }
                }
                if (!this.getBreedingStatus(BreedingStatus.HEAT) && this.getMateTimer() >= 0 && !this.getBreedingStatus(BreedingStatus.PREGNANT)) {
                    this.setHeatCycle(true, (Integer)SCConfig.heat_timer.get());
                }
            }
            if (this.f_19797_ % 40 == 0 && this.m_269323_() != null) {
                this.setOwnerName(this.m_269323_().m_5446_().getString());
            }
            if ((inWater = this.m_20069_()) || this.m_21827_() || this.m_5448_() != null || this.m_9236_().m_46470_()) {
                this.setRestingState(RestingState.AWAKE.ordinal());
            }
            if (inWater || this.isResting()) {
                this.m_21839_(false);
            }
        }
        if (this.isResting() && this.f_19797_ % 5 == 0) {
            this.m_5496_(SoundEvents.f_11792_, 0.6f + 0.4f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()), 1.0f);
        }
        if (this.temptGoal != null && this.temptGoal.m_25955_() && this.f_19797_ % 100 == 0) {
            this.m_5496_(SoundEvents.f_11790_, 1.0f, 1.0f);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_6162_() && !this.isFixed()) {
            int mateTimer = this.getMateTimer();
            if (this.getSex() == Genetics.Sex.FEMALE) {
                if (this.getBreedingStatus(BreedingStatus.HEAT) || this.getBreedingStatus(BreedingStatus.PREGNANT)) {
                    if (this.getBreedingStatus(BreedingStatus.HEAT) && --mateTimer % 10 == 0) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                } else if (!this.getBreedingStatus(BreedingStatus.HEAT) && !this.getBreedingStatus(BreedingStatus.PREGNANT)) {
                    ++mateTimer;
                }
            } else if (this.getSex() == Genetics.Sex.MALE) {
                if (mateTimer > 0) {
                    --mateTimer;
                } else if (mateTimer <= 0) {
                    mateTimer = 0;
                }
            }
            this.setMateTimer(mateTimer);
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_21824_() && this.m_269323_() == null && !source.m_7639_().m_20310_(2)) {
            return false;
        }
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entity) {
        float damage = (int)this.m_21133_(Attributes.f_22281_);
        if (SCReference.isRatEntity(entity)) {
            damage *= 3.0f;
        }
        if (this.m_6047_() || this.m_20142_()) {
            damage *= 2.0f;
        }
        return entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
        if (entity == null) {
            this.setAngry(false);
        } else if (!this.m_21824_()) {
            this.setAngry(true);
        }
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entity) {
        TamableAnimal tameable;
        if (entity instanceof TamableAnimal && (tameable = (TamableAnimal)entity).m_21824_() && tameable.m_21805_() != null && this.m_21824_() && this.m_21805_() != null && this.m_21805_().equals(tameable.m_21805_())) {
            return true;
        }
        return super.m_7307_(entity);
    }

    public void setPhenotype() {
        this.setGenotype(FUR_LENGTH, Genetics.FurLength.init(this.f_19796_) + "-" + Genetics.FurLength.init(this.f_19796_));
        this.setGenotype(EUMELANIN, Genetics.Eumelanin.init(this.f_19796_) + "-" + Genetics.Eumelanin.init(this.f_19796_));
        this.setGenotype(PHAEOMELANIN, Genetics.Phaeomelanin.init(this.f_19796_));
        this.setGenotype(DILUTION, Genetics.Dilution.init(this.f_19796_) + "-" + Genetics.Dilution.init(this.f_19796_));
        this.setGenotype(DILUTE_MOD, Genetics.DiluteMod.init(this.f_19796_) + "-" + Genetics.DiluteMod.init(this.f_19796_));
        this.setGenotype(AGOUTI, Genetics.Agouti.init(this.f_19796_) + "-" + Genetics.Agouti.init(this.f_19796_));
        this.setGenotype(TABBY, Genetics.Tabby.init(this.f_19796_) + "-" + Genetics.Tabby.init(this.f_19796_));
        this.setGenotype(SPOTTED, Genetics.Spotted.init(this.f_19796_) + "-" + Genetics.Spotted.init(this.f_19796_));
        this.setGenotype(TICKED, Genetics.Ticked.init(this.f_19796_) + "-" + Genetics.Ticked.init(this.f_19796_));
        this.setGenotype(INHIBITOR, Genetics.Inhibitor.init(this.f_19796_) + "-" + Genetics.Inhibitor.init(this.f_19796_));
        this.setGenotype(COLORPOINT, Genetics.Colorpoint.init(this.f_19796_) + "-" + Genetics.Colorpoint.init(this.f_19796_));
        this.setGenotype(WHITE, Genetics.White.init(this.f_19796_) + "-" + Genetics.White.init(this.f_19796_));
        this.setGenotype(BOBTAIL, Genetics.Bobtail.init(this.f_19796_) + "-" + Genetics.Bobtail.init(this.f_19796_));
        this.selectWhiteMarkings();
        this.setGenotype(EYE_COLOR, this.selectEyeColor());
    }

    private String selectEyeColor() {
        String color = Genetics.EyeColor.init(this.f_19796_.m_188503_(4));
        if (this.getGenotype(WHITE).contains(Genetics.White.DOMINANT.getAllele())) {
            color = Genetics.EyeColor.init(this.f_19796_.m_188503_(5));
        }
        if (Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.COLORPOINT.toString())) {
            color = Genetics.EyeColor.init(4);
        }
        if (Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.ALBINO.toString())) {
            color = this.getGenotype(COLORPOINT).contains(Genetics.Colorpoint.BLUE_EYED_ALBINO.getAllele()) ? Genetics.EyeColor.init(5) : Genetics.EyeColor.init(6);
        }
        return color;
    }

    void selectWhiteMarkings() {
        int base;
        int body = 0;
        int face = 0;
        int tail = 0;
        for (int j = 0; j <= 3; ++j) {
            this.whitePawTexturesArray[j] = "";
            this.setWhitePawTextures(j, "");
        }
        switch (this.getGenotype(WHITE)) {
            case "Wd-Wd": 
            case "Wd-w": 
            case "Wd-Ws": 
            case "w-Wd": 
            case "Ws-Wd": {
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            default: {
                base = 0;
                body = 0;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-Ws": {
                base = this.f_19796_.m_188503_(2) + 4;
                if (base == 5) {
                    body = this.f_19796_.m_188503_(4) + 1;
                    face = this.f_19796_.m_188503_(6) + 1;
                    if (body > 1) {
                        tail = this.f_19796_.m_188503_(3) + 1;
                    }
                } else if (base == 4) {
                    body = 1;
                    face = this.f_19796_.m_188503_(5) + 1;
                }
                if (this.f_19796_.m_188503_(10) != 0) break;
                base = 6;
                body = 1;
                face = 0;
                tail = 0;
                break;
            }
            case "Ws-w": 
            case "w-Ws": {
                base = this.f_19796_.m_188503_(3) + 1;
                body = 1;
                if (base == 2 || base == 3) {
                    this.selectWhitePaws(base);
                }
                if (base != 3) break;
                face = this.f_19796_.m_188503_(5) + 1;
            }
        }
        this.whiteTexturesArray[0] = body == 0 ? "" : "white_" + base + "_body" + body;
        this.setWhiteTextures(0, this.whiteTexturesArray[0]);
        this.whiteTexturesArray[1] = face == 0 ? "" : "white_" + (base == 3 || base == 4 ? 34 : base) + "_face" + face;
        this.setWhiteTextures(1, this.whiteTexturesArray[1]);
        this.whiteTexturesArray[2] = tail == 0 ? "" : "white_" + base + "_tail" + tail;
        this.setWhiteTextures(2, this.whiteTexturesArray[2]);
    }

    private void selectWhitePaws(int base) {
        boolean all;
        boolean bl = all = this.f_19796_.m_188503_(4) <= 2;
        if (all || this.f_19796_.m_188503_(4) <= 2) {
            this.whitePawTexturesArray[0] = "white_" + base + "_paw1";
            this.setWhitePawTextures(0, this.whitePawTexturesArray[0]);
        }
        if (all || this.f_19796_.m_188503_(4) <= 2) {
            this.whitePawTexturesArray[1] = "white_" + base + "_paw2";
            this.setWhitePawTextures(1, this.whitePawTexturesArray[1]);
        }
        if (all || this.f_19796_.m_188503_(4) <= 2) {
            this.whitePawTexturesArray[2] = "white_" + base + "_paw3";
            this.setWhitePawTextures(2, this.whitePawTexturesArray[2]);
        }
        if (all || this.f_19796_.m_188503_(4) <= 2) {
            this.whitePawTexturesArray[3] = "white_" + base + "_paw4";
            this.setWhitePawTextures(3, this.whitePawTexturesArray[3]);
        }
    }

    private String getWhiteTextures(int i) {
        switch (i) {
            case 0: {
                if (((String)this.f_19804_.m_135370_(WHITE_0)).isEmpty() && !this.getGenotype(WHITE).equals("w-w")) {
                    this.selectWhiteMarkings();
                }
                return (String)this.f_19804_.m_135370_(WHITE_0);
            }
            case 1: {
                return (String)this.f_19804_.m_135370_(WHITE_1);
            }
            case 2: {
                return (String)this.f_19804_.m_135370_(WHITE_2);
            }
        }
        return "";
    }

    private void setWhiteTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.f_19804_.m_135381_(WHITE_0, (Object)value);
                break;
            }
            case 1: {
                this.f_19804_.m_135381_(WHITE_1, (Object)value);
                break;
            }
            case 2: {
                this.f_19804_.m_135381_(WHITE_2, (Object)value);
            }
        }
    }

    private String getWhitePawTextures(int i) {
        switch (i) {
            case 0: {
                return (String)this.f_19804_.m_135370_(WHITE_PAWS_0);
            }
            case 1: {
                return (String)this.f_19804_.m_135370_(WHITE_PAWS_1);
            }
            case 2: {
                return (String)this.f_19804_.m_135370_(WHITE_PAWS_2);
            }
            case 3: {
                return (String)this.f_19804_.m_135370_(WHITE_PAWS_3);
            }
        }
        return "";
    }

    private void setWhitePawTextures(int i, String value) {
        switch (i) {
            case 0: {
                this.f_19804_.m_135381_(WHITE_PAWS_0, (Object)value);
                break;
            }
            case 1: {
                this.f_19804_.m_135381_(WHITE_PAWS_1, (Object)value);
                break;
            }
            case 2: {
                this.f_19804_.m_135381_(WHITE_PAWS_2, (Object)value);
                break;
            }
            case 3: {
                this.f_19804_.m_135381_(WHITE_PAWS_3, (Object)value);
            }
        }
    }

    protected String getGenotype(EntityDataAccessor<String> parameter) {
        if (((String)this.f_19804_.m_135370_(parameter)).isEmpty()) {
            this.fixEmptyGenes(parameter);
        }
        return (String)this.f_19804_.m_135370_(parameter);
    }

    void setGenotype(EntityDataAccessor<String> parameter, String value) {
        this.f_19804_.m_135381_(parameter, (Object)value);
    }

    private void fixEmptyGenes(EntityDataAccessor<String> dataParameter) {
        if (dataParameter == FUR_LENGTH) {
            this.setGenotype(FUR_LENGTH, "L-L");
        } else if (dataParameter == EUMELANIN) {
            this.setGenotype(EUMELANIN, "B-B");
        } else if (dataParameter == PHAEOMELANIN) {
            this.setGenotype(PHAEOMELANIN, "Xo-" + (this.f_19796_.m_188499_() ? Genetics.Phaeomelanin.NOT_RED.getAllele() : Genetics.Phaeomelanin.MALE.getAllele()));
        } else if (dataParameter == DILUTION) {
            this.setGenotype(DILUTION, "D-D");
        } else if (dataParameter == DILUTE_MOD) {
            this.setGenotype(DILUTE_MOD, "dm-dm");
        } else if (dataParameter == AGOUTI) {
            this.setGenotype(AGOUTI, "a-a");
        } else if (dataParameter == TABBY) {
            this.setGenotype(TABBY, "Mc-Mc");
        } else if (dataParameter == SPOTTED) {
            this.setGenotype(SPOTTED, "sp-sp");
        } else if (dataParameter == TICKED) {
            this.setGenotype(TICKED, "ta-ta");
        } else if (dataParameter == INHIBITOR) {
            this.setGenotype(INHIBITOR, "i-i");
        } else if (dataParameter == COLORPOINT) {
            this.setGenotype(COLORPOINT, "C-C");
        } else if (dataParameter == WHITE) {
            this.setGenotype(WHITE, "w-w");
        } else if (dataParameter == BOBTAIL) {
            this.setGenotype(BOBTAIL, "Jb-Jb");
        } else {
            this.setGenotype(EYE_COLOR, this.selectEyeColor());
        }
    }

    public Genetics.Sex getSex() {
        String phaeomelanin = (String)this.f_19804_.m_135370_(PHAEOMELANIN);
        return !phaeomelanin.isEmpty() && phaeomelanin.contains(Genetics.Phaeomelanin.MALE.getAllele()) ? Genetics.Sex.MALE : Genetics.Sex.FEMALE;
    }

    public boolean isBobtail() {
        String bobtail = (String)this.f_19804_.m_135370_(BOBTAIL);
        return !bobtail.isEmpty() && Genetics.Bobtail.isBobtail(bobtail);
    }

    public boolean isLongFur() {
        String furLength = (String)this.f_19804_.m_135370_(FUR_LENGTH);
        return !furLength.isEmpty() && Genetics.FurLength.getPhenotype(furLength).equalsIgnoreCase(Genetics.FurLength.LONG.toString());
    }

    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void setHomePos(BlockPos position) {
        this.homePos = position;
    }

    public Component getOwnerName() {
        if (this.m_269323_() != null) {
            return this.m_269323_().m_5446_();
        }
        if (!((String)this.f_19804_.m_135370_(OWNER_NAME)).isEmpty()) {
            return Component.m_237113_((String)((String)this.f_19804_.m_135370_(OWNER_NAME)));
        }
        if (this.m_21805_() != null) {
            return Component.m_237115_((String)"entity.simplycats.cat.unknown_owner");
        }
        return Component.m_237115_((String)"entity.simplycats.cat.untamed");
    }

    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)name);
    }

    public void onBagShake(Player player) {
        if (!this.m_21824_() || this.m_269323_() == player && !this.m_21827_()) {
            this.m_21563_().m_24960_((Entity)player, 10.0f, (float)this.m_21529_());
            this.m_21573_().m_5624_((Entity)player, 1.8);
        }
    }

    public Vec3 getNearestLaser() {
        return this.nearestLaser;
    }

    public void setNearestLaser(Vec3 vec) {
        this.nearestLaser = vec;
        if (vec == null) {
            this.m_21573_().m_26573_();
        }
    }

    public final float getAgeScale() {
        return (float)this.getAgeTracker() / this.getMatureTimer() + 1.0f;
    }

    public float getMatureTimer() {
        return ((Float)this.f_19804_.m_135370_(MATURE_TIMER)).floatValue();
    }

    public void setMatureTimer(float maxAge) {
        this.f_19804_.m_135381_(MATURE_TIMER, (Object)Float.valueOf(maxAge));
    }

    public int getAgeTracker() {
        return (Integer)this.f_19804_.m_135370_(AGE_TRACKER);
    }

    public void m_146762_(int age) {
        this.f_19804_.m_135381_(AGE_TRACKER, (Object)age);
        super.m_146762_(age);
    }

    public SimplyCatEntity getFollowParent() {
        return this.followParent;
    }

    public void setFollowParent(SimplyCatEntity followParent) {
        this.followParent = followParent;
    }

    public void setMother(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(MOTHER, Optional.ofNullable(uuid));
    }

    public UUID getMother() {
        return ((Optional)this.f_19804_.m_135370_(MOTHER)).orElse(null);
    }

    public void setFather(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(FATHER, Optional.ofNullable(uuid));
    }

    public UUID getFather() {
        return ((Optional)this.f_19804_.m_135370_(FATHER)).orElse(null);
    }

    public void setHeatCycle(boolean startHeat, int time) {
        this.setBreedingStatus(BreedingStatus.HEAT, startHeat);
        this.setMateTimer(startHeat ? time : -time);
    }

    public void setMateTimer(int time) {
        this.f_19804_.m_135381_(MATE_TIMER, (Object)time);
    }

    public int getMateTimer() {
        return (Integer)this.f_19804_.m_135370_(MATE_TIMER);
    }

    public void setKittens(int kittens) {
        if (this.getKittens() <= 0 || kittens == 0) {
            this.f_19804_.m_135381_(KITTENS, (Object)kittens);
        } else if (this.getKittens() > 0) {
            this.f_19804_.m_135381_(KITTENS, (Object)(this.getKittens() + kittens));
        }
    }

    public int getKittens() {
        return (Integer)this.f_19804_.m_135370_(KITTENS);
    }

    public void addFather(SimplyCatEntity father, int size) {
        for (int i = 0; i < size; ++i) {
            if (this.getPersistentData().m_128441_("Father" + i) && (!this.getPersistentData().m_128441_("Father" + i) || !this.getPersistentData().m_128469_("Father" + i).m_128456_())) continue;
            this.getPersistentData().m_128365_("Father" + i, (Tag)father.m_20240_(new CompoundTag()));
        }
    }

    private void setFather(int i, Tag father) {
        if (this.getPersistentData().m_128441_("Father" + i)) {
            this.getPersistentData().m_128365_("Father" + i, father);
        }
    }

    public CompoundTag getFather(int i) {
        return this.getPersistentData().m_128469_("Father" + i);
    }

    public void setFixed(boolean isFixed) {
        this.setFlag(8, isFixed);
    }

    public boolean isFixed() {
        return this.getFlag(8);
    }

    public void setBreedingStatus(BreedingStatus breedingStatus, boolean isTrue) {
        if (breedingStatus == BreedingStatus.HEAT) {
            this.setFlag(16, isTrue);
        } else if (breedingStatus == BreedingStatus.PREGNANT) {
            this.setFlag(32, isTrue);
        }
    }

    public boolean getBreedingStatus(BreedingStatus breedingStatus) {
        if (breedingStatus == BreedingStatus.HEAT) {
            return this.getFlag(16);
        }
        if (breedingStatus == BreedingStatus.PREGNANT) {
            return this.getFlag(32);
        }
        return false;
    }

    public void setAngry(boolean isAngry) {
        this.setFlag(2, isAngry);
    }

    public boolean isAngry() {
        return this.getFlag(2);
    }

    private void setFlag(int flagId, boolean isFlag) {
        if (isFlag) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)((Byte)this.f_19804_.m_135370_(f_21798_) | flagId)));
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)((Byte)this.f_19804_.m_135370_(f_21798_) & ~flagId)));
        }
    }

    private boolean getFlag(int flagId) {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & flagId) != 0;
    }

    public void setRestingState(int i) {
        this.f_19804_.m_135381_(DATA_RESTING_STATE, (Object)i);
    }

    public RestingState getRestingState() {
        return RestingState.fromOrdinal((Integer)this.f_19804_.m_135370_(DATA_RESTING_STATE));
    }

    public boolean isResting() {
        return this.getRestingState() != RestingState.AWAKE;
    }

    public void m_7380_(CompoundTag compound) {
        int i;
        super.m_7380_(compound);
        compound.m_128359_("EyeColor", this.getGenotype(EYE_COLOR));
        compound.m_128359_("FurLength", this.getGenotype(FUR_LENGTH));
        compound.m_128359_("Eumelanin", this.getGenotype(EUMELANIN));
        compound.m_128359_("Phaeomelanin", this.getGenotype(PHAEOMELANIN));
        compound.m_128359_("Dilution", this.getGenotype(DILUTION));
        compound.m_128359_("DiluteMod", this.getGenotype(DILUTE_MOD));
        compound.m_128359_("Agouti", this.getGenotype(AGOUTI));
        compound.m_128359_("Tabby", this.getGenotype(TABBY));
        compound.m_128359_("Spotted", this.getGenotype(SPOTTED));
        compound.m_128359_("Ticked", this.getGenotype(TICKED));
        compound.m_128359_("Inhibitor", this.getGenotype(INHIBITOR));
        compound.m_128359_("Colorpoint", this.getGenotype(COLORPOINT));
        compound.m_128359_("White", this.getGenotype(WHITE));
        compound.m_128359_("Bobtail", this.getGenotype(BOBTAIL));
        for (i = 0; i <= 2; ++i) {
            compound.m_128359_("White_" + i, this.getWhiteTextures(i));
        }
        for (i = 0; i <= 3; ++i) {
            compound.m_128359_("WhitePaws_" + i, this.getWhitePawTextures(i));
        }
        compound.m_128359_("OwnerName", (String)this.f_19804_.m_135370_(OWNER_NAME));
        if (this.getHomePos() != null) {
            compound.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHomePos()));
        }
        compound.m_128405_("Resting", this.getRestingState().ordinal());
        compound.m_128344_("Fixed", this.isFixed() ? (byte)1 : 0);
        if (this.getSex() == Genetics.Sex.FEMALE) {
            compound.m_128379_("InHeat", this.getBreedingStatus(BreedingStatus.HEAT));
            compound.m_128379_("IsPregnant", this.getBreedingStatus(BreedingStatus.PREGNANT));
            compound.m_128405_("Kittens", this.getKittens());
            for (i = 0; i < 5; ++i) {
                compound.m_128365_("Father" + i, (Tag)this.getFather(i));
            }
        }
        compound.m_128405_("Timer", this.getMateTimer());
        if (this.getMother() == null) {
            compound.m_128359_("Mother", "");
        } else {
            compound.m_128359_("Mother", this.getMother().toString());
        }
        if (this.getFather() == null) {
            compound.m_128359_("Father", "");
        } else {
            compound.m_128359_("Father", this.getFather().toString());
        }
        if (this.m_6162_()) {
            compound.m_128405_("AgeTracker", this.getAgeTracker());
            compound.m_128350_("MatureTimer", this.getMatureTimer());
        }
    }

    public void m_7378_(CompoundTag compound) {
        String s;
        String s2;
        int i;
        super.m_7378_(compound);
        this.setGenotype(EYE_COLOR, compound.m_128461_("EyeColor"));
        this.setGenotype(FUR_LENGTH, compound.m_128461_("FurLength"));
        this.setGenotype(EUMELANIN, compound.m_128461_("Eumelanin"));
        this.setGenotype(PHAEOMELANIN, compound.m_128461_("Phaeomelanin"));
        this.setGenotype(DILUTION, compound.m_128461_("Dilution"));
        this.setGenotype(DILUTE_MOD, compound.m_128461_("DiluteMod"));
        this.setGenotype(AGOUTI, compound.m_128461_("Agouti"));
        this.setGenotype(TABBY, compound.m_128461_("Tabby"));
        this.setGenotype(SPOTTED, compound.m_128461_("Spotted"));
        this.setGenotype(TICKED, compound.m_128461_("Ticked"));
        this.setGenotype(INHIBITOR, compound.m_128461_("Inhibitor"));
        this.setGenotype(COLORPOINT, compound.m_128461_("Colorpoint"));
        this.setGenotype(WHITE, compound.m_128461_("White"));
        this.setGenotype(BOBTAIL, compound.m_128461_("Bobtail"));
        for (i = 0; i <= 2; ++i) {
            this.setWhiteTextures(i, compound.m_128461_("White_" + i));
        }
        for (i = 0; i <= 3; ++i) {
            this.setWhitePawTextures(i, compound.m_128461_("WhitePaws_" + i));
        }
        this.setOwnerName(compound.m_128461_("OwnerName"));
        if (compound.m_128441_("HomePos")) {
            this.setHomePos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("HomePos")));
        }
        this.setRestingState(compound.m_128451_("Resting"));
        this.setFixed(compound.m_128445_("Fixed") != 0);
        if (this.getSex() == Genetics.Sex.FEMALE && !this.isFixed()) {
            this.setBreedingStatus(BreedingStatus.HEAT, compound.m_128471_("InHeat"));
            this.setBreedingStatus(BreedingStatus.PREGNANT, compound.m_128471_("IsPregnant"));
            this.setKittens(compound.m_128451_("Kittens"));
            for (i = 0; i < 5; ++i) {
                this.setFather(i, compound.m_128423_("Father" + i));
            }
        }
        if (!this.isFixed()) {
            this.setMateTimer(compound.m_128451_("Timer"));
        }
        if (compound.m_128425_("Mother", 8) && !(s2 = compound.m_128461_("Mother")).isEmpty()) {
            this.setMother(UUID.fromString(s2));
        }
        if (compound.m_128425_("Father", 8) && !(s = compound.m_128461_("Father")).isEmpty()) {
            this.setFather(UUID.fromString(s));
        }
        if (this.m_6162_()) {
            this.m_146762_(compound.m_128451_("AgeTracker"));
            this.setMatureTimer(compound.m_128457_("MatureTimer"));
        }
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setCatTexturePaths() {
        Object smoke;
        Object solid = Genetics.Eumelanin.getPhenotype(this.getGenotype(EUMELANIN));
        if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString().toLowerCase())) {
            solid = Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN));
        }
        if (Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION)).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
            solid = (String)solid + "_" + Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION));
            if (Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD)).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                solid = (String)solid + "_" + Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD));
            }
        }
        boolean isSilver = this.getGenotype(INHIBITOR).contains(Genetics.Inhibitor.SILVER.getAllele());
        String silver = Genetics.Inhibitor.getPhenotype(this.getGenotype(INHIBITOR));
        Object object = smoke = isSilver ? silver : "";
        if (isSilver) {
            if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString().toLowerCase())) {
                smoke = silver + "_" + Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN));
            } else if (Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION)).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
                smoke = silver + "_" + Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION));
            }
        }
        Object tabby = Genetics.Tabby.getPhenotype(this.getGenotype(TABBY)) + "_" + (String)solid + (String)(isSilver ? "_" + silver : "");
        if (this.getGenotype(SPOTTED).contains(Genetics.Spotted.SPOTTED.getAllele())) {
            tabby = Genetics.Spotted.getPhenotype(this.getGenotype(SPOTTED)) + "_" + (String)tabby;
        }
        if (Genetics.Ticked.getPhenotype(this.getGenotype(TICKED)).equalsIgnoreCase(Genetics.Ticked.TICKED.toString().toLowerCase())) {
            tabby = Genetics.Ticked.getPhenotype(this.getGenotype(TICKED)) + (this.getGenotype(TICKED).contains(Genetics.Ticked.NON_TICKED.getAllele()) ? "_residual" : "") + "_" + (String)solid + (String)(isSilver ? "_" + silver : "");
        }
        Object tortie = "";
        if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.TORTOISESHELL.toString().toLowerCase())) {
            tortie = Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)) + "_" + ((String)tabby).replace("_" + (String)solid, "");
            if (Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION)).equalsIgnoreCase(Genetics.Dilution.DILUTE.toString().toLowerCase())) {
                tortie = (String)tortie + "_" + Genetics.Dilution.getPhenotype(this.getGenotype(DILUTION));
                if (Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD)).equalsIgnoreCase(Genetics.DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                    tortie = (String)tortie + "_" + Genetics.DiluteMod.getPhenotype(this.getGenotype(DILUTE_MOD));
                }
            }
        }
        if (!Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString()) && Genetics.Agouti.getPhenotype(this.getGenotype(AGOUTI)).equalsIgnoreCase(Genetics.Agouti.SOLID.toString().toLowerCase())) {
            tabby = "";
        }
        Object colorpoint = "";
        if (!Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            colorpoint = Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT));
            if (!Genetics.Colorpoint.getPhenotype(this.getGenotype(COLORPOINT)).equalsIgnoreCase(Genetics.Colorpoint.ALBINO.toString())) {
                if (!((String)tabby).equals("") && !Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                    colorpoint = (String)colorpoint + "_tabby";
                } else if (((String)solid).equalsIgnoreCase(Genetics.Eumelanin.BLACK.toString())) {
                    colorpoint = (String)colorpoint + "_" + (String)solid;
                } else if (Genetics.Phaeomelanin.getPhenotype(this.getGenotype(PHAEOMELANIN)).equalsIgnoreCase(Genetics.Phaeomelanin.RED.toString())) {
                    colorpoint = (String)colorpoint + "_red";
                }
                if (!((String)tortie).equals("")) {
                    tortie = (String)tortie + "_point";
                }
            }
        }
        this.catTexturesArray[0] = "simplycats:textures/entity/cat/solid/" + (String)solid + ".png";
        this.catTexturesArray[1] = ((String)tabby).equals("") ? null : "simplycats:textures/entity/cat/tabby/" + (String)tabby + ".png";
        this.catTexturesArray[2] = ((String)smoke).equals("") ? null : "simplycats:textures/entity/cat/solid/" + (String)smoke + ".png";
        this.catTexturesArray[3] = ((String)tortie).equals("") ? null : "simplycats:textures/entity/cat/tortie/" + (String)tortie + ".png";
        this.catTexturesArray[4] = ((String)colorpoint).equals("") ? null : "simplycats:textures/entity/cat/colorpoint/" + (String)colorpoint + ".png";
        this.catTexturesArray[5] = this.getWhiteTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(0) + ".png";
        this.catTexturesArray[6] = this.getWhiteTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(1) + ".png";
        this.catTexturesArray[7] = this.getWhiteTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhiteTextures(2) + ".png";
        this.catTexturesArray[8] = this.getWhitePawTextures(0).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(0) + ".png";
        this.catTexturesArray[9] = this.getWhitePawTextures(1).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(1) + ".png";
        this.catTexturesArray[10] = this.getWhitePawTextures(2).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(2) + ".png";
        this.catTexturesArray[11] = this.getWhitePawTextures(3).equals("") ? null : "simplycats:textures/entity/cat/white/" + this.getWhitePawTextures(3) + ".png";
        this.catTexturesArray[12] = "simplycats:textures/entity/cat/eyes/" + Genetics.EyeColor.getPhenotype(this.getGenotype(EYE_COLOR)) + ".png";
        this.texturePrefix = "cat/" + (String)solid + (String)tabby + (String)smoke + (String)tortie + (String)colorpoint + this.getWhiteTextures(0) + this.getWhiteTextures(1) + this.getWhiteTextures(2) + this.getWhitePawTextures(0) + this.getWhitePawTextures(1) + this.getWhitePawTextures(2) + this.getWhitePawTextures(3) + Genetics.EyeColor.getPhenotype(this.getGenotype(EYE_COLOR));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getCatTexture() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.texturePrefix;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String[] getTexturePaths() {
        if (this.texturePrefix == null) {
            this.setCatTexturePaths();
        }
        return this.catTexturesArray;
    }

    public boolean canBeTamed(Player player) {
        return ((Integer)SCConfig.tamed_limit.get() == 0 || player.getPersistentData().m_128451_("CatCount") < (Integer)SCConfig.tamed_limit.get()) && !this.m_21824_();
    }

    public void setTamed(boolean tamed, Player owner) {
        this.m_7105_(tamed);
        int catCount = owner.getPersistentData().m_128451_("CatCount");
        if (tamed) {
            this.setOwnerName(owner.m_5446_().getString());
            this.m_21816_(owner.m_20148_());
            if (owner instanceof ServerPlayer) {
                CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)owner, (Animal)this);
            }
        } else {
            this.setOwnerName("");
        }
    }

    public boolean m_7848_(Animal target) {
        if (target == this) {
            return false;
        }
        if (!(target instanceof SimplyCatEntity)) {
            return false;
        }
        if (target.m_6162_() || this.m_6162_()) {
            return false;
        }
        if (this.m_21827_() || ((SimplyCatEntity)target).m_21827_()) {
            return false;
        }
        SimplyCatEntity mate = (SimplyCatEntity)target;
        if (mate.isFixed() || this.isFixed()) {
            return false;
        }
        if (this.getSex() == Genetics.Sex.MALE && this.getMateTimer() == 0) {
            return mate.getSex() == Genetics.Sex.FEMALE && mate.getBreedingStatus(BreedingStatus.HEAT);
        }
        return false;
    }

    public boolean m_6898_(ItemStack item) {
        return SCReference.catFoodItems(item);
    }

    private String inheritGene(String motherAlleles, String fatherAlleles) {
        if (motherAlleles.isEmpty()) {
            return "";
        }
        if (fatherAlleles.isEmpty()) {
            return "";
        }
        String[] maternal = motherAlleles.split("-");
        String[] paternal = fatherAlleles.split("-");
        return maternal[this.f_19796_.m_188503_(2)] + "-" + paternal[this.f_19796_.m_188503_(2)];
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob parFather) {
        int eyesMax;
        int eyesMin;
        int patEye;
        SynchedEntityData father = parFather.m_20088_();
        SynchedEntityData mother = this.m_20088_();
        SimplyCatEntity child = (SimplyCatEntity)((EntityType)SimplyCats.CAT.get()).m_20615_(this.m_9236_());
        ImmutableList parameters = ImmutableList.of(FUR_LENGTH, EUMELANIN, PHAEOMELANIN, DILUTION, DILUTE_MOD, AGOUTI, TABBY, SPOTTED, TICKED, INHIBITOR, COLORPOINT, WHITE, (Object[])new EntityDataAccessor[]{BOBTAIL});
        for (EntityDataAccessor geneParameter : parameters) {
            String inherited = this.inheritGene((String)mother.m_135370_(geneParameter), (String)father.m_135370_(geneParameter));
            child.setGenotype((EntityDataAccessor<String>)geneParameter, inherited);
        }
        child.selectWhiteMarkings();
        int matEye = !((String)mother.m_135370_(EYE_COLOR)).isEmpty() ? Genetics.EyeColor.valueOf(((String)mother.m_135370_(EYE_COLOR)).toUpperCase()).ordinal() : 2;
        int n = patEye = !((String)father.m_135370_(EYE_COLOR)).isEmpty() ? Genetics.EyeColor.valueOf(((String)father.m_135370_(EYE_COLOR)).toUpperCase()).ordinal() : 2;
        if (matEye > patEye) {
            eyesMin = patEye - 1;
            eyesMax = matEye;
        } else {
            eyesMin = matEye - 1;
            eyesMax = patEye;
        }
        eyesMin = eyesMin < 0 ? 0 : (eyesMin >= 4 ? 3 : eyesMin);
        String white = child.getGenotype(WHITE);
        eyesMax = white.contains(Genetics.White.DOMINANT.getAllele()) ? 4 : (eyesMax >= 4 ? (eyesMin < 3 ? eyesMin + 1 : 3) : eyesMax);
        int eyes = this.f_19796_.m_188503_(eyesMax - eyesMin + 1) + eyesMin;
        String eye = Genetics.EyeColor.init(matEye == 4 && patEye == 4 ? (eyesMax == 4 ? 4 : this.f_19796_.m_188503_(4)) : eyes);
        String point = child.getGenotype(COLORPOINT);
        if (Genetics.Colorpoint.getPhenotype(point).equalsIgnoreCase(Genetics.Colorpoint.COLORPOINT.toString().toLowerCase())) {
            eye = Genetics.EyeColor.init(4);
        } else if (Genetics.Colorpoint.getPhenotype(point).equalsIgnoreCase(Genetics.Colorpoint.ALBINO.toString().toLowerCase())) {
            eye = point.contains(Genetics.Colorpoint.BLUE_EYED_ALBINO.getAllele()) ? Genetics.EyeColor.init(5) : Genetics.EyeColor.init(6);
        }
        child.setGenotype(EYE_COLOR, eye);
        if (this.m_21824_() && this.m_21805_() != null) {
            Player owner = this.m_9236_().m_46003_(this.m_21805_());
            if (owner != null && child.canBeTamed(owner)) {
                child.setTamed(this.m_21824_(), owner);
            } else {
                this.m_21530_();
            }
        }
        if (this.getHomePos() != null) {
            child.setHomePos(this.getHomePos());
        }
        return child;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item == SCItems.STERILIZE_POTION.get() && (!this.m_21824_() || this.m_21824_() && this.m_21830_((LivingEntity)player)) && player.m_6047_() && !this.isFixed()) {
            this.setFixed(true);
            this.m_21530_();
            for (int i = 0; i < 7; ++i) {
                double d0 = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.getSex() == Genetics.Sex.FEMALE ? "chat.info.success_fixed_female" : "chat.info.success_fixed_male"), (Object[])new Object[]{this.m_7755_()}), true);
            if (!player.m_7500_()) {
                ItemStack emptyBottle = new ItemStack((ItemLike)Items.f_42590_);
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, emptyBottle);
                } else if (!player.m_150109_().m_36054_(emptyBottle)) {
                    player.m_36176_(emptyBottle, false);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42500_ || item == SCItems.TREAT_BAG.get() && !this.m_21824_()) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(stack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_()) {
            if (item == Items.f_42593_ && player.m_20163_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                if (this.m_6162_()) {
                    this.m_142075_(player, hand, stack);
                    this.m_146740_((int)((float)(-this.m_146764_() / 20) * 0.8f), true);
                } else if (!this.isFixed() && this.getMateTimer() != 0) {
                    this.m_142075_(player, hand, stack);
                    this.setMateTimer(this.getMateTimer() / 2);
                }
                return InteractionResult.CONSUME;
            }
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, stack);
                this.m_5634_(1.0f);
                this.m_21530_();
                return InteractionResult.CONSUME;
            }
            if (item == Items.f_42500_ && player.m_20163_()) {
                if (this.getSex() == Genetics.Sex.FEMALE && this.getBreedingStatus(BreedingStatus.PREGNANT)) {
                    player.m_5661_((Component)Component.m_237110_((String)"chat.info.kitten_count", (Object[])new Object[]{this.getKittens()}), true);
                }
                if (this.m_6162_()) {
                    player.m_5661_((Component)Component.m_237113_((String)(this.m_146764_() + " // " + this.getAgeTracker() + " // " + this.getMatureTimer())), true);
                }
                return InteractionResult.CONSUME;
            }
            if (item == SCItems.TREAT_BAG.get() && player.m_20280_((Entity)this) < 9.0 && (!this.m_21824_() || this.m_21830_((LivingEntity)player))) {
                if (player.m_20163_()) {
                    this.m_21530_();
                    if (this.getHomePos() != null) {
                        this.homePos = null;
                        player.m_5661_((Component)Component.m_237110_((String)"chat.info.remove_home", (Object[])new Object[]{this.m_7755_()}), true);
                    } else {
                        this.setHomePos(this.m_20097_());
                        player.m_5661_((Component)Component.m_237110_((String)"chat.info.set_home", (Object[])new Object[]{this.m_7755_(), this.getHomePos().m_123341_(), this.getHomePos().m_123342_(), this.getHomePos().m_123343_()}), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.getHomePos() != null) {
                    player.m_5661_((Component)Component.m_237113_((String)(this.getHomePos().m_123341_() + ", " + this.getHomePos().m_123342_() + ", " + this.getHomePos().m_123343_())), true);
                }
            }
        }
        if (this.m_21830_((LivingEntity)player) && !player.m_20163_()) {
            this.m_21839_(!this.m_21827_());
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
        if ((interactionResult = super.m_6071_(player, hand)).m_19077_()) {
            this.m_21530_();
        }
        return interactionResult;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isAngry()) {
            return SoundEvents.f_11789_;
        }
        if (this.m_27593_()) {
            return SoundEvents.f_11792_;
        }
        if (this.m_21824_()) {
            return this.f_19796_.m_188503_(5) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
        }
        return SoundEvents.f_11786_;
    }

    public int m_8100_() {
        return 900;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11791_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public void m_6593_(@Nullable Component name) {
        String key;
        if (this.m_21805_() != null && (key = SCReference.getCustomCats().get(this.m_21805_())) != null && key.equalsIgnoreCase(name.getString())) {
            SimplyCatEntity cat = this;
            switch (name.getString().toLowerCase()) {
                case "penny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "XO-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "A-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(INHIBITOR, "i-i");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "Ws-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "green");
                    cat.setFixed(true);
                }
                case "spinny": {
                    cat.setGenotype(FUR_LENGTH, "L-l");
                    cat.setGenotype(EUMELANIN, "B-B");
                    cat.setGenotype(PHAEOMELANIN, "Xo-Xo");
                    cat.setGenotype(DILUTION, "D-d");
                    cat.setGenotype(DILUTE_MOD, "dm-dm");
                    cat.setGenotype(AGOUTI, "a-a");
                    cat.setGenotype(TABBY, "mc-mc");
                    cat.setGenotype(SPOTTED, "sp-sp");
                    cat.setGenotype(TICKED, "ta-ta");
                    cat.setGenotype(INHIBITOR, "i-i");
                    cat.setGenotype(COLORPOINT, "C-cs");
                    cat.setGenotype(WHITE, "w-w");
                    cat.setGenotype(BOBTAIL, "Jb-Jb");
                    cat.selectWhiteMarkings();
                    cat.setGenotype(EYE_COLOR, "gold");
                }
            }
        }
        super.m_6593_(name);
    }

    public static enum RestingState {
        AWAKE,
        RESTING,
        LOAFING,
        LOUNGING,
        ROLLING;


        public static RestingState fromOrdinal(int ordinal) {
            return switch (ordinal) {
                case 0 -> AWAKE;
                case 1 -> RESTING;
                case 2 -> LOAFING;
                case 3 -> LOUNGING;
                case 4 -> ROLLING;
                default -> throw new IllegalStateException("Unexpected value: " + ordinal);
            };
        }
    }

    public static enum BreedingStatus {
        HEAT,
        PREGNANT;

    }
}

