/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base;

import com.drmangotea.tfmg.base.TFMGRegistries;
import com.drmangotea.tfmg.base.spark.ElectricSparkParticle;
import com.drmangotea.tfmg.base.spark.Spark;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePos;
import com.drmangotea.tfmg.content.machinery.vat.electrode_holder.electrode.Electrode;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TFMGUtils {
    public static float toYRot(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0.0f;
            case Direction.UP -> 0.0f;
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
        };
    }

    public static void createFireExplosion(Level level, Entity entity, BlockPos pos, int sparkAmount, float radius) {
        if (level.f_46443_ && entity != null) {
            level.m_7605_(entity, (byte)3);
        }
        for (int i = 0; i < sparkAmount; ++i) {
            float x = Create.RANDOM.nextFloat(360.0f);
            float y = Create.RANDOM.nextFloat(360.0f);
            float z = Create.RANDOM.nextFloat(360.0f);
            Spark spark = (Spark)TFMGEntityTypes.SPARK.create(level);
            spark.m_6027_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            float f = -Mth.m_14031_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
            float f1 = -Mth.m_14031_((float)((x + z) * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
            spark.m_6686_(f, f1, f2, 0.3f, 1.0f);
            level.m_7967_((Entity)spark);
        }
        level.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), radius, Level.ExplosionInteraction.BLOCK);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound, SoundSource source) {
        TFMGUtils.playSound(level, pos, sound, source, 1.0f, 1.0f, null);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound, SoundSource source, Player player) {
        TFMGUtils.playSound(level, pos, sound, source, 1.0f, 1.0f, player);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        TFMGUtils.playSound(level, pos, sound, source, volume, pitch, null);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch, Player player) {
        level.m_5594_(player, pos, sound, source, volume, pitch);
    }

    public static void blowUpTank(FluidTankBlockEntity tank, int power) {
        if (tank == null || tank.getControllerBE() == null) {
            return;
        }
        FluidTankBlockEntity be = tank.getControllerBE();
        for (int xOffset = 0; xOffset < be.getWidth(); ++xOffset) {
            for (int zOffset = 0; zOffset < be.getWidth(); ++zOffset) {
                for (int yOffset = 0; yOffset < be.getHeight(); ++yOffset) {
                    BlockPos pos = be.m_58899_().m_7918_(xOffset, yOffset, zOffset);
                    be.m_58904_().m_46961_(pos, false);
                }
            }
        }
        TFMGUtils.createFireExplosion(be.m_58904_(), null, new BlockPos(be.m_58899_().m_123341_() + be.getWidth() / 2, be.m_58899_().m_123342_() + be.getHeight() / 2, be.m_58899_().m_123343_() + be.getWidth() / 2), power * 15, power);
    }

    public static String fromId(String key) {
        String s = key.replaceAll("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        s = StringUtils.normalizeSpace((String)s);
        return s;
    }

    public static String toHumanReadable(String key) {
        String s = key.replaceAll("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        s = StringUtils.normalizeSpace((String)s);
        return s;
    }

    public static void spawnElectricParticles(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        RandomSource r = level.m_213780_();
        for (int i = 0; i < r.m_188503_(40); ++i) {
            float x = Create.RANDOM.nextFloat(2.0f) - 1.0f;
            float y = Create.RANDOM.nextFloat(2.0f) - 1.0f;
            float z = Create.RANDOM.nextFloat(2.0f) - 1.0f;
            level.m_7106_((ParticleOptions)new ElectricSparkParticle.Data(), (double)((float)pos.m_123341_() + 0.5f + x), (double)((float)pos.m_123342_() + 0.5f + y), (double)((float)pos.m_123343_() + 0.5f + z), (double)x, (double)y, (double)z);
        }
    }

    public static float getDistance(BlockPos pos1, BlockPos pos2, boolean _2D) {
        float x = Math.abs(pos1.m_123341_() - pos2.m_123341_());
        float y = Math.abs(pos1.m_123342_() - pos2.m_123342_());
        float z = Math.abs(pos1.m_123343_() - pos2.m_123343_());
        float distance2D = (float)Math.sqrt(x * x + z * z);
        if (_2D) {
            return distance2D;
        }
        return (float)Math.sqrt(distance2D * distance2D + y * y);
    }

    public static void createStorageTooltip(BlockEntity be, List<Component> tooltip) {
        TFMGUtils.createFluidTooltip(be, tooltip);
        TFMGUtils.createItemTooltip(be, tooltip);
    }

    public static boolean createFluidTooltip(BlockEntity be, List<Component> tooltip) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LazyOptional handler = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        CreateLang.translate((String)"goggles.fluid_storage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public static boolean createItemTooltip(BlockEntity be, List<Component> tooltip) {
        @NotNull LazyOptional handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)resolve.get();
        if (inventory.getSlots() == 0) {
            return false;
        }
        CreateLang.translate((String)"goggles.item_storage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            CreateLang.itemName((ItemStack)itemStack).style(ChatFormatting.DARK_GREEN).add(Component.m_237113_((String)(" x " + itemStack.m_41613_()))).style(ChatFormatting.DARK_GREEN).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (inventory.getSlots() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"item_attributes.shulker_level.empty", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    public static String formatUnits(double n, String unit) {
        if (n == 0.0) {
            return Math.round(n) + unit;
        }
        if (n >= 1.0E9) {
            double var10000 = Math.round(n / 1.0E8);
            return var10000 / 10.0 + "G" + unit;
        }
        if (n >= 1000000.0) {
            double var10000 = Math.round(n / 100000.0);
            return var10000 / 10.0 + "M" + unit;
        }
        if (n >= 1000.0) {
            double var10000 = Math.round(n / 100.0);
            return var10000 / 10.0 + "k" + unit;
        }
        if (n < 1.0) {
            double var10000 = Math.round(n * 10000.0);
            return var10000 / 10.0 + "m" + unit;
        }
        return Math.round(n) + unit;
    }

    public static void drainFilteredTank(SmartFluidTank tank, int amount) {
        tank.setFluid(new FluidStack(tank.getFluid(), Math.max(tank.getFluidAmount() - amount, 0)));
    }

    public static void fillFilteredTank(SmartFluidTank tank, FluidStack resource) {
        if (tank.getFluid().getFluid().m_6212_(resource.getFluid()) || tank.isEmpty()) {
            tank.setFluid(new FluidStack(resource.getFluid(), Math.min(tank.getFluidAmount() + resource.getAmount(), tank.getCapacity())));
        }
    }

    public static Iterable<BlockPos> AABBtoBlockPos(AABB aabb) {
        return BlockPos.m_121940_((BlockPos)new BlockPos((int)aabb.f_82288_, (int)aabb.f_82289_, (int)aabb.f_82290_), (BlockPos)new BlockPos((int)aabb.f_82291_, (int)aabb.f_82292_, (int)aabb.f_82293_));
    }

    public static SmartFluidTank createTank(int capacity, boolean extractionAllowed, Consumer<FluidStack> updateCallback) {
        return TFMGUtils.createTank(capacity, extractionAllowed, true, updateCallback, null);
    }

    public static SmartFluidTank createTank(int capacity, boolean extractionAllowed, boolean insertionAllowed, Consumer<FluidStack> updateCallback) {
        return TFMGUtils.createTank(capacity, extractionAllowed, insertionAllowed, updateCallback, null);
    }

    public static SmartFluidTank createTank(int capacity, final boolean extractionAllowed, final boolean insertionAllowed, Consumer<FluidStack> updateCallback, final Fluid validFluid) {
        return new SmartFluidTank(capacity, updateCallback){

            public boolean isFluidValid(FluidStack stack) {
                if (validFluid == null) {
                    return true;
                }
                return stack.getFluid().m_6212_(validFluid);
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, action);
            }

            public FluidStack forceDrain(FluidStack resource, IFluidHandler.FluidAction action) {
                return super.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (!extractionAllowed) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, action);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!insertionAllowed) {
                    return 0;
                }
                return super.fill(resource, action);
            }
        };
    }

    public static void renderWire(Level level, PoseStack pMatrixStack, MultiBufferSource pBuffer, CablePos pos1, CablePos pos2, float curve, float r, float g, float b) {
        TFMGUtils.renderWire(level, pMatrixStack, pBuffer, pos1, pos2, curve, r, g, b, false);
    }

    public static void renderWire(Level level, PoseStack pMatrixStack, MultiBufferSource pBuffer, CablePos pos1, CablePos pos2, float curve, float r, float g, float b, boolean flippedLighting) {
        BlockPos blockpos2;
        BlockPos blockpos1;
        pMatrixStack.m_85836_();
        Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
        CablePos pos2Local = pos1.subtract(pos2);
        pMatrixStack.m_85837_(0.5, 0.5, 0.5);
        vec3 = vec3.m_82520_(pos2Local.m_7096_() + 0.01, pos2Local.m_7098_(), pos2Local.m_7094_() + 0.01);
        float f = (float)vec3.f_82479_;
        float f1 = (float)vec3.f_82480_;
        float f2 = (float)vec3.f_82481_;
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
        float f4 = (float)(Mth.m_14193_((double)(f * f + f2 * f2)) * (double)0.025f / 2.0);
        float f5 = f2 * f4;
        float f6 = f * f4;
        if (flippedLighting) {
            blockpos1 = new BlockPos((int)pos1.m_7096_(), (int)pos1.m_7098_(), (int)pos1.m_7094_());
            blockpos2 = new BlockPos((int)pos2.m_7096_(), (int)pos2.m_7098_(), (int)pos2.m_7094_());
        } else {
            blockpos2 = new BlockPos((int)pos1.m_7096_(), (int)pos1.m_7098_(), (int)pos1.m_7094_());
            blockpos1 = new BlockPos((int)pos2.m_7096_(), (int)pos2.m_7098_(), (int)pos2.m_7094_());
        }
        int i = level.m_45517_(LightLayer.SKY, blockpos1);
        int j = level.m_45517_(LightLayer.SKY, blockpos2);
        int k = level.m_45517_(LightLayer.SKY, blockpos1);
        int l = level.m_45517_(LightLayer.SKY, blockpos2);
        for (int i1 = 0; i1 <= 24; ++i1) {
            TFMGUtils.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.03f, 0.03f, f5, f6, i1, false, curve, r, g, b);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            TFMGUtils.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.03f, 0.0f, f5, f6, j1, true, curve, r, g, b);
        }
        pMatrixStack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float p_174310_, float p_174311_, float p_174312_, int light_1, int light_2, int p_174315_, int p_174316_, float thickness, float p_174318_, float p_174319_, float p_174320_, int value, boolean p_174322_, float curve, float r, float g, float b) {
        float f = (float)value / 24.0f;
        int i = (int)Mth.m_14179_((float)f, (float)light_1, (float)light_2);
        int j = (int)Mth.m_14179_((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.m_109885_((int)i, (int)j);
        float f1 = value % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float red = r / 255.0f * f1;
        float green = g / 255.0f * f1;
        float blue = b / 255.0f * f1;
        float x = p_174310_ * f;
        float pain = ((float)value * curve * 24.0f - (float)(value * value) * curve) * -1.0f;
        float y = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float z = p_174312_ * f;
        vertexConsumer.m_252986_(matrix4f, x - p_174319_, y + p_174318_ + pain, z + p_174320_).m_85950_(red, green, blue, 1.0f).m_85969_(k).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x + p_174319_, y + thickness - p_174318_ + pain, z - p_174320_).m_85950_(red, green, blue, 1.0f).m_85969_(k).m_5752_();
    }

    public static Electrode getElectrode(ResourceLocation name) {
        return TFMGRegistries.registeredElectrodes.get(name);
    }

    public static CableType getCableType(ResourceLocation name) {
        return TFMGRegistries.registeredCableTypes.get(name);
    }
}

