/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.config;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableTypeBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class TFMGResistivity
extends ConfigBase {
    private static final int VERSION = 2;
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_RESISTIVITIES = new Object2DoubleOpenHashMap();
    protected final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> resistivities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.resistivity}).push("resistivity");
        DEFAULT_RESISTIVITIES.forEach((id, value) -> this.resistivities.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.m_135815_(), value)));
        builder.pop();
    }

    public String getName() {
        return "resistivityValues.v2";
    }

    @Nullable
    public DoubleSupplier getResistivity(CableType cableType) {
        ResourceLocation id = cableType.getKey();
        ForgeConfigSpec.ConfigValue<Double> value = this.resistivities.get(id);
        return value == null ? null : () -> value.get();
    }

    public static <B extends CableType, P> NonNullUnaryOperator<CableTypeBuilder<B, P>> setNoResistivity() {
        return TFMGResistivity.setResistivity(0.0);
    }

    public static <B extends CableType, P> NonNullUnaryOperator<CableTypeBuilder<B, P>> setResistivity(double value) {
        return builder -> {
            ResourceLocation id = TFMG.asResource(builder.getName());
            DEFAULT_RESISTIVITIES.put((Object)id, value);
            return builder;
        };
    }

    private static class Comments {
        static String resistivity = "Configure the individual resistivity of cable types.";

        private Comments() {
        }
    }
}

