/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.segmented_display;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.utilities.segmented_display.SegmentedDisplayBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.IBE;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SegmentedDisplayBlock
extends TFMGHorizontalDirectionalBlock
implements IBE<SegmentedDisplayBlockEntity> {
    public SegmentedDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public static void walkParts(LevelAccessor world, BlockPos start, BiConsumer<BlockPos, Integer> callback) {
        BlockPos nextPos;
        BlockState state = world.m_8055_(start);
        if (!(state.m_60734_() instanceof SegmentedDisplayBlock)) {
            return;
        }
        BlockPos currentPos = start;
        Direction left = ((Direction)state.m_61143_((Property)f_54117_)).m_122427_();
        Direction right = left.m_122424_();
        while (SegmentedDisplayBlock.areDisplaysEqual(world.m_8055_(nextPos = currentPos.m_121945_(left)), state)) {
            currentPos = nextPos;
        }
        int index = 0;
        while (true) {
            int rowPosition = index++;
            callback.accept(currentPos, rowPosition);
            BlockPos nextPos2 = currentPos.m_121945_(right);
            if (!SegmentedDisplayBlock.areDisplaysEqual(world.m_8055_(nextPos2), state)) break;
            currentPos = nextPos2;
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        String tagElement;
        ItemStack heldItem = player.m_21120_(hand);
        SegmentedDisplayBlockEntity segmentedDisplay = (SegmentedDisplayBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (heldItem.m_41619_()) {
            segmentedDisplay.clearCustomText();
            return InteractionResult.SUCCESS;
        }
        boolean display = heldItem.m_41720_() == Items.f_42656_ && heldItem.m_41788_() || AllBlocks.CLIPBOARD.isIn(heldItem);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (dye != null) {
            SegmentedDisplayBlock.walkParts((LevelAccessor)world, pos, (currentPos, rowPosition) -> {
                world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.setColor(dye));
            });
            return InteractionResult.SUCCESS;
        }
        if (!display) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = heldItem.m_41737_("display");
        String tagUsed = tagElement = tag != null && tag.m_128425_("Name", 8) ? tag.m_128461_("Name") : null;
        SegmentedDisplayBlock.walkParts((LevelAccessor)world, pos, (currentPos, rowPosition) -> {
            if (display) {
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.displayCustomText(tagUsed, (int)rowPosition));
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static boolean areDisplaysEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.m_60734_() instanceof SegmentedDisplayBlock)) {
            return false;
        }
        return otherState.m_60734_() instanceof SegmentedDisplayBlock;
    }

    public Class<SegmentedDisplayBlockEntity> getBlockEntityClass() {
        return SegmentedDisplayBlockEntity.class;
    }

    public BlockEntityType<? extends SegmentedDisplayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.SEGMENTED_DISPLAY.get();
    }
}

