/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.base;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.content.engines.base.EngineFluidTank;
import com.drmangotea.tfmg.content.engines.fuels.BaseFuelTypes;
import com.drmangotea.tfmg.content.engines.fuels.EngineFuelTypeManager;
import com.drmangotea.tfmg.content.engines.fuels.FuelType;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class AbstractEngineBlockEntity
extends KineticElectricBlockEntity {
    public EngineFluidTank fuelTank;
    public EngineFluidTank exhaustTank;
    public LazyOptional<IFluidHandler> fluidCapability;
    public float rpm = 0.0f;
    public float fuelInjectionRate = 0.0f;
    public boolean reverse = false;
    public int highestSignal;
    public int signal;
    public BlockPos engineController;
    public float torque = 0.0f;
    public boolean signalChanged;
    public int fuelConsumptionTimer = 0;

    public AbstractEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.fuelTank = new EngineFluidTank(4000, false, true, f -> this.tankUpdated((FluidStack)f, true), TFMGTags.TFMGFluidTags.AIR.tag);
        this.exhaustTank = new EngineFluidTank(8000, true, false, f -> this.tankUpdated((FluidStack)f, false));
        this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank}));
        this.refreshCapability();
    }

    @Override
    public void tick() {
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged();
        }
        super.tick();
    }

    public void tankUpdated(FluidStack stack, boolean fuelTank) {
        if (fuelTank && stack.isEmpty()) {
            this.fuelInjectionRate = 0.0f;
            this.updateRotation();
        }
        this.sendData();
        this.m_6596_();
    }

    public boolean hasEngineController() {
        return this.engineController != null;
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
    }

    protected void analogSignalChanged() {
        int newSignal;
        if (this.hasEngineController()) {
            this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
            return;
        }
        this.signal = newSignal = this.f_58857_.m_277086_(this.m_58899_());
        this.highestSignal = newSignal = Math.max(this.f_58857_.m_277086_(this.m_58899_()), newSignal);
        this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
        this.updateRotation();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
        this.manageFuelAndExhaust();
    }

    public void manageFuelAndExhaust() {
        this.exhaustTank.forceFill(new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.get(), Math.min(300, this.getFuelConsumption())), IFluidHandler.FluidAction.EXECUTE);
        if (this.fuelConsumptionTimer <= 2) {
            ++this.fuelConsumptionTimer;
        } else {
            this.fuelConsumptionTimer = 0;
            this.fuelTank.forceDrain(this.getFuelConsumption(), IFluidHandler.FluidAction.EXECUTE);
            if (this.fuelTank.isEmpty()) {
                this.updateRotation();
            }
        }
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public float getSpeedEfficiency() {
        if (this.rpm >= 6000.0f) {
            return 1.0f;
        }
        return 1.0f / (0.08f * (this.rpm / 1000.0f) + 0.5f);
    }

    public abstract List<TagKey<Fluid>> getSupportedFuels();

    public void onUpdated() {
    }

    @Override
    public boolean canWork() {
        if (this.fuelTank.isEmpty()) {
            return false;
        }
        return this.exhaustTank.getSpace() != 0;
    }

    public void updateRotation() {
    }

    public abstract float efficiencyModifier();

    public abstract float speedModifier();

    public abstract float torqueModifier();

    public abstract String engineId();

    public FuelType getFuelType() {
        AtomicReference<FuelType> matchingType = new AtomicReference<FuelType>(BaseFuelTypes.FALLBACK);
        EngineFuelTypeManager.GLOBAL_TYPE_MAP.forEach((r, t) -> {
            TagKey<Fluid> fluidTag = t.getFluid();
            FluidStack fluid = this.fuelTank.getFluid();
            if (fluid.getFluid().m_205067_(fluidTag)) {
                matchingType.set((FuelType)t);
            }
        });
        return matchingType.get();
    }

    public void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(this::handlerForCapability);
        oldCap.invalidate();
    }

    public IFluidHandler handlerForCapability() {
        return new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank});
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getMaxLength() {
        return (Integer)TFMGConfigs.common().machines.engineMaxLength.get();
    }

    public void changeDirection() {
        this.playInsertionSound();
        this.reverse = !this.reverse;
        this.updateRotation();
    }

    public void dropItem(ItemStack stack) {
        Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, (double)0.3f, 0.0);
        ItemEntity dropped = new ItemEntity(this.f_58857_, dropVec.f_82479_, dropVec.f_82480_, dropVec.f_82481_, stack);
        dropped.m_32060_();
        dropped.m_20334_(0.0, (double)0.15f, 0.0);
        this.f_58857_.m_7967_((Entity)dropped);
    }

    public void playInsertionSound() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 0.5f);
    }

    public void playRemovalSound() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 0.5f);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.reverse = compound.m_128471_("Reverse");
        this.signal = compound.m_128451_("Signal") + 1;
        if (this.hasEngineController()) {
            this.engineController = BlockPos.m_122022_((long)compound.m_128454_("EngineController"));
        }
        this.fuelInjectionRate = compound.m_128457_("RPM");
        this.fuelTank.readFromNBT(compound.m_128469_("FuelTank"));
        this.exhaustTank.readFromNBT(compound.m_128469_("ExhaustTank"));
        this.highestSignal = compound.m_128451_("HighestSignal");
        this.updateRotation();
        this.updateGeneratedRotation();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128379_("Reverse", this.reverse);
        compound.m_128405_("Signal", this.signal);
        if (this.hasEngineController()) {
            compound.m_128356_("EngineController", this.engineController.m_121878_());
        }
        compound.m_128350_("RPM", this.fuelInjectionRate);
        compound.m_128365_("FuelTank", (Tag)this.fuelTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("ExhaustTank", (Tag)this.exhaustTank.writeToNBT(new CompoundTag()));
        compound.m_128405_("HighestSignal", this.highestSignal);
    }

    public abstract int getFuelConsumption();

    @Override
    public void onPlaced() {
        super.onPlaced();
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        int power = this.f_58857_.m_277086_(this.m_58899_());
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }
}

