/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerClientHandler;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerMenu;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.TransmissionUpgrade;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class EngineControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
MenuProvider {
    private UUID user;
    private UUID prevUser;
    private boolean deactivatedThisTick;
    public TransmissionUpgrade.TransmissionState shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
    public int accelerationRate = 0;
    public AbstractSmallEngineBlockEntity engine = null;
    public BlockPos enginePos = null;
    public boolean engineStarted = false;
    public boolean clutch = false;
    public boolean brake = false;
    public boolean gas = false;
    public ItemStackHandler frequencyItems = new ItemStackHandler(6);
    public LerpedFloat transmissionLeverAngle = LerpedFloat.angular();
    public LerpedFloat steeringWheelAngle = LerpedFloat.angular();
    public LerpedFloat clutchPedalMotion = LerpedFloat.linear();
    public LerpedFloat gasPedalMotion = LerpedFloat.linear();
    public LerpedFloat brakePedalMotion = LerpedFloat.linear();
    public LerpedFloat fuelDial = LerpedFloat.angular();
    public LerpedFloat rpmDial = LerpedFloat.angular();

    public EngineControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemStack getController() {
        return ItemStack.f_41583_;
    }

    public static Couple<RedstoneLinkNetworkHandler.Frequency> toFrequency(EngineControllerBlockEntity controller, int slot) {
        ItemStackHandler frequencyItems = controller.frequencyItems;
        return Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyItems.getStackInSlot(slot * 2)), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)frequencyItems.getStackInSlot(slot * 2 + 1)));
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.enginePos != null) {
            compound.m_128356_("EnginePos", this.enginePos.m_121878_());
        }
        compound.m_128359_("Shift", this.shift.name());
        compound.m_128379_("EngineStarted", this.engineStarted);
        compound.m_128365_("FrequencyItems", (Tag)this.frequencyItems.serializeNBT());
        if (this.user != null) {
            compound.m_128362_("User", this.user);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.enginePos = BlockPos.m_122022_((long)compound.m_128454_("EnginePos"));
        this.engineStarted = compound.m_128471_("EngineStarted");
        if (this.engineStarted && this.accelerationRate == 0) {
            this.accelerationRate = 4;
        }
        this.frequencyItems.deserializeNBT(compound.m_128469_("FrequencyItems"));
        this.shift = TransmissionUpgrade.TransmissionState.valueOf(compound.m_128461_("Shift"));
        this.user = compound.m_128403_("User") ? compound.m_128342_("User") : null;
        this.updateEngine();
    }

    public void shiftForward() {
        int max = TransmissionUpgrade.TransmissionState.values().length - 1;
        for (int i = 0; i < max; ++i) {
            TransmissionUpgrade.TransmissionState state = TransmissionUpgrade.TransmissionState.values()[i];
            if (state != this.shift || i + 1 > max) continue;
            this.shift = TransmissionUpgrade.TransmissionState.values()[i + 1];
            this.updateShift();
            break;
        }
        this.sendData();
        this.m_6596_();
    }

    public void updateShift() {
        BlockEntity blockEntity;
        if (this.enginePos != null && (blockEntity = this.f_58857_.m_7702_(this.enginePos)) instanceof AbstractSmallEngineBlockEntity) {
            BlockEntity blockEntity2;
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            be.getControllerBE().shift = this.shift;
            be.getControllerBE().clutchPressed = this.clutch;
            be.getControllerBE().updateGeneratedRotation();
            if (be.getControllerBE().engineLength() > 1 && (blockEntity2 = this.f_58857_.m_7702_(BlockPos.m_122022_((long)be.getControllerBE().engines.get(be.getControllerBE().engineLength() - 1)))) instanceof AbstractSmallEngineBlockEntity) {
                AbstractSmallEngineBlockEntity be2 = (AbstractSmallEngineBlockEntity)blockEntity2;
                be2.updateGeneratedRotation();
            }
        }
    }

    public void destroy() {
        super.destroy();
        Entity playerEntity = ((ServerLevel)this.f_58857_).m_8791_(this.user);
        if (playerEntity instanceof Player) {
            this.stopUsing((Player)playerEntity);
        }
    }

    public void shiftBack() {
        int max = TransmissionUpgrade.TransmissionState.values().length;
        for (int i = 0; i < max; ++i) {
            TransmissionUpgrade.TransmissionState state = TransmissionUpgrade.TransmissionState.values()[i];
            if (state != this.shift || i - 1 < 0) continue;
            this.shift = TransmissionUpgrade.TransmissionState.values()[i - 1];
            this.updateShift();
            break;
        }
    }

    public void tickAcceleration() {
        if (this.gas) {
            if (this.engineStarted && this.accelerationRate < 15) {
                ++this.accelerationRate;
                this.updateEngine();
            }
        } else if (!(this.accelerationRate <= 4 && this.engineStarted || this.accelerationRate <= 0)) {
            --this.accelerationRate;
            this.updateEngine();
        }
    }

    public void tickBraking() {
        if (this.brake && this.accelerationRate > 4) {
            --this.accelerationRate;
            this.updateEngine();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.tickAcceleration();
    }

    public static ItemStackHandler getFrequencyItems(EngineControllerBlockEntity be) {
        return be.frequencyItems;
    }

    public void handleInput(Collection<Integer> currentlyPressed, boolean press) {
        if (currentlyPressed.contains(4)) {
            this.clutch = press;
            this.sendData();
            this.m_6596_();
        }
        if (currentlyPressed.contains(0)) {
            this.gas = press;
            this.sendData();
            this.m_6596_();
        }
        if (currentlyPressed.contains(1)) {
            this.brake = press;
            this.sendData();
            this.m_6596_();
        }
    }

    public void toggleEngine() {
        this.engineStarted = !this.engineStarted;
        this.accelerationRate = this.engineStarted ? 4 : 0;
        this.updateEngine();
        this.sendData();
        this.m_6596_();
    }

    public void remove() {
        super.remove();
        this.disconnectEngine();
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::tryToggleActive);
            this.prevUser = this.user;
            this.tickRendering();
        }
        if (this.enginePos != null && this.engine == null && (blockEntity = this.f_58857_.m_7702_(this.enginePos)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be;
            this.engine = be = (AbstractSmallEngineBlockEntity)blockEntity;
            this.engine.getControllerBE().highestSignal = 4;
        }
        this.tickBraking();
        if (!this.f_58857_.f_46443_) {
            this.deactivatedThisTick = false;
            if (!(this.f_58857_ instanceof ServerLevel)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            Entity entity = ((ServerLevel)this.f_58857_).m_8791_(this.user);
            if (!(entity instanceof Player)) {
                this.stopUsing(null);
                return;
            }
            Player player = (Player)entity;
            if (!EngineControllerBlockEntity.playerInRange(player, this.f_58857_, this.f_58858_) || !EngineControllerBlockEntity.playerIsUsingEngineController(player)) {
                this.stopUsing(player);
            }
        }
    }

    public void updateEngine() {
        if (this.engine == null) {
            return;
        }
        this.engine.getControllerBE().engineController = this.m_58899_();
        this.engine.getControllerBE().highestSignal = this.accelerationRate;
        this.engine.getControllerBE().fuelInjectionRate = (float)this.engine.getControllerBE().highestSignal / 15.0f;
        this.engine.getControllerBE().updateRotation();
    }

    public void disconnectEngine() {
        if (this.engine == null) {
            return;
        }
        this.engine.getControllerBE().highestSignal = 0;
        this.engine.getControllerBE().engineController = null;
        this.engine.getControllerBE().updateGeneratedRotation();
    }

    public void tickRendering() {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        this.steeringWheelAngle.chase(this.isPressed(2) ? -40.0 : (this.isPressed(3) ? 40.0 : 0.0), 0.25, LerpedFloat.Chaser.EXP);
        this.clutchPedalMotion.chase(this.isPressed(4) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.gasPedalMotion.chase(this.isPressed(0) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.brakePedalMotion.chase(this.isPressed(1) ? 0.125 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        this.transmissionLeverAngle.chase(this.shift == TransmissionUpgrade.TransmissionState.REVERSE ? -20.0 : (double)(this.shift.value * 20.0f), 0.25, LerpedFloat.Chaser.EXP);
        this.fuelDial.chase(this.engine == null ? 0.0 : (double)this.engine.getControllerBE().fuelTank.getFluidAmount() / (double)this.engine.fuelTank.getCapacity() * 180.0, 0.25, LerpedFloat.Chaser.EXP);
        this.rpmDial.chase(this.engine == null ? 0.0 : (double)this.engine.getControllerBE().rpm / 6000.0 * 180.0, 0.25, LerpedFloat.Chaser.EXP);
        this.transmissionLeverAngle.tickChaser();
        this.steeringWheelAngle.tickChaser();
        this.clutchPedalMotion.tickChaser();
        this.gasPedalMotion.tickChaser();
        this.brakePedalMotion.tickChaser();
        this.fuelDial.tickChaser();
        this.rpmDial.tickChaser();
    }

    public boolean isPressed(int id) {
        return EngineControllerClientHandler.currentlyPressed.contains(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tryToggleActive() {
        if (this.user == null && Minecraft.m_91087_().f_91074_.m_20148_().equals(this.prevUser)) {
            EngineControllerClientHandler.deactivateInLectern();
        } else if (this.prevUser == null && Minecraft.m_91087_().f_91074_.m_20148_().equals(this.user)) {
            EngineControllerClientHandler.activateInLectern(this.f_58858_);
        }
    }

    public void tryStopUsing(Player player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    public static boolean playerIsUsingEngineController(Player player) {
        return player.getPersistentData().m_128441_("IsUsingEngineController");
    }

    public void tryStartUsing(Player player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !EngineControllerBlockEntity.playerIsUsingEngineController(player) && EngineControllerBlockEntity.playerInRange(player, this.f_58857_, this.f_58858_)) {
            this.startUsing(player);
        }
    }

    private void startUsing(Player player) {
        this.user = player.m_20148_();
        player.getPersistentData().m_128379_("IsUsingEngineController", true);
        this.sendData();
    }

    private void stopUsing(Player player) {
        this.user = null;
        if (player != null) {
            player.getPersistentData().m_128473_("IsUsingEngineController");
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public InteractionResult use(Player player) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        return InteractionResult.SUCCESS;
    }

    public boolean isUsedBy(Player player) {
        return this.hasUser() && this.user.equals(player.m_20148_());
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 0.4 * player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        return player.m_20238_(Vec3.m_82512_((Vec3i)pos)) < reach * reach;
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return EngineControllerMenu.create(pContainerId, pPlayerInventory, this);
    }
}

