/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller.packets;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerPacketBase;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerServerHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class EngineControllerInputPacket
extends EngineControllerPacketBase {
    private Collection<Integer> activatedButtons;
    private boolean press;

    public EngineControllerInputPacket(Collection<Integer> activatedButtons, boolean press) {
        this(activatedButtons, press, null);
    }

    public EngineControllerInputPacket(Collection<Integer> activatedButtons, boolean press, BlockPos lecternPos) {
        super(lecternPos);
        this.activatedButtons = activatedButtons;
        this.press = press;
    }

    public EngineControllerInputPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.activatedButtons = new ArrayList<Integer>();
        this.press = buffer.readBoolean();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.activatedButtons.add(buffer.m_130242_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.press);
        buffer.m_130130_(this.activatedButtons.size());
        this.activatedButtons.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
    }

    @Override
    protected void handleController(ServerPlayer player, EngineControllerBlockEntity controller) {
        UUID uniqueID = player.m_20148_();
        Level level = controller.m_58904_();
        BlockPos pos = controller.m_58899_();
        ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>> list = new ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>>();
        if (this.activatedButtons.contains(2)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 0));
        }
        if (this.activatedButtons.contains(3)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 1));
        }
        if (this.activatedButtons.contains(7)) {
            list.add(EngineControllerBlockEntity.toFrequency(controller, 2));
        }
        LinkedControllerServerHandler.receivePressed((LevelAccessor)level, (BlockPos)pos, (UUID)uniqueID, list, (boolean)this.press);
        controller.handleInput(this.activatedButtons, this.press);
    }
}

