/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.util;

import com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace.util.BlastFurnaceLayerPatterns;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BlastFurnaceLayer {
    private final Set<String> layerRotations;
    public static final int LAYER_SIZE = 5;
    public static final int LAYER_AREA = 25;

    public BlastFurnaceLayer(String layer) {
        if (layer == null || layer.length() != 25) {
            throw new IllegalArgumentException(String.format("Layer must be a non-null %s length string (got %s)", 25, layer == null ? "null" : Integer.valueOf(layer.length())));
        }
        this.layerRotations = Collections.unmodifiableSet(this.computeRotations(layer));
    }

    private Set<String> computeRotations(String baseLayer) {
        HashSet<String> rotations = new HashSet<String>();
        rotations.add(baseLayer);
        rotations.add(this.rotateSquare90(baseLayer));
        rotations.add(this.rotateSquare180(baseLayer));
        rotations.add(this.rotateSquare270(baseLayer));
        return rotations;
    }

    private String rotateSquare90(String baseLayer) {
        int size = (int)Math.sqrt(baseLayer.length());
        char[] rotated = new char[baseLayer.length()];
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                rotated[row * size + col] = baseLayer.charAt((size - 1 - col) * size + row);
            }
        }
        return new String(rotated);
    }

    private String rotateSquare180(String baseLayer) {
        return new StringBuilder(baseLayer).reverse().toString();
    }

    private String rotateSquare270(String baseLayer) {
        int size = (int)Math.sqrt(baseLayer.length());
        char[] rotated = new char[baseLayer.length()];
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                rotated[row * size + col] = baseLayer.charAt(col * size + (size - 1 - row));
            }
        }
        return new String(rotated);
    }

    public boolean matchesAnyPattern(Set<String> patterns) {
        return patterns.stream().anyMatch(pattern -> this.layerRotations.stream().anyMatch(rotation -> this.matchesWithWildcards((String)rotation, (String)pattern)));
    }

    private boolean matchesWithWildcards(String actualLayer, String pattern) {
        if (actualLayer.length() != pattern.length()) {
            return false;
        }
        for (int i = 0; i < actualLayer.length(); ++i) {
            char p = pattern.charAt(i);
            char a = actualLayer.charAt(i);
            if (p != '*' && p != a) {
                return false;
            }
            if (pattern.contains("T") && !actualLayer.contains("T")) {
                return false;
            }
            if (!pattern.contains("O") || actualLayer.contains("O")) continue;
            return false;
        }
        return true;
    }

    public boolean isBaseLayer() {
        return this.matchesAnyPattern(BlastFurnaceLayerPatterns.BASE_LAYERS);
    }

    public boolean isWallLayer() {
        return this.matchesAnyPattern(BlastFurnaceLayerPatterns.WALL_LAYERS);
    }

    public boolean isReinforced() {
        return this.matchesAnyPattern(BlastFurnaceLayerPatterns.REINFORCED_LAYERS);
    }
}

