/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.air_intake;

import com.drmangotea.tfmg.content.machinery.misc.air_intake.AirIntakeBlock;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AirIntakeBlockEntity
extends KineticBlockEntity
implements IWrenchable {
    private static final int SMALL_FAN_DIAMETER = 1;
    private static final int MEDIUM_FAN_DIAMETER = 2;
    private static final int LARGE_FAN_DIAMETER = 3;
    int diameter = 1;
    boolean isController = false;
    public boolean hasShaft = true;
    boolean isUsedByController = false;
    public BlockPos controller;
    public List<AirIntakeBlockEntity> blockEntities = new ArrayList<AirIntakeBlockEntity>();
    public float maxShaftSpeed = 0.0f;
    public float angle = 0.0f;
    public LerpedFloat visual_angle = LerpedFloat.angular();
    protected FluidTank tankInventory = this.createInventory();
    protected LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.tankInventory);

    public AirIntakeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        this.produceAir();
        this.updateVisuals();
        this.updateBlockState();
        this.validateController();
        this.updateShaftSpeed();
        this.validateMultiblock();
    }

    private void produceAir() {
        int production = (int)this.maxShaftSpeed * (this.diameter * this.diameter) / 40;
        if (this.tankInventory.getFluidAmount() + production <= this.tankInventory.getCapacity()) {
            this.tankInventory.setFluid(new FluidStack((Fluid)TFMGFluids.AIR.getSource(), production + this.tankInventory.getFluidAmount()));
        }
        if (this.isUsedByController) {
            this.refreshCapability();
            this.sendData();
            this.m_6596_();
        }
    }

    private void updateVisuals() {
        if (this.diameter == 3) {
            this.visual_angle.chase((double)this.angle, (double)0.1f, LerpedFloat.Chaser.EXP);
            this.visual_angle.tickChaser();
        }
        this.angle += this.maxShaftSpeed / 2.0f;
        this.angle %= 360.0f;
    }

    private void updateBlockState() {
        if (!((Boolean)this.m_58900_().m_61143_((Property)AirIntakeBlock.INVISIBLE)).booleanValue() && (this.isController || this.isUsedByController)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AirIntakeBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (!this.isController && !this.isUsedByController) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AirIntakeBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private void validateController() {
        if (this.controller == null) {
            this.controller = this.m_58899_();
        }
        this.diameter = this.getPossibleDiameter();
        if (this.controller == this.m_58899_()) {
            this.isUsedByController = false;
        } else {
            this.isUsedByController = true;
            this.isController = false;
        }
        if (this.diameter == 1) {
            this.isController = false;
        }
        if (!(this.f_58857_.m_7702_(this.controller) instanceof AirIntakeBlockEntity)) {
            this.isUsedByController = false;
            this.controller = this.m_58899_();
        } else if (!((AirIntakeBlockEntity)this.f_58857_.m_7702_((BlockPos)this.controller)).isController) {
            this.isUsedByController = false;
        }
        this.validateControllerDistance();
    }

    private void validateControllerDistance() {
        if (this.controller == null || this.f_58857_.m_7702_(this.controller) == null) {
            return;
        }
        AirIntakeBlockEntity controllerBE = (AirIntakeBlockEntity)this.f_58857_.m_7702_(this.controller);
        if (controllerBE.diameter == 2) {
            int x = Math.abs(this.m_58899_().m_123341_() - this.controller.m_123341_());
            int y = Math.abs(this.m_58899_().m_123342_() - this.controller.m_123342_());
            int z = Math.abs(this.m_58899_().m_123343_() - this.controller.m_123343_());
            if (x > 1 || y > 1 || z > 1) {
                this.isUsedByController = false;
                this.controller = this.m_58899_();
            }
        } else if (controllerBE.diameter == 1) {
            this.isUsedByController = false;
            this.controller = this.m_58899_();
        }
    }

    private void updateShaftSpeed() {
        this.maxShaftSpeed = Math.abs(this.getSpeed());
        if (this.diameter > 1) {
            for (AirIntakeBlockEntity be : this.blockEntities) {
                float testedSpeed = Math.abs(be.getSpeed());
                if (!(testedSpeed > this.maxShaftSpeed)) continue;
                this.maxShaftSpeed = testedSpeed;
            }
        }
    }

    private void validateMultiblock() {
        if (this.isUsedByController) {
            return;
        }
        if (this.diameter == 2 && this.blockEntities.size() != 4 || this.diameter == 3 && this.blockEntities.size() != 9) {
            return;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction direction = context.m_43719_();
        if (direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_()) {
            this.hasShaft = !this.hasShaft;
        }
        return InteractionResult.SUCCESS;
    }

    public void setController(BlockPos controllerPos) {
        this.controller = controllerPos;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
            this.sendData();
            this.m_6596_();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void refreshCapability() {
        FluidTank handlerForCapability = this.controller == null || this.controller == this.m_58899_() ? this.tankInventory : (this.f_58857_.m_7702_(this.controller) != null ? ((AirIntakeBlockEntity)this.f_58857_.m_7702_((BlockPos)this.controller)).tankInventory : this.tankInventory);
        FluidTank finalHandlerForCapability = handlerForCapability;
        this.fluidCapability = LazyOptional.of(() -> AirIntakeBlockEntity.lambda$refreshCapability$1((IFluidHandler)finalHandlerForCapability));
    }

    public int getPossibleDiameter() {
        if (this.controller != this.m_58899_()) {
            return 1;
        }
        boolean canBeMedium = this.checkMediumDiameter();
        boolean canBeLarge = this.checkLargeDiameter();
        if (canBeLarge) {
            this.setupMultiblock(3);
            return 3;
        }
        if (canBeMedium) {
            this.setupMultiblock(2);
            return 2;
        }
        this.controller = this.m_58899_();
        this.isController = false;
        return 1;
    }

    private boolean checkMediumDiameter() {
        ArrayList<BlockPos> checkedPosses = new ArrayList<BlockPos>();
        BlockPos checkedPos = this.m_58899_();
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                checkedPosses.add(checkedPos);
                checkedPos = direction.m_122434_().m_122479_() ? checkedPos.m_7494_() : checkedPos.m_122029_();
            }
            if (direction.m_122434_().m_122479_()) {
                checkedPos = checkedPos.m_6625_(2);
                checkedPos = checkedPos.m_121945_(direction.m_122427_());
                continue;
            }
            checkedPos = checkedPos.m_122025_(2);
            checkedPos = checkedPos.m_122019_();
        }
        for (BlockPos pos : checkedPosses) {
            if (!(this.f_58857_.m_7702_(pos) instanceof AirIntakeBlockEntity)) {
                return false;
            }
            AirIntakeBlockEntity checkedBE = (AirIntakeBlockEntity)this.f_58857_.m_7702_(pos);
            if (pos != this.m_58899_() && checkedBE.isController) {
                return false;
            }
            if (checkedBE.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING) == this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLargeDiameter() {
        ArrayList<BlockPos> checkedPosses = new ArrayList<BlockPos>();
        BlockPos checkedPos = this.m_58899_();
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                checkedPosses.add(checkedPos);
                checkedPos = direction.m_122434_().m_122479_() ? checkedPos.m_7494_() : checkedPos.m_122029_();
            }
            if (direction.m_122434_().m_122479_()) {
                checkedPos = checkedPos.m_6625_(3);
                checkedPos = checkedPos.m_121945_(direction.m_122427_());
                continue;
            }
            checkedPos = checkedPos.m_122025_(3);
            checkedPos = checkedPos.m_122019_();
        }
        for (BlockPos pos : checkedPosses) {
            if (!(this.f_58857_.m_7702_(pos) instanceof AirIntakeBlockEntity)) {
                return false;
            }
            AirIntakeBlockEntity checkedBE = (AirIntakeBlockEntity)this.f_58857_.m_7702_(pos);
            if (checkedBE.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING) == this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)) continue;
            return false;
        }
        return true;
    }

    private void setupMultiblock(int diameter) {
        this.blockEntities.clear();
        List<BlockPos> positions = this.getMultiblockPositions(diameter);
        for (BlockPos pos : positions) {
            AirIntakeBlockEntity be = (AirIntakeBlockEntity)this.f_58857_.m_7702_(pos);
            if (be.isUsedByController && be.controller != this.m_58899_() && pos != this.m_58899_()) {
                be.isUsedByController = true;
                be.isController = false;
                be.controller = this.m_58899_();
            }
            be.setController(this.m_58899_());
            this.blockEntities.add(be);
        }
        this.controller = this.m_58899_();
        this.isController = true;
    }

    private List<BlockPos> getMultiblockPositions(int diameter) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos checkedPos = this.m_58899_();
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        int size = diameter == 2 ? 2 : 3;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                positions.add(checkedPos);
                checkedPos = direction.m_122434_().m_122479_() ? checkedPos.m_7494_() : checkedPos.m_122029_();
            }
            if (direction.m_122434_().m_122479_()) {
                checkedPos = checkedPos.m_6625_(size);
                checkedPos = checkedPos.m_121945_(direction.m_122427_());
                continue;
            }
            checkedPos = checkedPos.m_122025_(size);
            checkedPos = checkedPos.m_122019_();
        }
        return positions;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(3.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(8000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.AIR.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.m_6596_();
        this.sendData();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.diameter = compound.m_128451_("Diameter");
        this.isController = compound.m_128471_("IsController");
        this.isUsedByController = compound.m_128471_("IsUsed");
        this.hasShaft = compound.m_128471_("HasShaft");
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Diameter", this.diameter);
        compound.m_128379_("IsController", this.isController);
        compound.m_128379_("IsUsed", this.isUsedByController);
        compound.m_128379_("HasShaft", this.hasShaft);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
    }

    private static /* synthetic */ IFluidHandler lambda$refreshCapability$1(IFluidHandler finalHandlerForCapability) {
        return finalHandlerForCapability;
    }
}

