/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.gas_lamp;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.gas_lamp.GasLampBlock;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GasLampBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    public int lightTimer = 0;

    public GasLampBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1500, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_205067_(TFMGTags.TFMGFluidTags.FLAMMABLE.tag) || stack.getFluid().m_205067_(TFMGTags.TFMGFluidTags.FUEL.tag);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        this.sendData();
        this.m_6596_();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    public void tick() {
        super.tick();
        if (this.tankInventory.isEmpty() || !this.tankInventory.isFluidValid(this.tankInventory.getFluid())) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GasLampBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
            return;
        }
        if (this.tankInventory.getFluidAmount() > 0) {
            if (this.f_58857_.f_46441_.m_188503_(20) == 0) {
                this.tankInventory.drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            this.lightTimer = 100;
        }
        if (this.lightTimer > 0) {
            --this.lightTimer;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GasLampBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

