/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base.FluidReservoir;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.pumpjack.base.TestSavedData;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class TestSavedDataManager {
    public List<FluidReservoir> list = new ArrayList<FluidReservoir>();
    private TestSavedData savedData;

    public FluidReservoir getReservoirFor(long pos) {
        for (FluidReservoir reservoir : TFMG.DEPOSITS.list) {
            if (!reservoir.deposits.contains(pos)) continue;
            return reservoir;
        }
        return null;
    }

    public void removeDeposit(long pos) {
        for (FluidReservoir reservoir : TFMG.DEPOSITS.list) {
            if (!reservoir.deposits.contains(pos)) continue;
            reservoir.deposits.remove(pos);
            if (reservoir.deposits.isEmpty()) {
                TFMG.DEPOSITS.list.remove(reservoir);
            }
            return;
        }
    }

    public void removeEmptyDeposits() {
        TFMG.DEPOSITS.list.removeIf(reservoir -> reservoir.oilReserves == 0);
    }

    public boolean isReservoirNearby(BlockPos pos) {
        for (int x = -32; x < 32; ++x) {
            for (int z = -32; z < 32; ++z) {
                BlockPos checkedPos = pos.m_7918_(x, 0, z);
                for (int i = 0; i < TFMG.DEPOSITS.list.size(); ++i) {
                    FluidReservoir reservoir = TFMG.DEPOSITS.list.get(i);
                    if (reservoir.id != checkedPos.m_121878_()) continue;
                    TFMG.DEPOSITS.list.get((int)i).deposits.add(pos.m_121878_());
                    return true;
                }
            }
        }
        return false;
    }

    public void addDeposit(Level level, long pos) {
        FluidReservoir reservoir2;
        if (!level.m_8055_(BlockPos.m_122022_((long)pos)).m_60713_((Block)TFMGBlocks.OIL_DEPOSIT.get())) {
            return;
        }
        if (TestSavedDataManager.containsDeposit(pos)) {
            return;
        }
        for (FluidReservoir reservoir2 : TFMG.DEPOSITS.list) {
            if (reservoir2.id == pos || !this.isReservoirNearby(BlockPos.m_122022_((long)pos))) continue;
            return;
        }
        RandomSource randomSource = level.f_46441_;
        reservoir2 = new FluidReservoir(pos);
        reservoir2.oilReserves = randomSource.m_216339_(1000, ((Integer)TFMGConfigs.common().worldgen.depositMaxReserves.get()).intValue());
        if (!reservoir2.deposits.isEmpty()) {
            TFMG.DEPOSITS.list.add(reservoir2);
            TFMG.DEPOSITS.markDirty();
        }
    }

    public void removeData() {
        TFMG.DEPOSITS.markDirty();
    }

    public static boolean containsDeposit(long pos) {
        BlockPos findPos = BlockPos.m_122022_((long)pos);
        for (FluidReservoir reservoir : TFMG.DEPOSITS.list) {
            for (long deposit : reservoir.deposits) {
                if (deposit != pos) continue;
                return true;
            }
            if (!reservoir.deposits.contains(pos)) continue;
            return true;
        }
        return false;
    }

    public void levelLoaded(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null || server.m_129783_() != level) {
            return;
        }
        this.list = new ArrayList<FluidReservoir>();
        this.savedData = null;
        this.loadLogisticsData(server);
    }

    private void loadLogisticsData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = TestSavedData.load(server);
        this.list = this.savedData.getLogisticsNetworks();
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.m_77762_();
        }
    }
}

