/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.datagen.recipes;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGRegistrate;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.datagen.recipes.builder.IndustrialBlastingRecipeBuilder;
import com.drmangotea.tfmg.datagen.recipes.builder.VatMachineRecipeBuilder;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

@ParametersAreNonnullByDefault
public class TFMGRecipeProvider
extends RecipeProvider {
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public TFMGRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.all.forEach(c -> c.register(consumer));
        TFMG.LOGGER.info("{} registered {} recipe{}", new Object[]{this.m_6055_(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    public GeneratedRecipe createIndustrialBlastingRecipe(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<IndustrialBlastingRecipeBuilder> transform, int hotAirUsage) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)TFMGRecipeTypes.INDUSTRIAL_BLASTING.getSerializer();
        GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((IndustrialBlastingRecipeBuilder)((Object)((Object)transform.apply((IndustrialBlastingRecipeBuilder)new IndustrialBlastingRecipeBuilder(serializer.getFactory(), hotAirUsage, new ResourceLocation(namespace, CatnipServices.REGISTRIES.getKeyOrThrow(itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public GeneratedRecipe createIndustrialBlastingRecipe(Supplier<ItemLike> singleIngredient, UnaryOperator<IndustrialBlastingRecipeBuilder> transform, int hotAirUsage) {
        return this.createIndustrialBlastingRecipe("tfmg", singleIngredient, transform, hotAirUsage);
    }

    protected <T extends ProcessingRecipe<?>> GeneratedRecipe createIndustrialBlastingRecipeWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<IndustrialBlastingRecipeBuilder> transform, int hotAirUsage) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)TFMGRecipeTypes.INDUSTRIAL_BLASTING.getSerializer();
        GeneratedRecipe generatedRecipe = c -> ((IndustrialBlastingRecipeBuilder)((Object)((Object)transform.apply(new IndustrialBlastingRecipeBuilder(serializer.getFactory(), hotAirUsage, (ResourceLocation)name.get()))))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public GeneratedRecipe createIndustrialBlastingRecipe(ResourceLocation name, UnaryOperator<IndustrialBlastingRecipeBuilder> transform, int hotAirUsage) {
        return this.createIndustrialBlastingRecipeWithDeferredId(() -> name, transform, hotAirUsage);
    }

    public GeneratedRecipe createIndustrialBlastingRecipe(String name, UnaryOperator<IndustrialBlastingRecipeBuilder> transform, int hotAirUsage) {
        return this.createIndustrialBlastingRecipe(TFMG.asResource(name), transform, hotAirUsage);
    }

    public GeneratedRecipe createVatRecipe(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<VatMachineRecipeBuilder> transform, VatMachineRecipeBuilder.VatRecipeParams params) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)TFMGRecipeTypes.VAT_MACHINE_RECIPE.getSerializer();
        GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((VatMachineRecipeBuilder)((Object)((Object)transform.apply((VatMachineRecipeBuilder)new VatMachineRecipeBuilder(serializer.getFactory(), params, new ResourceLocation(namespace, CatnipServices.REGISTRIES.getKeyOrThrow(itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public GeneratedRecipe createVatRecipe(Supplier<ItemLike> singleIngredient, UnaryOperator<VatMachineRecipeBuilder> transform, VatMachineRecipeBuilder.VatRecipeParams params) {
        return this.createVatRecipe("tfmg", singleIngredient, transform, params);
    }

    protected <T extends ProcessingRecipe<?>> GeneratedRecipe createVatRecipeWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<VatMachineRecipeBuilder> transform, VatMachineRecipeBuilder.VatRecipeParams params) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)TFMGRecipeTypes.VAT_MACHINE_RECIPE.getSerializer();
        GeneratedRecipe generatedRecipe = c -> ((VatMachineRecipeBuilder)((Object)((Object)transform.apply(new VatMachineRecipeBuilder(serializer.getFactory(), params, (ResourceLocation)name.get()))))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public GeneratedRecipe createVatRecipe(ResourceLocation name, UnaryOperator<VatMachineRecipeBuilder> transform, VatMachineRecipeBuilder.VatRecipeParams params) {
        return this.createVatRecipeWithDeferredId(() -> name, transform, params);
    }

    public GeneratedRecipe createVatRecipe(String name, UnaryOperator<VatMachineRecipeBuilder> transform, VatMachineRecipeBuilder.VatRecipeParams params) {
        return this.createVatRecipe(TFMG.asResource(name), transform, params);
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(Consumer<FinishedRecipe> var1);
    }

    public static class F {
        public static Fluid air() {
            return (Fluid)TFMGFluids.AIR.get();
        }

        public static Fluid hotAir() {
            return (Fluid)TFMGFluids.HOT_AIR.get();
        }

        public static Fluid carbonDioxide() {
            return (Fluid)TFMGFluids.CARBON_DIOXIDE.get();
        }

        public static Fluid ethylene() {
            return (Fluid)TFMGFluids.ETHYLENE.get();
        }

        public static Fluid propylene() {
            return (Fluid)TFMGFluids.PROPYLENE.get();
        }

        public static Fluid propane() {
            return (Fluid)TFMGFluids.PROPANE.get();
        }

        public static Fluid hydrogen() {
            return (Fluid)TFMGFluids.HYDROGEN.get();
        }

        public static Fluid butane() {
            return (Fluid)TFMGFluids.BUTANE.get();
        }

        public static Fluid lpg() {
            return (Fluid)TFMGFluids.LPG.get();
        }

        public static Fluid neon() {
            return (Fluid)TFMGFluids.NEON.get();
        }

        public static Fluid blastFurnaceGas() {
            return (Fluid)TFMGFluids.FURNACE_GAS.get();
        }

        public static Fluid crudeOil() {
            return (Fluid)TFMGFluids.CRUDE_OIL.get();
        }

        public static Fluid heavyOil() {
            return (Fluid)TFMGFluids.HEAVY_OIL.get();
        }

        public static Fluid lubricationOil() {
            return (Fluid)TFMGFluids.LUBRICATION_OIL.get();
        }

        public static Fluid napalm() {
            return (Fluid)TFMGFluids.NAPALM.get();
        }

        public static Fluid naphtha() {
            return (Fluid)TFMGFluids.NAPHTHA.get();
        }

        public static Fluid kerosene() {
            return (Fluid)TFMGFluids.KEROSENE.get();
        }

        public static Fluid gasoline() {
            return (Fluid)TFMGFluids.GASOLINE.get();
        }

        public static Fluid diesel() {
            return (Fluid)TFMGFluids.DIESEL.get();
        }

        public static Fluid creosote() {
            return (Fluid)TFMGFluids.CREOSOTE.get();
        }

        public static Fluid water() {
            return Fluids.f_76193_;
        }

        public static Fluid coolingFluid() {
            return (Fluid)TFMGFluids.COOLING_FLUID.get();
        }

        public static Fluid sulfuricAcid() {
            return (Fluid)TFMGFluids.SULFURIC_ACID.get();
        }

        public static Fluid liquidConcrete() {
            return (Fluid)TFMGFluids.LIQUID_CONCRETE.get();
        }

        public static Fluid liquidAsphalt() {
            return (Fluid)TFMGFluids.LIQUID_ASPHALT.get();
        }

        public static Fluid liquidPlastic() {
            return (Fluid)TFMGFluids.MOLTEN_PLASTIC.get();
        }

        public static Fluid moltenSteel() {
            return (Fluid)TFMGFluids.MOLTEN_STEEL.get();
        }

        public static Fluid moltenSlag() {
            return (Fluid)TFMGFluids.MOLTEN_SLAG.get();
        }

        public static Fluid potion() {
            return (Fluid)AllFluids.POTION.get();
        }

        public static ItemLike airTank() {
            return TFMGRegistrate.getBucket("air");
        }

        public static ItemLike hotAirTank() {
            return TFMGRegistrate.getBucket("hot_air");
        }

        public static ItemLike carbonDioxideTank() {
            return TFMGRegistrate.getBucket("carbon_dioxide");
        }

        public static ItemLike ethyleneTank() {
            return TFMGRegistrate.getBucket("ethylene");
        }

        public static ItemLike propyleneTank() {
            return TFMGRegistrate.getBucket("propylene");
        }

        public static ItemLike propaneTank() {
            return TFMGRegistrate.getBucket("propane");
        }

        public static ItemLike hydrogenTank() {
            return TFMGRegistrate.getBucket("hydrogen");
        }

        public static ItemLike butaneTank() {
            return TFMGRegistrate.getBucket("butane");
        }

        public static ItemLike lpgTank() {
            return TFMGRegistrate.getBucket("lpg");
        }

        public static ItemLike neonTank() {
            return TFMGRegistrate.getBucket("neon");
        }

        public static ItemLike furnaceGasTank() {
            return TFMGRegistrate.getBucket("furnace_gas");
        }

        public static ItemLike crudeOilBucket() {
            return TFMGRegistrate.getBucket("crude_oil");
        }

        public static ItemLike heavyOilBucket() {
            return TFMGRegistrate.getBucket("heavy_oil");
        }

        public static ItemLike lubricationOilBucket() {
            return TFMGRegistrate.getBucket("lubrication_oil");
        }

        public static ItemLike napalmBucket() {
            return TFMGRegistrate.getBucket("napalm");
        }

        public static ItemLike naphthaBucket() {
            return TFMGRegistrate.getBucket("naphtha");
        }

        public static ItemLike keroseneBucket() {
            return TFMGRegistrate.getBucket("kerosene");
        }

        public static ItemLike gasolineBucket() {
            return TFMGRegistrate.getBucket("gasoline");
        }

        public static ItemLike dieselBucket() {
            return TFMGRegistrate.getBucket("diesel");
        }

        public static ItemLike creosoteBucket() {
            return TFMGRegistrate.getBucket("creosote");
        }

        public static ItemLike coolingFluidBucket() {
            return TFMGRegistrate.getBucket("cooling_fluid");
        }

        public static ItemLike sulfuricAcidBucket() {
            return TFMGRegistrate.getBucket("sulfuric_acid");
        }

        public static ItemLike liquidConcreteBucket() {
            return TFMGRegistrate.getBucket("liquid_concrete");
        }

        public static ItemLike liquidAsphaltBucket() {
            return TFMGRegistrate.getBucket("liquid_asphalt");
        }

        public static ItemLike liquidPlasticBucket() {
            return TFMGRegistrate.getBucket("liquid_plastic");
        }

        public static ItemLike moltenSteelBucket() {
            return TFMGRegistrate.getBucket("molten_steel");
        }

        public static ItemLike moltenSlagBucket() {
            return TFMGRegistrate.getBucket("molten_slag");
        }

        public static ItemLike waterBucket() {
            return Fluids.f_76193_.m_6859_();
        }
    }

    public static class I {
        public static ItemLike tfmgSteelIngot() {
            return TFMGItems.STEEL_INGOT;
        }

        public static ItemLike coal() {
            return Items.f_42413_;
        }

        public static ItemLike charcoal() {
            return Items.f_42414_;
        }

        public static ItemLike coalCoke() {
            return (ItemLike)TFMGItems.COAL_COKE.get();
        }

        public static ItemLike coalCokeDust() {
            return (ItemLike)TFMGItems.COAL_COKE_DUST.get();
        }

        public static TagKey<Item> steelIngot() {
            return TFMGTags.forgeItemTag("ingots/steel");
        }

        public static TagKey<Item> steelNugget() {
            return TFMGTags.forgeItemTag("nuggets/steel");
        }

        public static TagKey<Item> steelSheet() {
            return TFMGTags.forgeItemTag("plates/steel");
        }

        public static TagKey<Item> steelBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/steel");
        }

        public static TagKey<Item> aluminumIngot() {
            return TFMGTags.forgeItemTag("ingots/aluminum");
        }

        public static TagKey<Item> aluminumNugget() {
            return TFMGTags.forgeItemTag("nuggets/aluminum");
        }

        public static TagKey<Item> aluminumBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/aluminum");
        }

        public static TagKey<Item> aluminumSheet() {
            return TFMGTags.forgeItemTag("plates/aluminum");
        }

        public static TagKey<Item> castIronIngot() {
            return TFMGTags.forgeItemTag("ingots/cast_iron");
        }

        public static TagKey<Item> castIronNugget() {
            return TFMGTags.forgeItemTag("nuggets/cast_iron");
        }

        public static TagKey<Item> castIronBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/cast_iron");
        }

        public static TagKey<Item> castIronSheet() {
            return TFMGTags.forgeItemTag("plates/cast_iron");
        }

        public static TagKey<Item> leadIngot() {
            return TFMGTags.forgeItemTag("ingots/lead");
        }

        public static TagKey<Item> leadNugget() {
            return TFMGTags.forgeItemTag("nuggets/lead");
        }

        public static TagKey<Item> leadSheet() {
            return TFMGTags.forgeItemTag("plates/lead");
        }

        public static TagKey<Item> leadBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/lead");
        }

        public static TagKey<Item> nickelIngot() {
            return TFMGTags.forgeItemTag("ingots/nickel");
        }

        public static TagKey<Item> nickelNugget() {
            return TFMGTags.forgeItemTag("nuggets/nickel");
        }

        public static TagKey<Item> nickelBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/nickel");
        }

        public static TagKey<Item> nickelSheet() {
            return TFMGTags.forgeItemTag("plates/nickel");
        }

        public static TagKey<Item> lithiumIngot() {
            return TFMGTags.forgeItemTag("ingots/lithium");
        }

        public static TagKey<Item> lithiumNugget() {
            return TFMGTags.forgeItemTag("nuggets/lithium");
        }

        public static TagKey<Item> lithiumBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/lithium");
        }

        public static TagKey<Item> constantanIngot() {
            return TFMGTags.forgeItemTag("ingots/constantan");
        }

        public static TagKey<Item> constantanNugget() {
            return TFMGTags.forgeItemTag("nuggets/constantan");
        }

        public static TagKey<Item> constantanBlock() {
            return TFMGTags.forgeItemTag("storage_blocks/constantan");
        }

        public static TagKey<Item> copperWire() {
            return TFMGTags.forgeItemTag("wires/copper");
        }

        public static TagKey<Item> constantanWire() {
            return TFMGTags.forgeItemTag("wires/constantan");
        }

        public static TagKey<Item> aluminumWire() {
            return TFMGTags.forgeItemTag("wires/aluminum");
        }

        public static ItemLike bitumen() {
            return (ItemLike)TFMGItems.BITUMEN.get();
        }

        public static ItemLike cinderFlour() {
            return (ItemLike)AllItems.CINDER_FLOUR.get();
        }

        public static ItemLike plasticSheet() {
            return (ItemLike)TFMGItems.PLASTIC_SHEET.get();
        }

        public static ItemLike crimsite() {
            return (ItemLike)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get();
        }

        public static ItemLike thermitePowder() {
            return (ItemLike)TFMGItems.THERMITE_POWDER.get();
        }

        public static ItemLike crushedRawAluminum() {
            return (ItemLike)AllItems.CRUSHED_BAUXITE.get();
        }

        public static ItemLike experienceNugget() {
            return (ItemLike)AllItems.EXP_NUGGET.get();
        }

        public static ItemLike capacitor() {
            return TFMGItems.CAPACITOR;
        }

        public static ItemLike copperSulfate() {
            return (ItemLike)TFMGItems.COPPER_SULFATE.get();
        }

        public static ItemLike boneMeal() {
            return Items.f_42499_;
        }

        public static ItemLike blueDye() {
            return Items.f_42494_;
        }

        public static ItemLike greenDye() {
            return Items.f_42496_;
        }

        public static ItemLike cyanDye() {
            return Items.f_42492_;
        }

        public static ItemLike crushedRawLead() {
            return (ItemLike)AllItems.CRUSHED_LEAD.get();
        }

        public static ItemLike limestone() {
            return (ItemLike)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get();
        }

        public static ItemLike limesand() {
            return (ItemLike)TFMGItems.LIMESAND.get();
        }

        public static ItemLike dirt() {
            return Items.f_42329_;
        }

        public static ItemLike rebar() {
            return (ItemLike)TFMGItems.REBAR.get();
        }

        public static ItemLike nitrateDust() {
            return (ItemLike)TFMGItems.NITRATE_DUST.get();
        }

        public static ItemLike sulfurDust() {
            return (ItemLike)TFMGItems.SULFUR_DUST.get();
        }

        public static ItemLike bucket() {
            return Items.f_42446_;
        }

        public static ItemLike bottle() {
            return Items.f_42590_;
        }

        public static ItemLike potato() {
            return Items.f_42620_;
        }

        public static ItemLike napalmPotato() {
            return (ItemLike)TFMGItems.NAPALM_POTATO.get();
        }

        public static ItemLike heavyMachineryCasing() {
            return (ItemLike)TFMGBlocks.HEAVY_MACHINERY_CASING.get();
        }

        public static ItemLike steelCasing() {
            return (ItemLike)TFMGBlocks.STEEL_CASING.get();
        }

        public static ItemLike aluminumCasing() {
            return (ItemLike)TFMGBlocks.ALUMINUM_CASING.get();
        }

        public static ItemLike lightBulb() {
            return (ItemLike)TFMGBlocks.LIGHT_BULB.get();
        }

        public static ItemLike heavyPlate() {
            return (ItemLike)TFMGItems.HEAVY_PLATE.get();
        }

        public static ItemLike castIronSheetTFMG() {
            return (ItemLike)TFMGItems.CAST_IRON_SHEET.get();
        }

        public static ItemLike nickelSheetTFMG() {
            return (ItemLike)TFMGItems.NICKEL_SHEET.get();
        }

        public static ItemLike leadSheetTFMG() {
            return (ItemLike)TFMGItems.LEAD_SHEET.get();
        }

        public static ItemLike aluminumSheetTFMG() {
            return (ItemLike)TFMGItems.ALUMINUM_SHEET.get();
        }

        public static ItemLike crushedRawIron() {
            return (ItemLike)AllItems.CRUSHED_IRON.get();
        }

        public static ItemLike ironIngot() {
            return Items.f_42416_;
        }

        public static ItemLike clayBall() {
            return Items.f_42461_;
        }

        public static ItemLike sand() {
            return Items.f_41830_;
        }

        public static ItemLike gravel() {
            return Items.f_41832_;
        }

        public static ItemLike concreteMixture() {
            return (ItemLike)TFMGItems.CONCRETE_MIXTURE.get();
        }

        public static ItemLike asphaltMixture() {
            return (ItemLike)TFMGItems.ASPHALT_MIXTURE.get();
        }

        public static ItemLike slag() {
            return (ItemLike)TFMGItems.SLAG.get();
        }

        public static ItemLike gunpowder() {
            return Items.f_42403_;
        }

        public static ItemLike steelTank() {
            return TFMGBlocks.STEEL_FLUID_TANK;
        }

        public static ItemLike castIronTank() {
            return TFMGBlocks.CAST_IRON_FLUID_TANK;
        }

        public static ItemLike circuitBoard() {
            return TFMGItems.CIRCUIT_BOARD;
        }

        public static ItemLike cement() {
            return TFMGBlocks.CEMENT;
        }

        public static ItemLike aluminumTank() {
            return TFMGBlocks.ALUMINUM_FLUID_TANK;
        }

        public static ItemLike syntheticLeather() {
            return (ItemLike)TFMGItems.SYNTHETIC_LEATHER.get();
        }

        public static ItemLike engineChamber() {
            return (ItemLike)TFMGItems.ENGINE_CYLINDER.get();
        }

        public static ItemLike screw() {
            return (ItemLike)TFMGItems.SCREW.get();
        }

        public static ItemLike steelMechanism() {
            return (ItemLike)TFMGItems.STEEL_MECHANISM.get();
        }

        public static ItemLike industrialPipe() {
            return (ItemLike)TFMGBlocks.INDUSTRIAL_PIPE.get();
        }

        public static ItemLike steelPipe() {
            return (ItemLike)TFMGPipes.TFMG_PIPES.get((Object)TFMGPipes.PipeMaterial.STEEL).get(0);
        }

        public static ItemLike brassPipe() {
            return (ItemLike)TFMGPipes.TFMG_PIPES.get((Object)TFMGPipes.PipeMaterial.BRASS).get(0);
        }

        public static ItemLike castIronPipe() {
            return (ItemLike)TFMGPipes.TFMG_PIPES.get((Object)TFMGPipes.PipeMaterial.CAST_IRON).get(0);
        }

        public static ItemLike aluminumPipe() {
            return (ItemLike)TFMGPipes.TFMG_PIPES.get((Object)TFMGPipes.PipeMaterial.ALUMINUM).get(0);
        }

        public static ItemLike plasticPipe() {
            return (ItemLike)TFMGPipes.TFMG_PIPES.get((Object)TFMGPipes.PipeMaterial.PLASTIC).get(0);
        }

        public static ItemLike magneticIngot() {
            return (ItemLike)TFMGItems.MAGNETIC_ALLOY_INGOT.get();
        }

        public static ItemLike magnet() {
            return (ItemLike)TFMGItems.MAGNET.get();
        }

        public static TagKey<Item> redstone() {
            return Tags.Items.DUSTS_REDSTONE;
        }

        public static TagKey<Item> planks() {
            return ItemTags.f_13168_;
        }

        public static TagKey<Item> woodSlab() {
            return ItemTags.f_13175_;
        }

        public static TagKey<Item> log() {
            return ItemTags.f_13181_;
        }

        public static TagKey<Item> gold() {
            return AllTags.forgeItemTag((String)"ingots/gold");
        }

        public static TagKey<Item> string() {
            return AllTags.forgeItemTag((String)"string");
        }

        public static ItemLike propeller() {
            return (ItemLike)AllItems.PROPELLER.get();
        }

        public static ItemLike framedGlass() {
            return AllPaletteBlocks.FRAMED_GLASS;
        }

        public static ItemLike steelTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(0).get();
        }

        public static ItemLike steelFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(0).get();
        }

        public static ItemLike aluminumTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(1).get();
        }

        public static ItemLike aluminumFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(1).get();
        }

        public static ItemLike castIronTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(2).get();
        }

        public static ItemLike castIronFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(2).get();
        }

        public static ItemLike leadTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(3).get();
        }

        public static ItemLike leadFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(3).get();
        }

        public static ItemLike nickelTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(4).get();
        }

        public static ItemLike nickelFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(4).get();
        }

        public static ItemLike constantanTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(5).get();
        }

        public static ItemLike constantanFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(5).get();
        }

        public static ItemLike copperTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(6).get();
        }

        public static ItemLike copperFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(6).get();
        }

        public static ItemLike zincTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(7).get();
        }

        public static ItemLike zincFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(7).get();
        }

        public static ItemLike brassTruss() {
            return (ItemLike)TFMGBlocks.TRUSSES.get(8).get();
        }

        public static ItemLike brassFrame() {
            return (ItemLike)TFMGBlocks.FRAMES.get(8).get();
        }

        public static TagKey<Item> goldSheet() {
            return AllTags.forgeItemTag((String)"plates/gold");
        }

        public static TagKey<Item> stone() {
            return Tags.Items.STONE;
        }

        public static ItemLike andesite() {
            return (ItemLike)AllItems.ANDESITE_ALLOY.get();
        }

        public static ItemLike fireproofBricks() {
            return (ItemLike)TFMGBlocks.FIREPROOF_BRICKS.get();
        }

        public static ItemLike shaft() {
            return (ItemLike)AllBlocks.SHAFT.get();
        }

        public static ItemLike cog() {
            return (ItemLike)AllBlocks.COGWHEEL.get();
        }

        public static ItemLike rubber() {
            return (ItemLike)TFMGItems.RUBBER_SHEET.get();
        }

        public static ItemLike largeCog() {
            return (ItemLike)AllBlocks.LARGE_COGWHEEL.get();
        }

        public static ItemLike andesiteCasing() {
            return (ItemLike)AllBlocks.ANDESITE_CASING.get();
        }

        public static TagKey<Item> brassIngot() {
            return AllTags.forgeItemTag((String)"ingots/brass");
        }

        public static TagKey<Item> brassSheet() {
            return AllTags.forgeItemTag((String)"plates/brass");
        }

        public static TagKey<Item> iron() {
            return Tags.Items.INGOTS_IRON;
        }

        public static TagKey<Item> ironNugget() {
            return AllTags.forgeItemTag((String)"nuggets/iron");
        }

        public static TagKey<Item> ironDust() {
            return AllTags.forgeItemTag((String)"dusts/iron");
        }

        public static TagKey<Item> zincIngot() {
            return AllTags.forgeItemTag((String)"ingots/zinc");
        }

        public static TagKey<Item> ironSheet() {
            return AllTags.forgeItemTag((String)"plates/iron");
        }

        public static TagKey<Item> sturdySheet() {
            return AllTags.forgeItemTag((String)"plates/obsidian");
        }

        public static ItemLike brassCasing() {
            return (ItemLike)AllBlocks.BRASS_CASING.get();
        }

        public static ItemLike railwayCasing() {
            return (ItemLike)AllBlocks.RAILWAY_CASING.get();
        }

        public static ItemLike electronTube() {
            return (ItemLike)AllItems.ELECTRON_TUBE.get();
        }

        public static ItemLike precisionMechanism() {
            return (ItemLike)AllItems.PRECISION_MECHANISM.get();
        }

        public static ItemLike copperBlock() {
            return Items.f_151000_;
        }

        public static TagKey<Item> brassBlock() {
            return AllTags.forgeItemTag((String)"storage_blocks/brass");
        }

        public static TagKey<Item> zincBlock() {
            return AllTags.forgeItemTag((String)"storage_blocks/zinc");
        }

        public static TagKey<Item> wheatFlour() {
            return AllTags.forgeItemTag((String)"flour/wheat");
        }

        public static ItemLike copperIngot() {
            return Items.f_151052_;
        }

        public static TagKey<Item> copperSheet() {
            return AllTags.forgeItemTag((String)"plates/copper");
        }

        public static TagKey<Item> copperNugget() {
            return AllTags.forgeItemTag((String)"nuggets/copper");
        }

        public static TagKey<Item> brassNugget() {
            return AllTags.forgeItemTag((String)"nuggets/brass");
        }

        public static TagKey<Item> zincNugget() {
            return AllTags.forgeItemTag((String)"nuggets/zinc");
        }

        public static ItemLike copperCasing() {
            return (ItemLike)AllBlocks.COPPER_CASING.get();
        }

        public static ItemLike refinedRadiance() {
            return (ItemLike)AllItems.REFINED_RADIANCE.get();
        }

        public static ItemLike shadowSteel() {
            return (ItemLike)AllItems.SHADOW_STEEL.get();
        }

        public static Ingredient netherite() {
            return Ingredient.m_204132_((TagKey)AllTags.forgeItemTag((String)"ingots/netherite"));
        }

        public static ItemStack resistor10Ohms() {
            ItemStack stack = TFMGBlocks.RESISTOR.asStack();
            stack.m_41784_().m_128405_("Resistance", 10);
            return stack;
        }

        public static ItemStack coil100Turns() {
            ItemStack stack = TFMGItems.ELECTROMAGNETIC_COIL.asStack();
            stack.m_41784_().m_128405_("Turns", 100);
            return stack;
        }

        public static ItemStack turbineBlade() {
            ItemStack stack = TFMGItems.TURBINE_BLADE.asStack();
            CompoundTag keroseneTag = new CompoundTag();
            keroseneTag.m_128359_("kerosene", "forge:kerosene");
            CompoundTag keroseneTagName = new CompoundTag();
            keroseneTagName.m_128359_("kerosene", "Kerosene");
            stack.m_41784_().m_128365_("Fuels", (Tag)keroseneTag);
            stack.m_41784_().m_128365_("FuelNames", (Tag)keroseneTagName);
            return stack;
        }
    }

    public static class Marker {
    }
}

