/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc.dynamicpack;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.VSC;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();
    private final Set<String> recipeLocations;

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(VSC.res("generated_pack")));
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"forge"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"quark"});
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev());
        this.recipeLocations = Set.of("recipe", "recipe_2", "recipe_stonecutter");
    }

    public Logger getLogger() {
        return VSC.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        this.recipeLocations.forEach(res -> {
            try {
                this.addBlocksRecipes(manager, ResType.GENERIC.getPath(VSC.res("template/" + res + ".json")));
            }
            catch (Exception e) {
                VSC.LOGGER.error("Failed to generate recipes for template at location {} ", res);
            }
        });
        this.addBlocksLootTable(manager, ResType.GENERIC.getPath(VSC.res("template/loot_table.json")));
        this.addTags(manager);
    }

    private void addTags(ResourceManager manager) {
        SimpleTagBuilder tag = SimpleTagBuilder.of((ResourceLocation)VSC.res("vertical_slabs"));
        tag.addEntries(VSC.VERTICAL_SLABS_ITEMS.values());
        ((DynamicDataPack)this.dynamicPack).addTag(tag, Registries.f_256747_);
        ((DynamicDataPack)this.dynamicPack).addTag(tag, Registries.f_256913_);
        SimpleTagBuilder quarkTag = SimpleTagBuilder.of((ResourceLocation)new ResourceLocation("quark:vertical_slabs"));
        SimpleTagBuilder quarkWoodenTag = SimpleTagBuilder.of((ResourceLocation)new ResourceLocation("quark:wooden_vertical_slabs"));
        quarkTag.addTag(tag);
        quarkWoodenTag.addEntries(VSC.VERTICAL_SLABS_ITEMS.entrySet().stream().filter(t -> ((CutBlockType)((Object)((Object)t.getKey()))).getWoodType() != null).map(Map.Entry::getValue).toList());
        ((DynamicDataPack)this.dynamicPack).addTag(quarkTag, Registries.f_256747_);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkTag, Registries.f_256913_);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkWoodenTag, Registries.f_256747_);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkWoodenTag, Registries.f_256913_);
        this.copyTags(manager, BlockTags.f_144286_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144285_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144284_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144280_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144281_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144282_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_144283_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_13069_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_215836_, Registries.f_256747_);
        this.copyTags(manager, BlockTags.f_13088_, Registries.f_256747_);
        this.copyTags(manager, ItemTags.f_13151_, Registries.f_256913_);
    }

    private <T> void copyTags(ResourceManager manager, TagKey<T> tagKey, ResourceKey<Registry<T>> registry) {
        Set<String> tagValues = ServerDynamicResourcesHandler.getTags(manager, tagKey);
        SimpleTagBuilder builer = SimpleTagBuilder.of(tagKey);
        for (Map.Entry<CutBlockType, Item> e : VSC.VERTICAL_SLABS_ITEMS.entrySet()) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)e.getKey().slab);
            if (!tagValues.contains(id.toString())) continue;
            builer.addEntry((Object)e.getValue());
        }
        List b = builer.m_215904_();
        if (!b.isEmpty()) {
            ((DynamicDataPack)this.dynamicPack).addTag(builer, registry);
        }
    }

    @NotNull
    private static <T> Set<String> getTags(ResourceManager manager, TagKey<T> tagKey) {
        InputStream res;
        List resources = manager.m_213829_(ResType.TAGS.getPath(tagKey.f_203868_().m_246208_(tagKey.f_203867_().m_135782_().m_135815_() + "s/")));
        HashSet tagValues = new HashSet();
        HashSet<String> actualTags = new HashSet<String>();
        for (Resource r : resources) {
            try {
                res = r.m_215507_();
                try {
                    RPUtils.deserializeJson((InputStream)res).getAsJsonArray("values").asList().stream().filter(JsonElement::isJsonPrimitive).forEach(v -> tagValues.add(v.getAsString()));
                }
                finally {
                    if (res == null) continue;
                    res.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : tagValues) {
            if (s.startsWith("#")) {
                res = new ResourceLocation(s.substring(1));
                if (!res.m_135815_().contains("slab")) continue;
                TagKey newKey = TagKey.m_203882_((ResourceKey)tagKey.f_203867_(), (ResourceLocation)res);
                actualTags.addAll(ServerDynamicResourcesHandler.getTags(manager, newKey));
                continue;
            }
            actualTags.add(s);
        }
        return actualTags;
    }

    private void addBlocksLootTable(ResourceManager manager, ResourceLocation templateLootTable) {
        StaticResource template = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)templateLootTable);
        VSC.VERTICAL_SLABS.forEach((w, i) -> {
            String fullText = new String(template.data, StandardCharsets.UTF_8);
            fullText = fullText.replace("$v_slab", Utils.getID((Block)i).toString());
            String id = template.location.toString();
            id = id.replace("template/loot_table", "loot_tables/" + i.m_60589_().m_135815_());
            ((DynamicDataPack)this.dynamicPack).addResource(StaticResource.create((byte[])fullText.getBytes(), (ResourceLocation)new ResourceLocation(id)));
        });
    }

    private void addBlocksRecipes(ResourceManager manager, ResourceLocation templateRecipe) {
        StaticResource template = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)templateRecipe);
        VSC.VERTICAL_SLABS_ITEMS.forEach((w, i) -> {
            if (this.isSlabEnabled((CutBlockType)((Object)w), (Item)i)) {
                if (templateRecipe.m_135815_().contains("stone") && w.getWoodType() != null) {
                    return;
                }
                String fullText = new String(template.data, StandardCharsets.UTF_8);
                fullText = fullText.replace("$slab", Utils.getID((Block)w.slab).toString());
                fullText = fullText.replace("$v_slab", Utils.getID((Object)w.getChild("vertical_slab")).toString());
                fullText = fullText.replace("$block", Utils.getID((Block)w.base).toString());
                String id = template.location.toString();
                id = id.replace("template/recipe", "recipes/" + w.getAppendableId());
                ((DynamicDataPack)this.dynamicPack).addResource(StaticResource.create((byte[])fullText.getBytes(), (ResourceLocation)new ResourceLocation(id)));
            }
        });
    }

    private boolean isSlabEnabled(CutBlockType w, Item i) {
        String namespace = w.getNamespace();
        return !VSC.BLACKLIST.get().contains(namespace);
    }
}

