/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.chaolux.vanilladelight.common.block.entity.CommonCuttingBoardBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CommonCuttingBoardRenderer
implements BlockEntityRenderer<CommonCuttingBoardBlockEntity> {
    public CommonCuttingBoardRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(CommonCuttingBoardBlockEntity cuttingBoardEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((Direction)cuttingBoardEntity.m_58900_().m_61143_((Property)CuttingBoardBlock.FACING)).m_122424_();
        ItemStack boardStack = cuttingBoardEntity.getStoredItem();
        int posLong = (int)cuttingBoardEntity.m_58899_().m_121878_();
        if (!boardStack.m_41619_()) {
            poseStack.m_85836_();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            poseStack.m_85836_();
            boolean isBlockItem = itemRenderer.m_174264_(boardStack, cuttingBoardEntity.m_58904_(), (LivingEntity)null, 0).applyTransform(ItemDisplayContext.FIXED, poseStack, false).m_7539_();
            poseStack.m_85849_();
            if (cuttingBoardEntity.isItemCarvingBoard()) {
                this.renderItemCarved(poseStack, direction, boardStack);
            } else if (isBlockItem && !boardStack.m_204117_(ModTags.FLAT_ON_CUTTING_BOARD)) {
                this.renderBlock(poseStack, direction);
            } else {
                this.renderItemLayingDown(poseStack, direction);
            }
            Minecraft.m_91087_().m_91291_().m_269128_(boardStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, cuttingBoardEntity.m_58904_(), posLong);
            poseStack.m_85849_();
        }
    }

    public void renderItemLayingDown(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.08, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }

    public void renderBlock(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.27, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
    }

    public void renderItemCarved(PoseStack matrixStackIn, Direction direction, ItemStack itemStack) {
        matrixStackIn.m_85837_(0.5, 0.23, 0.5);
        float f = -direction.m_122435_() + 180.0f;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        Item toolItem = itemStack.m_41720_();
        float poseAngle = !(toolItem instanceof PickaxeItem) && !(toolItem instanceof HoeItem) ? (toolItem instanceof TridentItem ? 135.0f : 180.0f) : 225.0f;
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(poseAngle));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }
}

