/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.block;

import net.chaolux.vanilladelight.common.block.entity.CommonCuttingBoardBlockEntity;
import net.chaolux.vanilladelight.registry.block.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CommonCuttingBoard
extends CuttingBoardBlock {
    public CommonCuttingBoard(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.COMMON_CUTTING_BOARD.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CommonCuttingBoardBlockEntity) {
            CommonCuttingBoardBlockEntity cuttingBoardEntity = (CommonCuttingBoardBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (cuttingBoardEntity.isEmpty()) {
                if (!offhandStack.m_41619_()) {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND) && !offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                        return InteractionResult.PASS;
                    }
                    if (hand.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT)) {
                        return InteractionResult.PASS;
                    }
                }
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (cuttingBoardEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                    level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.m_41619_()) {
                    ItemStack boardStack = cuttingBoardEntity.getStoredItem().m_41777_();
                    if (cuttingBoardEntity.processStoredItemUsingTool(heldStack, player)) {
                        CommonCuttingBoard.spawnCuttingParticles((Level)level, (BlockPos)pos, (ItemStack)boardStack, (int)5);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.m_7500_()) {
                        if (!player.m_150109_().m_36054_(cuttingBoardEntity.removeItem())) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)cuttingBoardEntity.removeItem());
                        }
                    } else {
                        cuttingBoardEntity.removeItem();
                    }
                    level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CommonCuttingBoardBlockEntity) {
                CommonCuttingBoardBlockEntity cuttingBoard = (CommonCuttingBoardBlockEntity)tileEntity;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)cuttingBoard.getStoredItem());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CommonCuttingBoardBlockEntity) {
            return !((CommonCuttingBoardBlockEntity)blockEntity).isEmpty() ? 15 : 0;
        }
        return 0;
    }

    @Mod.EventBusSubscriber(modid="vanilladelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            boolean success;
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.m_21205_();
            BlockEntity tileEntity = level.m_7702_(event.getPos());
            if (player.m_36341_() && !heldStack.m_41619_() && tileEntity instanceof CommonCuttingBoardBlockEntity && (heldStack.m_41720_() instanceof TieredItem || heldStack.m_41720_() instanceof TridentItem || heldStack.m_41720_() instanceof ShearsItem) && (success = ((CommonCuttingBoardBlockEntity)tileEntity).carveToolOnBoard(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack))) {
                level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

