/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.chaolux.vanilladelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CaramelBottleItem
extends DrinkableItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public CaramelBottleItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = false;
        this.hasCustomTooltip = true;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        if (level.f_46443_ || !(consumer instanceof Player)) {
            return;
        }
        Player player = (Player)consumer;
        double radius = 4.0;
        AABB box = new AABB(player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius, player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius);
        List items = level.m_6443_(ItemEntity.class, box, event -> !event.m_32063_());
        for (ItemEntity entity : items) {
            ItemStack itemStack = entity.m_32055_();
            if (itemStack.m_41619_()) continue;
            if (player.m_150109_().m_36054_(itemStack.m_41777_())) {
                entity.m_146870_();
                continue;
            }
            Vec3 direction = player.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.5);
            entity.m_20256_(entity.m_20184_().m_82549_(direction));
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11969_, SoundSource.PLAYERS, 0.8f, 1.2f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + String.valueOf((Object)this), new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
            }
        }
    }
}

