/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.FanBlockEntity;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import com.starfish_studios.yaf.util.YAFSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FanBlock
extends BaseEntityBlock {
    public String wood;
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public FanBlock(String wood, BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? 12 : 0).m_60991_((blockState, blockGetter, blockPos) -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
        this.wood = wood;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof FanBlockEntity) {
                FanBlockEntity fanBlockEntity = (FanBlockEntity)blockEntity;
                fanBlockEntity.commonTick(level, state);
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            state = (BlockState)state.m_61122_((Property)BlockStateProperties.f_61448_);
            level.m_7731_(pos, state, 2);
            this.playSound(level, state, pos);
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FanBlockEntity) {
                FanBlockEntity fanBlockEntity = (FanBlockEntity)blockEntity;
                fanBlockEntity.fanOn = !fanBlockEntity.fanOn;
                this.playFanToggleSound(level, pos, fanBlockEntity.fanOn);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void playSound(Level level, BlockState state, BlockPos pos) {
        BlockEntity blockEntity;
        Boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        if (powered.booleanValue()) {
            level.m_247517_(null, pos, (SoundEvent)YAFSoundEvents.LAMP_ON.get(), SoundSource.BLOCKS);
        } else {
            level.m_247517_(null, pos, (SoundEvent)YAFSoundEvents.LAMP_OFF.get(), SoundSource.BLOCKS);
        }
        if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FanBlockEntity) {
            FanBlockEntity fanBlockEntity = (FanBlockEntity)blockEntity;
            if (fanBlockEntity.fanOn) {
                YAFSoundInstance.tryPlay(fanBlockEntity);
            } else {
                YAFSoundInstance.stop(fanBlockEntity);
            }
        }
    }

    private void playFanToggleSound(Level level, BlockPos pos, boolean fanOn) {
        BlockEntity blockEntity;
        if (fanOn) {
            level.m_247517_(null, pos, (SoundEvent)YAFSoundEvents.FAN_OFF.get(), SoundSource.BLOCKS);
        } else {
            level.m_247517_(null, pos, (SoundEvent)YAFSoundEvents.FAN_ON.get(), SoundSource.BLOCKS);
        }
        if (level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FanBlockEntity) {
            FanBlockEntity fanBlockEntity = (FanBlockEntity)blockEntity;
            if (fanOn) {
                YAFSoundInstance.tryPlay(fanBlockEntity);
            } else {
                YAFSoundInstance.stop(fanBlockEntity);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61448_});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean isPowered;
        boolean bl = level.m_276867_(pos);
        if (bl != (isPowered = ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) && !level.f_46443_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_7820_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FanBlockEntity(pos, state);
    }
}

