/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.ShelfBlockEntity;
import com.starfish_studios.yaf.util.block.BlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> HALF = EnumProperty.m_61587_((String)"half", SlabType.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final VoxelShape NORTH_TOP_AAAB = Block.m_49796_((double)0.0, (double)8.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EAST_TOP_AAAB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_TOP_AAAB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
    public static final VoxelShape SOUTH_BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)7.0);
    public static final VoxelShape WEST_TOP_AAAB = Block.m_49796_((double)9.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_BOTTOM_AABB = Block.m_49796_((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_FLOOR_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape WEST_FLOOR_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_FLOOR_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape EAST_FLOOR_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_FLOOR_SHORT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    public static final VoxelShape WEST_FLOOR_SHORT_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_FLOOR_SHORT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    public static final VoxelShape EAST_FLOOR_SHORT_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_CEILING_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape WEST_CEILING_AABB = Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_CEILING_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape EAST_CEILING_AABB = Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        ((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemStack = useContext.m_43722_();
        SlabType slabType = (SlabType)state.m_61143_(HALF);
        if (slabType == SlabType.DOUBLE || !itemStack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!useContext.m_7058_()) {
            return true;
        }
        Direction direction = useContext.m_43719_();
        if (slabType == SlabType.BOTTOM) {
            return direction == Direction.UP || direction.m_122434_().m_122479_();
        }
        return direction == Direction.DOWN || direction.m_122434_().m_122479_();
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return InteractionResult.PASS;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get2D(pos, hit.m_82450_(), Direction.UP, facing.m_122427_(), 2, 2);
        ItemStack handStack = player.m_21120_(hand);
        ItemStack shelfStack = (ItemStack)shelfBE.getItems().get(slot);
        if (handStack.m_150930_(this.m_5456_())) {
            return InteractionResult.PASS;
        }
        if (handStack.m_41619_()) {
            if (!shelfStack.m_41619_()) {
                player.m_8061_(EquipmentSlot.MAINHAND, shelfStack.m_41777_());
                shelfBE.getItems().set(slot, (Object)ItemStack.f_41583_);
                shelfBE.markUpdated();
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (shelfStack.m_41619_()) {
            shelfBE.getItems().set(slot, (Object)handStack.m_41620_(handStack.m_41613_()));
            shelfBE.markUpdated();
            level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (ItemStack.m_41656_((ItemStack)handStack, (ItemStack)shelfStack)) {
            int room = shelfStack.m_41741_() - shelfStack.m_41613_();
            if (room <= 0) {
                return InteractionResult.PASS;
            }
            int transfer = Math.min(handStack.m_41613_(), room);
            handStack.m_41774_(transfer);
            shelfStack.m_41769_(transfer);
            shelfBE.markUpdated();
            level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        ItemStack temp = shelfStack.m_41777_();
        shelfBE.getItems().set(slot, (Object)handStack.m_41777_());
        player.m_8061_(EquipmentSlot.MAINHAND, temp);
        shelfBE.markUpdated();
        level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        boolean removeAll;
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 end = eyePos.m_82549_(lookVec.m_82490_(5.0));
        ClipContext context = new ClipContext(eyePos, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = level.m_45547_(context);
        if (!pos.equals((Object)hitResult.m_82425_())) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get2D(pos, hitResult.m_82450_(), Direction.UP, facing.m_122427_(), 2, 2);
        if (shelfBE.removeItem(slot, player, level, removeAll = player.m_6144_())) {
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
            Containers.m_19010_((Level)level, (BlockPos)pos, shelfBE.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = Shapes.m_83040_();
        if (state.m_61143_(FACE) == AttachFace.FLOOR) {
            if (state.m_61143_(HALF) == SlabType.BOTTOM) {
                return switch (direction) {
                    case Direction.EAST -> EAST_FLOOR_SHORT_AABB;
                    case Direction.WEST -> WEST_FLOOR_SHORT_AABB;
                    case Direction.NORTH -> NORTH_FLOOR_SHORT_AABB;
                    default -> SOUTH_FLOOR_SHORT_AABB;
                };
            }
            return switch (direction) {
                case Direction.EAST -> EAST_FLOOR_AABB;
                case Direction.WEST -> WEST_FLOOR_AABB;
                case Direction.NORTH -> NORTH_FLOOR_AABB;
                default -> SOUTH_FLOOR_AABB;
            };
        }
        if (state.m_61143_(FACE) == AttachFace.CEILING) {
            if (state.m_61143_(HALF) == SlabType.TOP) {
                return switch (direction) {
                    case Direction.EAST -> EAST_CEILING_AABB;
                    case Direction.WEST -> WEST_CEILING_AABB;
                    case Direction.NORTH -> NORTH_CEILING_AABB;
                    default -> SOUTH_CEILING_AABB;
                };
            }
            return switch (direction) {
                case Direction.EAST -> EAST_FLOOR_AABB;
                case Direction.WEST -> WEST_FLOOR_AABB;
                case Direction.NORTH -> NORTH_FLOOR_AABB;
                default -> SOUTH_FLOOR_AABB;
            };
        }
        if (state.m_61143_(HALF) == SlabType.TOP) {
            if (direction == Direction.NORTH) {
                shape = NORTH_TOP_AAAB;
            }
            if (direction == Direction.EAST) {
                shape = EAST_TOP_AAAB;
            }
            if (direction == Direction.SOUTH) {
                shape = SOUTH_TOP_AAAB;
            }
            if (direction == Direction.WEST) {
                shape = WEST_TOP_AAAB;
            }
        } else if (state.m_61143_(HALF) == SlabType.BOTTOM) {
            if (direction == Direction.NORTH) {
                shape = NORTH_BOTTOM_AABB;
            }
            if (direction == Direction.EAST) {
                shape = EAST_BOTTOM_AABB;
            }
            if (direction == Direction.SOUTH) {
                shape = SOUTH_BOTTOM_AABB;
            }
            if (direction == Direction.WEST) {
                shape = WEST_BOTTOM_AABB;
            }
        } else {
            if (direction == Direction.NORTH) {
                shape = Shapes.m_83110_((VoxelShape)NORTH_TOP_AAAB, (VoxelShape)NORTH_BOTTOM_AABB);
            }
            if (direction == Direction.EAST) {
                shape = Shapes.m_83110_((VoxelShape)EAST_TOP_AAAB, (VoxelShape)EAST_BOTTOM_AABB);
            }
            if (direction == Direction.SOUTH) {
                shape = Shapes.m_83110_((VoxelShape)SOUTH_TOP_AAAB, (VoxelShape)SOUTH_BOTTOM_AABB);
            }
            if (direction == Direction.WEST) {
                shape = Shapes.m_83110_((VoxelShape)WEST_TOP_AAAB, (VoxelShape)WEST_BOTTOM_AABB);
            }
        }
        return shape;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        BlockState stateExisting = context.m_43725_().m_8055_(clickedPos);
        if (stateExisting.m_60713_((Block)this)) {
            return (BlockState)stateExisting.m_61124_(HALF, (Comparable)SlabType.DOUBLE);
        }
        BlockState blockState = this.m_49966_();
        boolean waterlogged = context.m_43725_().m_6425_(clickedPos).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)((BlockState)blockState.m_61124_(HALF, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        Direction direction = context.m_43719_();
        state = direction == Direction.DOWN ? (BlockState)state.m_61124_(FACE, (Comparable)AttachFace.CEILING) : (direction == Direction.UP ? (BlockState)((BlockState)state.m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_(HALF, (Comparable)SlabType.BOTTOM) : (BlockState)state.m_61124_(FACE, (Comparable)AttachFace.WALL));
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)clickedPos.m_123342_() > 0.5) ? state : (BlockState)state.m_61124_(HALF, (Comparable)SlabType.TOP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, WATERLOGGED, FACE});
    }
}

