/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.WindChimeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindChimeBlock
extends BaseEntityBlock {
    private final SoundEvent sound;
    public String material;
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public WindChimeBlock(String material, SoundEvent sound, BlockBehaviour.Properties properties) {
        super(properties);
        this.sound = sound;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
        this.material = material;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof WindChimeBlockEntity) {
                WindChimeBlockEntity windChimeBlockEntity = (WindChimeBlockEntity)blockEntity;
                windChimeBlockEntity.commonTick(level, state);
            }
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d = (double)pos.m_123341_() + 0.5;
        double e = pos.m_123342_();
        double f = (double)pos.m_123343_() + 0.5;
        if (random.m_188500_() < 0.09) {
            BlockEntity be;
            level.m_7785_(d, e, f, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            if (level.f_46443_ && (be = level.m_7702_(pos)) instanceof WindChimeBlockEntity) {
                WindChimeBlockEntity windChime = (WindChimeBlockEntity)be;
                windChime.triggerAnimate(80);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WindChimeBlockEntity(pos, state);
    }
}

