/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.starfish_studios.yaf.block.entity.TallStoolBlockEntity;
import com.starfish_studios.yaf.block.properties.ColorList;
import com.starfish_studios.yaf.client.model.ChairCushionModel;
import com.starfish_studios.yaf.client.model.TallStoolBlockEntityModel;
import java.util.Locale;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class TallStoolBlockEntityRenderer
implements BlockEntityRenderer<TallStoolBlockEntity> {
    private final TallStoolBlockEntityModel model;
    private final ChairCushionModel cloth;

    public TallStoolBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new TallStoolBlockEntityModel(context.m_173582_(TallStoolBlockEntityModel.LAYER_LOCATION));
        this.cloth = new ChairCushionModel(context.m_173582_(ChairCushionModel.LAYER_LOCATION));
    }

    public void render(TallStoolBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(blockEntity)));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (blockEntity.getColor() != ColorList.EMPTY) {
            VertexConsumer clothConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getClothTextureLocation(blockEntity)));
            poseStack.m_85837_(0.0, -0.25, 0.0);
            poseStack.m_85841_(0.91f, 0.91f, 0.91f);
            this.cloth.m_7695_(poseStack, clothConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    private ResourceLocation getTextureLocation(TallStoolBlockEntity blockEntity) {
        Block state = blockEntity.m_58900_().m_60734_();
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)state).m_135815_();
        return new ResourceLocation("yaf", "textures/entity/tall_stool/" + name + ".png");
    }

    private ResourceLocation getClothTextureLocation(TallStoolBlockEntity blockEntity) {
        String name = blockEntity.getColor().m_7912_().toLowerCase(Locale.ROOT);
        return new ResourceLocation("yaf", "textures/entity/chair/" + name + "_cushion.png");
    }
}

