/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FermentingRecipeCategory
implements IRecipeCategory<KegFermentingPouringRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("brewinandchewin", "fermenting");
    protected final IModIdHelper modIdHelper;
    protected final IDrawableAnimated arrow;
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable cold;
    private final IDrawable chilly;
    private final IDrawable warm;
    private final IDrawable hot;
    protected final IDrawable timeIcon;
    protected final IDrawable expIcon;
    protected final IDrawable kegOverlay;
    protected final IDrawableAnimated leftBubble;
    protected final IDrawableAnimated rightBubble;

    public FermentingRecipeCategory(IGuiHelper guiHelper, IModIdHelper modIdHelper) {
        this.modIdHelper = modIdHelper;
        this.title = BnCTextUtils.getTranslation("jei.fermenting", new Object[0]);
        ResourceLocation backgroundImage = new ResourceLocation("brewinandchewin", "textures/gui/jei/keg.png");
        this.background = guiHelper.createDrawable(backgroundImage, 12, 13, 136, 56);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BnCItems.KEG.get()));
        this.arrow = guiHelper.drawableBuilder(backgroundImage, 171, 4, 23, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.cold = guiHelper.createDrawable(backgroundImage, 170, 0, 8, 3);
        this.chilly = guiHelper.createDrawable(backgroundImage, 178, 0, 9, 3);
        this.warm = guiHelper.createDrawable(backgroundImage, 195, 0, 9, 3);
        this.hot = guiHelper.createDrawable(backgroundImage, 204, 0, 8, 3);
        this.expIcon = guiHelper.createDrawable(backgroundImage, 170, 32, 9, 9);
        this.timeIcon = guiHelper.createDrawable(backgroundImage, 170, 21, 8, 11);
        this.kegOverlay = guiHelper.createDrawable(backgroundImage, 170, 45, 26, 30);
        this.leftBubble = guiHelper.drawableBuilder(backgroundImage, 170, 75, 9, 24).buildAnimated(50, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.rightBubble = guiHelper.drawableBuilder(backgroundImage, 180, 75, 9, 24).buildAnimated(50, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
        return BnCJEIRecipeTypes.FERMENTING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KegFermentingPouringRecipe recipe, IFocusGroup focusGroup) {
        int pourCount;
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, column * borderSlotSize + 29, row * borderSlotSize + 1).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        if (recipe.getFluidIngredient() != null) {
            if (((Boolean)BnCConfiguration.RENDER_FLUID_IN_KEG.get()).booleanValue()) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 2).addFluidStack(recipe.getFluidIngredient().getFluid(), (long)recipe.getFluidIngredient().getAmount())).setFluidRenderer((long)((Integer)BnCConfiguration.KEG_CAPACITY.get()).intValue(), false, 26, 30).setOverlay(this.kegOverlay, 0, 0);
            } else {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addFluidStack(recipe.getFluidIngredient().getFluid(), (long)recipe.getFluidIngredient().getAmount(), recipe.getFluidIngredient().getTag());
            }
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay(Minecraft.m_91087_().f_91073_.m_9598_(), recipe.getFluidIngredient()).m_41777_();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> ItemStack.m_150942_((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()))).findFirst();
            pourCount = pouringRecipe.map(kegPouringRecipe -> Math.min((Integer)BnCConfiguration.KEG_CAPACITY.get(), recipe.getFluidIngredient().getAmount()) / kegPouringRecipe.getAmount()).orElse(1);
            itemDisplay.m_41764_(pourCount);
            if (!itemDisplay.m_41619_()) {
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 5, 5).addItemStack(itemDisplay);
            }
        }
        if (recipe.getResultFluid() != null) {
            if (((Boolean)BnCConfiguration.RENDER_FLUID_IN_KEG.get()).booleanValue()) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 2).addFluidStack(recipe.getResultFluid(), (long)recipe.getAmount())).setFluidRenderer((long)((Integer)BnCConfiguration.KEG_CAPACITY.get()).intValue(), false, 26, 30).setOverlay(this.kegOverlay, 0, 0);
            } else {
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack(recipe.getResultFluid(), (long)recipe.getAmount());
            }
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay(Minecraft.m_91087_().f_91073_.m_9598_(), new FluidStack(recipe.getResultFluid(), recipe.getAmount())).m_41777_();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> ItemStack.m_150942_((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()))).findFirst();
            pourCount = pouringRecipe.map(kegPouringRecipe -> Math.min((Integer)BnCConfiguration.KEG_CAPACITY.get(), recipe.getFluidIngredient().getAmount()) / kegPouringRecipe.getAmount()).orElse(1);
            itemDisplay.m_41764_(pourCount);
            if (!itemDisplay.m_41619_()) {
                builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 105, 5).addItemStack(itemDisplay);
            }
        }
        if (recipe.getCatalyst() != null) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 73, 39).addItemStack(recipe.getCatalyst());
        }
        if (recipe.getOutput() != null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 105, 39).addItemStack(recipe.getOutput());
        }
        builder.moveRecipeTransferButton(132, 43);
    }

    public void draw(KegFermentingPouringRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 67, 10);
        this.leftBubble.draw(guiGraphics, 90, 3);
        this.rightBubble.draw(guiGraphics, 127, 3);
        if (recipe.getTemperature() <= 2) {
            this.chilly.draw(guiGraphics, 33, 39);
        }
        if (recipe.getTemperature() <= 1) {
            this.cold.draw(guiGraphics, 25, 39);
        }
        if (recipe.getTemperature() >= 4) {
            this.warm.draw(guiGraphics, 50, 39);
        }
        if (recipe.getTemperature() >= 5) {
            this.hot.draw(guiGraphics, 59, 39);
        }
        this.timeIcon.draw(guiGraphics, 70, 2);
        if (recipe.getExperience() > 0.0f) {
            this.expIcon.draw(guiGraphics, 69, 21);
        }
    }

    public List<Component> getTooltipStrings(KegFermentingPouringRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ClientRenderUtils.isCursorInsideBounds((int)67, (int)2, (int)22, (int)28, (double)mouseX, (double)mouseY)) {
            float experience;
            ArrayList<Component> tooltipStrings = new ArrayList<Component>();
            int cookTime = recipe.getFermentTime();
            if (cookTime > 0) {
                if (cookTime >= 1200) {
                    tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.time.minutes", (Object[])new Object[]{cookTime / 1200}));
                } else {
                    tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTime / 20}));
                }
            }
            if ((experience = recipe.getExperience()) > 0.0f) {
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}));
            }
            return tooltipStrings;
        }
        if (ClientRenderUtils.isCursorInsideBounds((int)24, (int)38, (int)44, (int)5, (double)mouseX, (double)mouseY)) {
            MutableComponent key;
            switch (recipe.getTemperature()) {
                case 1: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                    break;
                }
                case 2: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                    break;
                }
                case 3: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
                    break;
                }
                case 4: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                    break;
                }
                case 5: {
                    MutableComponent mutableComponent = BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                    break;
                }
                default: {
                    MutableComponent mutableComponent = key = null;
                }
            }
            if (key != null) {
                return Collections.singletonList(key);
            }
        } else if (ClientRenderUtils.isCursorInsideBounds((int)92, (int)39, (int)10, (int)16, (double)mouseX, (double)mouseY) && recipe.getCatalyst() != null) {
            return Collections.singletonList(Component.m_237113_((String)String.valueOf(recipe.getCatalystAmount())).m_130946_(I18n.m_118938_((String)"generic.unit.millibuckets", (Object[])new Object[0])));
        }
        return Collections.emptyList();
    }
}

