/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.brewincompatdelight.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final String EMPTY_STR = "";

    public static ResourceLocation rl(@NotNull String modid, @NotNull String path) {
        return new ResourceLocation(modid, path);
    }

    public static ResourceLocation rl(@NotNull String separated) {
        return new ResourceLocation(separated);
    }

    public static ResourceLocation rl(ItemLike itemLike) {
        Block block;
        IForgeRegistry reg;
        if (itemLike instanceof Item) {
            IForgeRegistry reg2 = ForgeRegistries.ITEMS;
            Item item = (Item)itemLike;
            if (reg2.containsValue((Object)item)) {
                return reg2.getKey((Object)item);
            }
        } else if (itemLike instanceof Block && (reg = ForgeRegistries.BLOCKS).containsValue((Object)(block = (Block)itemLike))) {
            return reg.getKey((Object)block);
        }
        return Util.rl(EMPTY_STR, EMPTY_STR);
    }

    public static ResourceLocation brewincompatdelight(String path) {
        return Util.rl("brewincompatdelight", path);
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before.clone();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, int count) {
        return count < 1 ? before : Util.with(before, new ItemStack((ItemLike)addition, count));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, RandomSource rand, int min, int max) {
        if (max < min) {
            return before;
        }
        return Util.with(before, addition, max == min ? min : rand.m_216332_(min, max));
    }

    @Nullable
    public static Item item(ResourceLocation rl) {
        return (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    @Nullable
    public static Item item(String id, String path) {
        return Util.item(Util.rl(id, path));
    }

    @Nullable
    public static Block block(String id, String path) {
        return Util.block(Util.rl(id, path));
    }

    @Nullable
    public static Block block(ResourceLocation rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }
}

