/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.core.CorgiLibRegistry;
import corgitaco.corgilib.platform.ModPlatform;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public class VillagerTradeRegistry {
    public static final Codec<Item> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_257033_);
    public static final Codec<MobEffect> MOB_EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(BuiltInRegistries.f_256974_);
    private static final Codec<VillagerTrades.EmeraldForItems> EMERALD_FOR_ITEMS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("item").forGetter(listing -> listing.f_35651_), (App)Codec.INT.fieldOf("cost").forGetter(listing -> listing.f_35652_), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.f_35653_), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.f_35654_)).apply((Applicative)builder, VillagerTrades.EmeraldForItems::new));
    private static final Codec<VillagerTrades.ItemsForEmeralds> ITEMS_FOR_EMERALDS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("item").forGetter(listing -> listing.f_35734_.m_41720_()), (App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.f_35735_), (App)Codec.INT.fieldOf("number_of_items").forGetter(listing -> listing.f_35736_), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.f_35737_), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.f_35738_)).apply((Applicative)builder, VillagerTrades.ItemsForEmeralds::new));
    private static final Codec<VillagerTrades.ItemsAndEmeraldsToItems> ITEMS_AND_EMERALDS_TO_ITEMS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("from_item").forGetter(listing -> listing.f_35708_.m_41720_()), (App)Codec.INT.fieldOf("from_count").forGetter(listing -> listing.f_35709_), (App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.f_35710_), (App)ITEM_CODEC.fieldOf("to_item").forGetter(listing -> listing.f_35711_.m_41720_()), (App)Codec.INT.fieldOf("to_count").forGetter(listing -> listing.f_35712_), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.f_35713_), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.f_35714_)).apply((Applicative)builder, VillagerTrades.ItemsAndEmeraldsToItems::new));
    private static final Codec<VillagerTrades.SuspiciousStewForEmerald> SUSPICIOUS_STEW_FOR_EMERALD_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)MOB_EFFECT_CODEC.fieldOf("mob_effect").forGetter(listing -> listing.f_186308_), (App)Codec.INT.fieldOf("duration").forGetter(listing -> listing.f_186309_), (App)Codec.INT.fieldOf("xp").forGetter(listing -> listing.f_186310_)).apply((Applicative)builder, VillagerTrades.SuspiciousStewForEmerald::new));
    public static final Codec<MapDecoration.Type> MAP_DECORATION_TYPE_CODEC = Codec.STRING.comapFlatMap(type -> {
        try {
            return DataResult.success((Object)MapDecoration.Type.valueOf((String)type.toUpperCase()));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid Map Decoration Type! You put \"%s\". Valid values: %s".formatted(type, Arrays.toString(MapDecoration.Type.values())));
        }
    }, Enum::name);
    private static final Codec<VillagerTrades.TreasureMapForEmeralds> TREASURE_MAP_FOR_EMERALDS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.f_35805_), (App)TagKey.m_203886_((ResourceKey)Registries.f_256944_).fieldOf("destination").forGetter(listing -> listing.f_35806_), (App)Codec.STRING.fieldOf("display_name").forGetter(listing -> listing.f_207765_), (App)MAP_DECORATION_TYPE_CODEC.fieldOf("destination_type").forGetter(listing -> listing.f_35807_), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.f_35808_), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.f_35809_)).apply((Applicative)builder, VillagerTrades.TreasureMapForEmeralds::new));
    private static final Map<Class<? extends VillagerTrades.ItemListing>, Codec<? extends VillagerTrades.ItemListing>> ITEM_LISTING_CLASS_BY_CODEC = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(VillagerTrades.EmeraldForItems.class, EMERALD_FOR_ITEMS_CODEC);
        map.put(VillagerTrades.ItemsForEmeralds.class, ITEMS_FOR_EMERALDS_CODEC);
        map.put(VillagerTrades.SuspiciousStewForEmerald.class, SUSPICIOUS_STEW_FOR_EMERALD_CODEC);
        map.put(VillagerTrades.ItemsAndEmeraldsToItems.class, ITEMS_AND_EMERALDS_TO_ITEMS_CODEC);
        map.put(VillagerTrades.TreasureMapForEmeralds.class, TREASURE_MAP_FOR_EMERALDS_CODEC);
    });
    public static final Codec<VillagerTrades.ItemListing> ITEM_LISTING_CODEC = ExtraCodecs.m_184415_(() -> CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get().m_194605_().dispatchStable(itemListing -> ITEM_LISTING_CLASS_BY_CODEC.get(itemListing.getClass()), codec -> codec.fieldOf("config").codec()));

    public static void register() {
        ModPlatform.PLATFORM.register(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get(), "emerald_for_items", () -> EMERALD_FOR_ITEMS_CODEC);
        ModPlatform.PLATFORM.register(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get(), "items_for_emeralds", () -> ITEMS_FOR_EMERALDS_CODEC);
        ModPlatform.PLATFORM.register(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get(), "suspicious_stew_for_emerald", () -> SUSPICIOUS_STEW_FOR_EMERALD_CODEC);
        ModPlatform.PLATFORM.register(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get(), "items_and_emeralds_to_items", () -> ITEMS_AND_EMERALDS_TO_ITEMS_CODEC);
        ModPlatform.PLATFORM.register(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get(), "treasure_map_for_emeralds", () -> TREASURE_MAP_FOR_EMERALDS_CODEC);
    }
}

