/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.google.common.base.Function;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import fr.iglee42.createcasing.CreateCasing;
import fr.iglee42.createcasing.blocks.ConfigurableGearboxBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainDriveBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainGearshiftBlock;
import java.util.Objects;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class EncasedBlockStateGens {
    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> encasedShaft(String shaft, String casing) {
        return (ctx, prov) -> EncasedBlockStateGens.axisBlock(ctx, prov, EncasedBlockStateGens.encasedShaftModel((RegistrateProvider)prov, shaft, casing, false));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> gearbox(String casing) {
        return (ctx, prov) -> EncasedBlockStateGens.axisBlock(ctx, prov, EncasedBlockStateGens.gearboxModel((RegistrateProvider)prov, casing, "block"));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> shaft(String shaft) {
        return (ctx, prov) -> EncasedBlockStateGens.axisBlock(ctx, prov, EncasedBlockStateGens.shaftModel((RegistrateProvider)prov, shaft), false);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cogwheel(String cogwheel) {
        return (ctx, prov) -> {
            EncasedBlockStateGens.axisBlock(ctx, prov, EncasedBlockStateGens.cogwheelModel((RegistrateProvider)prov, cogwheel, true));
            EncasedBlockStateGens.cogwheelModel((RegistrateProvider)prov, cogwheel, false);
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> largeCogwheel(String cogwheel) {
        return (ctx, prov) -> {
            EncasedBlockStateGens.axisBlock(ctx, prov, EncasedBlockStateGens.largeCogwheelModel((RegistrateProvider)prov, cogwheel, true));
            EncasedBlockStateGens.largeCogwheelModel((RegistrateProvider)prov, cogwheel, false);
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> encasedCogwheel(String cogwheel, String casing) {
        return (ctx, prov) -> EncasedBlockStateGens.axisBlock(ctx, prov, (Function<BlockState, ModelFile>)((Function)blockState -> EncasedBlockStateGens.encasedCogwheelModel((RegistrateProvider)prov, casing, cogwheel, blockState, false)), false);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> encasedLargeCogwheel(String cogwheel, String casing) {
        return (ctx, prov) -> EncasedBlockStateGens.axisBlock(ctx, prov, (Function<BlockState, ModelFile>)((Function)blockState -> EncasedBlockStateGens.encasedCogwheelModel((RegistrateProvider)prov, casing, cogwheel, blockState, true)), false);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> encasedChainDrive(String casing) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            int rotationX = EncasedBlockStateGens.getChainDriveXRot(state);
            int rotationY = EncasedBlockStateGens.getChainDriveYRot(state);
            String suffix = EncasedBlockStateGens.getChainDriveModelSuffix(state);
            return ConfiguredModel.builder().modelFile(EncasedBlockStateGens.createChainDriveModel((RegistrateProvider)prov, casing, false, suffix)).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[0]);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> adjustableChainGearshift(String casing) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            int rotationX = EncasedBlockStateGens.getChainDriveXRot(state);
            int rotationY = EncasedBlockStateGens.getChainDriveYRot(state);
            String suffix = EncasedBlockStateGens.getChainDriveModelSuffix(state);
            return ConfiguredModel.builder().modelFile(EncasedBlockStateGens.createAdjustableChainGearshiftModel((RegistrateProvider)prov, casing, false, suffix, (Boolean)state.m_61143_((Property)CustomChainGearshiftBlock.POWERED))).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[0]);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> chainConveyor(String casing) {
        return (ctx, prov) -> {
            prov.simpleBlock((Block)ctx.get(), EncasedBlockStateGens.createConveyorModel((RegistrateProvider)prov, casing, false));
            EncasedBlockStateGens.texturesChainConveyor(Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)prov, "chain_conveyor/" + casing + "/wheel")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/chain_conveyor/wheel")), casing);
            EncasedBlockStateGens.texturesChainConveyor(Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)prov, "chain_conveyor/" + casing + "/guard")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/chain_conveyor/guard")), casing);
            EncasedBlockStateGens.texturesChainConveyor(Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)prov, "chain_conveyor/" + casing + "/shaft")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/chain_conveyor/shaft")), casing);
        };
    }

    public static ModelFile createConveyorModel(RegistrateProvider prov, String casing, boolean item) {
        if (!item) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(prov, "chain_conveyor/" + casing + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/chain_conveyor/block")).texture("0", EncasedBlockStateGens.getConveyorCasingTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return EncasedBlockStateGens.texturesChainConveyor(Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(prov, "chain_conveyor/" + casing + "/item")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/chain_conveyor/item")), casing);
    }

    private static ModelBuilder<? extends ModelBuilder<?>> texturesChainConveyor(ModelBuilder<? extends ModelBuilder<?>> builder, String casing) {
        return builder.texture("conveyor_casing", EncasedBlockStateGens.getConveyorCasingTexture(casing)).texture("conveyor_port", EncasedBlockStateGens.getConveyorPortTexture(casing)).texture("bullwheel", EncasedBlockStateGens.getBullWheelTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static ModelFile createAdjustableChainGearshiftModel(RegistrateProvider provider, String casing, boolean item, String suffix, boolean powered) {
        ModelFile file = EncasedBlockStateGens.createChainDriveModel(provider, casing, item, suffix);
        if (!EncasedBlockStateGens.isValidProvider(provider)) {
            return file;
        }
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(provider, "adjustable_chain_gearshift/" + casing + "/" + suffix + (powered ? "_powered" : ""))).parent(file).texture("side", EncasedBlockStateGens.getAdjustableChainGearshiftTexture(casing, powered)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static ModelFile createChainDriveModel(RegistrateProvider provider, String casing, boolean item, String suffix) {
        if (!item) {
            String partKey = suffix.startsWith("end") ? "2" : "1";
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(provider, "encased_chain_drive/" + casing + "/" + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased_chain_drive/" + suffix)).texture(partKey, suffix.equals("single") ? EncasedBlockStateGens.getGearboxTexture(casing) : EncasedBlockStateGens.getChainDrivePart(casing, partKey)).texture("side", EncasedBlockStateGens.getChainDriveSideTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(provider, "encased_chain_drive/" + casing + "/item")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased_chain_drive/item")).texture("1", EncasedBlockStateGens.getGearboxTexture(casing)).texture("side", EncasedBlockStateGens.getChainDriveSideTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    private static int getChainDriveXRot(BlockState state) {
        ChainDriveBlock.Part part = (ChainDriveBlock.Part)state.m_61143_(CustomChainDriveBlock.PART);
        boolean connectedAlongFirst = (Boolean)state.m_61143_((Property)CustomChainDriveBlock.CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CustomChainDriveBlock.AXIS);
        if (part == ChainDriveBlock.Part.NONE) {
            return axis == Direction.Axis.Y ? 90 : 0;
        }
        if (axis == Direction.Axis.X) {
            return (connectedAlongFirst ? 90 : 0) + (part == ChainDriveBlock.Part.START ? 180 : 0);
        }
        if (axis == Direction.Axis.Z) {
            return connectedAlongFirst ? 0 : (part == ChainDriveBlock.Part.START ? 270 : 90);
        }
        return 0;
    }

    private static int getChainDriveYRot(BlockState state) {
        boolean flip;
        ChainDriveBlock.Part part = (ChainDriveBlock.Part)state.m_61143_(CustomChainDriveBlock.PART);
        boolean connectedAlongFirst = (Boolean)state.m_61143_((Property)CustomChainDriveBlock.CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CustomChainDriveBlock.AXIS);
        if (part == ChainDriveBlock.Part.NONE) {
            return axis == Direction.Axis.X ? 90 : 0;
        }
        if (axis == Direction.Axis.Z) {
            return connectedAlongFirst && part == ChainDriveBlock.Part.END ? 270 : 90;
        }
        boolean bl = flip = part == ChainDriveBlock.Part.END && !connectedAlongFirst || part == ChainDriveBlock.Part.START && connectedAlongFirst;
        if (axis == Direction.Axis.Y) {
            return (connectedAlongFirst ? 90 : 0) + (flip ? 180 : 0);
        }
        return 0;
    }

    private static String getChainDriveModelSuffix(BlockState state) {
        ChainDriveBlock.Part part = (ChainDriveBlock.Part)state.m_61143_(CustomChainDriveBlock.PART);
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CustomChainDriveBlock.AXIS);
        if (part == ChainDriveBlock.Part.NONE) {
            return "single";
        }
        String orientation = axis == Direction.Axis.Y ? "vertical" : "horizontal";
        String section = part == ChainDriveBlock.Part.MIDDLE ? "middle" : "end";
        return section + "_" + orientation;
    }

    public static <P extends EncasedPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> encasedPipe(String casing) {
        return (c, p) -> {
            ModelBuilder open = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "encased_pipe/" + casing + "/block_open")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/templates/pipe_block_open"))).texture("1", EncasedBlockStateGens.getCasingTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
            ModelBuilder flat = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "encased_pipe/" + casing + "/block_flat")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased_fluid_pipe/block_flat")).texture("0", EncasedBlockStateGens.getCasingTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (boolean flatPass : Iterate.trueAndFalse) {
                for (Direction d : Iterate.directions) {
                    int verticalAngle = d == Direction.UP ? 90 : (d == Direction.DOWN ? -90 : 0);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(flatPass ? flat : open)).rotationX(verticalAngle).rotationY((int)(d.m_122435_() + (float)(d.m_122434_().m_122478_() ? 90 : 0)) % 360).addModel()).condition((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable[])new Boolean[]{!flatPass}).end();
                }
            }
        };
    }

    public static <P extends ConfigurableGearboxBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> configurableGearbox(String casing) {
        return (c, p) -> {
            ModelBuilder block = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "configurable_gearbox/" + casing + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/templates/configurable_gearbox/block"))).texture("0", EncasedBlockStateGens.getCasingTexture(casing)).texture("1", EncasedBlockStateGens.getGearboxTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
            ModelBuilder face = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "configurable_gearbox/" + casing + "/face")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/templates/configurable_gearbox/face"))).texture("0", EncasedBlockStateGens.getCasingTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)block).addModel()).end();
            for (Direction d : Iterate.directions) {
                int verticalAngle = d == Direction.UP ? -90 : (d == Direction.DOWN ? 90 : 0);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)face).rotationX(verticalAngle).rotationY((int)(d.m_122424_().m_122435_() + (float)(d.m_122434_().m_122478_() ? 90 : 0)) % 360).addModel()).condition((Property)ConfigurableGearboxBlock.getPropertyByDirection(d), (Comparable[])new Boolean[]{false}).end();
            }
        };
    }

    public static ModelFile createConfigurableGearboxItemModel(RegistrateItemModelProvider p, String casing) {
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "configurable_gearbox/" + casing + "/item")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/templates/configurable_gearbox/item"))).texture("0", EncasedBlockStateGens.getCasingTexture(casing)).texture("1", EncasedBlockStateGens.getGearboxTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static <P extends Block> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> press(String casing) {
        return (c, p) -> p.horizontalBlock((Block)c.get(), EncasedBlockStateGens.pressModel((RegistrateProvider)p, casing, false));
    }

    public static <P extends Block> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> mixer(String casing) {
        return (c, p) -> {
            p.simpleBlock((Block)c.get(), EncasedBlockStateGens.mixerModel((RegistrateProvider)p, casing, false));
            Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock((RegistrateProvider)p, "mixer/" + casing + "/head")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/mechanical_mixer/head")).texture("6", EncasedBlockStateGens.getMixerPart(casing, "head"));
        };
    }

    public static <P extends Block> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> depot(String casing) {
        return (c, p) -> p.simpleBlock((Block)c.get(), Objects.requireNonNull(EncasedBlockStateGens.depotModel((RegistrateProvider)p, casing)));
    }

    public static <T> ModelFile encasedCogwheelModel(RegistrateProvider p, String casing, String cogwheel, BlockState state, boolean large) {
        boolean top = state != null ? (Boolean)state.m_61143_((Property)EncasedCogwheelBlock.TOP_SHAFT) : false;
        boolean bottom = state != null ? (Boolean)state.m_61143_((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) : false;
        String suffix = (top ? "_top" : "") + (bottom ? "_bottom" : "");
        if (EncasedBlockStateGens.isValidProvider(p)) {
            ModelBuilder file = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "encased" + (large ? "_large" : "") + "_cogwheel/" + casing + "/" + (String)(state == null ? "item" : "block" + suffix))).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased" + (large ? "_large" : "") + "_cogwheel/block" + suffix)).texture("1", EncasedBlockStateGens.getCasingTexture(casing)).texture("casing", EncasedBlockStateGens.getCasingTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing)).texture("4", EncasedBlockStateGens.getGearboxTexture(casing)).texture("side", large ? EncasedBlockStateGens.getLargeCogwheelSideTexture(casing) : EncasedBlockStateGens.getCogwheelSideTexture(casing));
            if (state == null) {
                file = file.parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased" + (large ? "_large" : "") + "_cogwheel/item"));
            }
            return file;
        }
        return null;
    }

    public static <T> ModelFile pressModel(RegistrateProvider p, String casing, boolean item) {
        if (!item) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "press/" + casing + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/mechanical_press/block")).texture("gearbox_top", EncasedBlockStateGens.getCasingTexture(casing)).texture("gearbox", EncasedBlockStateGens.getGearboxTexture(casing)).texture("mechanical_press_top", EncasedBlockStateGens.getPressPart(casing, "top")).texture("4", EncasedBlockStateGens.getPressPart(casing, "side")).texture("mechanical_press_bottom", EncasedBlockStateGens.getPressPart(casing, "bottom")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "press/" + casing + "/item")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/mechanical_press/item")).texture("gearbox_top", EncasedBlockStateGens.getCasingTexture(casing)).texture("gearbox", EncasedBlockStateGens.getGearboxTexture(casing)).texture("mechanical_press_top", EncasedBlockStateGens.getPressPart(casing, "top")).texture("8", EncasedBlockStateGens.getPressPart(casing, "side")).texture("mechanical_press_bottom", EncasedBlockStateGens.getPressPart(casing, "bottom")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static <T> ModelFile depotModel(RegistrateProvider p, String casing) {
        if (EncasedBlockStateGens.isValidProvider(p)) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "depot/" + casing + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/depot/block")).texture("3", EncasedBlockStateGens.getCasingTexture(casing)).texture("2", EncasedBlockStateGens.getDepotPart(casing, "top")).texture("1", EncasedBlockStateGens.getDepotPart(casing, "side")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return null;
    }

    public static <T> ModelFile mixerModel(RegistrateProvider p, String casing, boolean item) {
        if (!item) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "mixer/" + casing + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/mechanical_mixer/block")).texture("2", EncasedBlockStateGens.getCasingTexture(casing)).texture("11", EncasedBlockStateGens.getPressPart(casing, "top")).texture("4", EncasedBlockStateGens.getMixerPart(casing, "side")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "mixer/" + casing + "/item")).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/mechanical_mixer/item")).texture("2", EncasedBlockStateGens.getCasingTexture(casing)).texture("11", EncasedBlockStateGens.getPressPart(casing, "top")).texture("4", EncasedBlockStateGens.getMixerPart(casing, "side")).texture("6", EncasedBlockStateGens.getMixerPart(casing, "head")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, ModelFile model) {
        EncasedBlockStateGens.axisBlock(ctx, prov, model, true);
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, ModelFile model, boolean uvLock) {
        EncasedBlockStateGens.axisBlock(ctx, prov, (Function<BlockState, ModelFile>)((Function)bs -> model), uvLock);
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> model, boolean uvLock) {
        if (model == null) {
            prov.simpleBlock((Block)ctx.get(), (ModelFile)new ModelFile.UncheckedModelFile("block/dirt"));
            return;
        }
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            return ConfiguredModel.builder().modelFile((ModelFile)model.apply(state)).uvLock(uvLock).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 180 : 0)).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    public static <T> ModelFile gearboxModel(RegistrateProvider p, String casing, String type) {
        String topKey;
        String casingKey = type.equals("item_vertical") ? "gearbox" : "1";
        String string = topKey = type.equals("item_vertical") ? "gearbox_top" : "0";
        if (EncasedBlockStateGens.isValidProvider(p)) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "gearbox/" + casing + "/" + type)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/gearbox/" + type)).texture(topKey, EncasedBlockStateGens.getCasingTexture(casing)).texture(casingKey, EncasedBlockStateGens.getGearboxTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return null;
    }

    public static <T> ModelFile shaftModel(RegistrateProvider p, String shaft) {
        if (EncasedBlockStateGens.isValidProvider(p)) {
            ModelBuilder file = Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "shaft/" + shaft)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/shaft")).texture("0", EncasedBlockStateGens.getShaftTexture(shaft)).texture("1", EncasedBlockStateGens.getShaftTexture(shaft) + (!shaft.equals("mldeg") ? "_top" : "")).texture("particle", EncasedBlockStateGens.getShaftTexture(shaft));
            if (shaft.equals("glass")) {
                file = file.renderType("cutout_mipped");
            }
            return file;
        }
        return null;
    }

    public static <T> ModelFile cogwheelModel(RegistrateProvider p, String cogwheel, boolean shaft) {
        if (EncasedBlockStateGens.isValidProvider(p)) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "cogwheel" + (shaft ? "" : "_shaftless") + "/" + cogwheel)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/cogwheel" + (shaft ? "" : "_shaftless"))).texture("1_2", EncasedBlockStateGens.getCogwheelTexture(cogwheel)).texture("particle", EncasedBlockStateGens.getShaftTexture(cogwheel));
        }
        return null;
    }

    public static <T> ModelFile largeCogwheelModel(RegistrateProvider p, String cogwheel, boolean shaft) {
        if (EncasedBlockStateGens.isValidProvider(p)) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "large_cogwheel" + (shaft ? "" : "_shaftless") + "/" + cogwheel)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/large_cogwheel" + (shaft ? "" : "_shaftless"))).texture("4", EncasedBlockStateGens.getLargeCogwheelTexture(cogwheel)).texture("particle", EncasedBlockStateGens.getShaftTexture(cogwheel));
        }
        return null;
    }

    public static <T> ModelFile encasedShaftModel(RegistrateProvider p, String shaft, String casing, boolean item) {
        if (!item) {
            return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "encased_shaft/" + casing)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased_shaft/block")).texture("casing", EncasedBlockStateGens.getCasingTexture(casing)).texture("opening", EncasedBlockStateGens.getGearboxTexture(casing)).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
        }
        return Objects.requireNonNull(EncasedBlockStateGens.createModelInBlock(p, "encased_shaft/items/" + shaft + "/" + casing)).parent((ModelFile)new ModelFile.UncheckedModelFile("create:block/encased_shaft/item")).texture("casing", EncasedBlockStateGens.getCasingTexture(casing)).texture("opening", EncasedBlockStateGens.getGearboxTexture(casing)).texture("1_0", EncasedBlockStateGens.getShaftTexture(shaft)).texture("1_1", EncasedBlockStateGens.getShaftTexture(shaft) + (!shaft.equals("mldeg") ? "_top" : "")).texture("particle", EncasedBlockStateGens.getCasingTexture(casing));
    }

    public static ModelBuilder<? extends ModelBuilder<?>> createModelInBlock(RegistrateProvider p, String path) {
        if (p instanceof RegistrateBlockstateProvider) {
            RegistrateBlockstateProvider provider = (RegistrateBlockstateProvider)p;
            return provider.models().getBuilder("block/" + path);
        }
        if (p instanceof RegistrateItemModelProvider) {
            RegistrateItemModelProvider provider = (RegistrateItemModelProvider)p;
            return provider.getBuilder("block/" + path);
        }
        return null;
    }

    public static boolean isValidProvider(RegistrateProvider p) {
        return p instanceof RegistrateBlockstateProvider || p instanceof RegistrateItemModelProvider;
    }

    public static String getCasingTexture(String casing) {
        if (casing.equals("normal")) {
            return "create:block/andesite_casing";
        }
        String modid = EncasedBlockStateGens.getModForCasing(casing);
        if (casing.equals("industrial_iron") || casing.equals("weathered_iron")) {
            return modid + ":block/" + casing + "_block";
        }
        return modid + ":block/" + casing + "_casing";
    }

    public static String getModForCasing(String casing) {
        if (casing.equals("brass") || casing.equals("andesite") || casing.equals("copper") || casing.equals("railway") || casing.equals("industrial_iron") || casing.equals("creative") || casing.equals("weathered_iron") || casing.equals("shadow_steel") || casing.equals("refined_radiance")) {
            return "create";
        }
        return "createcasing";
    }

    public static String getGearboxTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("normal")) {
            return "create:block/gearbox";
        }
        if (casing.equals("brass")) {
            return "create:block/" + casing + "_gearbox";
        }
        return "createcasing:block/gearboxes/" + casing;
    }

    public static String getShaftTexture(String shaft) {
        if (shaft.equals("normal")) {
            return "create:block/axis";
        }
        if (shaft.equals("bamboo")) {
            return "minecraft:block/stripped_bamboo_block";
        }
        if (EncasedBlockStateGens.isWoodenShaft(shaft)) {
            return "minecraft:block/stripped_" + shaft + "_" + (shaft.equals("crimson") || shaft.equals("warped") ? "stem" : "log");
        }
        return "createcasing:block/shafts/" + shaft;
    }

    public static String getCogwheelTexture(String cogwheel) {
        if (cogwheel.equals("normal")) {
            return "create:block/cogwheel";
        }
        return "createcasing:block/cogwheels/" + cogwheel;
    }

    public static String getLargeCogwheelTexture(String cogwheel) {
        if (cogwheel.equals("normal")) {
            return "create:block/large_cogwheel";
        }
        return "createcasing:block/large_cogwheels/" + cogwheel;
    }

    public static String getCogwheelSideTexture(String casing) {
        if (casing.equals("andesite") || casing.equals("brass")) {
            return "create:block/" + casing + "_encased_cogwheel_side";
        }
        return "createcasing:block/encased_cogwheels/" + casing;
    }

    public static String getLargeCogwheelSideTexture(String casing) {
        return EncasedBlockStateGens.getCogwheelSideTexture(casing) + "_connected";
    }

    public static String getPressPart(String casing, String part) {
        if (casing.equals("normal")) {
            return "create:block/mechanical_press_" + part;
        }
        return "createcasing:block/press_" + part + "s/" + casing;
    }

    public static String getMixerPart(String casing, String part) {
        if (casing.equals("normal")) {
            return "create:block/mixer_base_" + part;
        }
        return "createcasing:block/mixer_" + part + "s/" + casing;
    }

    public static String getDepotPart(String casing, String part) {
        if (casing.equals("normal")) {
            return "create:block/depot_" + part;
        }
        return "createcasing:block/depot_" + part + "s/" + casing;
    }

    public static String getChainDrivePart(String casing, String partSuffix) {
        String part;
        String string = part = partSuffix.equals("2") ? "end" : "middle";
        if (casing.equals("normal")) {
            return "create:block/encased_chain_drive" + part;
        }
        return "createcasing:block/encased_chain_drive_" + part + "s/" + casing;
    }

    public static String getChainDriveSideTexture(String casing) {
        if (casing.equals("normal")) {
            return "create:block/encased_chain_drive_side";
        }
        return "createcasing:block/encased_chain_drives/" + casing;
    }

    public static String getAdjustableChainGearshiftTexture(String casing, boolean powered) {
        if (casing.equals("normal")) {
            return "create:block/adjustable_chain_gearshift" + (powered ? "_powered" : "");
        }
        return "createcasing:block/adjustable_chain_gearshifts" + (powered ? "_powered" : "") + "/" + casing;
    }

    public static String getConveyorPortTexture(String casing) {
        if (casing.equals("normal")) {
            return "create:block/conveyor_port";
        }
        return "createcasing:block/conveyor_ports/" + casing;
    }

    public static String getConveyorCasingTexture(String casing) {
        if (casing.equals("normal")) {
            return "create:block/conveyor_casing";
        }
        return "createcasing:block/conveyor_casings/" + casing;
    }

    public static String getBullWheelTexture(String casing) {
        if (casing.equals("normal")) {
            return "create:block/bullwheel";
        }
        return "createcasing:block/bullwheels/" + casing;
    }

    private static boolean isWoodenShaft(String shaft) {
        return WoodType.m_61843_().anyMatch(w -> w.f_61839_().toLowerCase().equalsIgnoreCase(shaft));
    }
}

