/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.BlockEntry;
import fr.iglee42.createcasing.registries.EncasedBlocks;
import java.util.Arrays;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum WoodBlocks {
    OAK(Items.f_42647_, EncasedBlocks.OAK_SHAFT, EncasedBlocks.OAK_COGWHEEL, EncasedBlocks.OAK_LARGE_COGWHEEL),
    SPRUCE(Items.f_42700_, EncasedBlocks.SPRUCE_SHAFT, (BlockEntry<? extends Block>)AllBlocks.COGWHEEL, (BlockEntry<? extends Block>)AllBlocks.LARGE_COGWHEEL),
    BIRCH(Items.f_42753_, EncasedBlocks.BIRCH_SHAFT, EncasedBlocks.BIRCH_COGWHEEL, EncasedBlocks.BIRCH_LARGE_COGWHEEL),
    ACACIA(Items.f_42795_, EncasedBlocks.ACACIA_SHAFT, EncasedBlocks.ACACIA_COGWHEEL, EncasedBlocks.ACACIA_LARGE_COGWHEEL),
    DARK_OAK(Items.f_42796_, EncasedBlocks.DARK_OAK_SHAFT, EncasedBlocks.DARK_OAK_COGWHEEL, EncasedBlocks.DARK_OAK_LARGE_COGWHEEL),
    JUNGLE(Items.f_42794_, EncasedBlocks.JUNGLE_SHAFT, EncasedBlocks.JUNGLE_COGWHEEL, EncasedBlocks.JUNGLE_LARGE_COGWHEEL),
    MANGROVE(Items.f_220174_, EncasedBlocks.MANGROVE_SHAFT, EncasedBlocks.MANGROVE_COGWHEEL, EncasedBlocks.MANGROVE_LARGE_COGWHEEL),
    CHERRY(Items.f_271154_, EncasedBlocks.CHERRY_SHAFT, EncasedBlocks.CHERRY_COGWHEEL, EncasedBlocks.CHERRY_LARGE_COGWHEEL),
    BAMBOO(Items.f_243694_, EncasedBlocks.BAMBOO_SHAFT, EncasedBlocks.BAMBOO_COGWHEEL, EncasedBlocks.BAMBOO_LARGE_COGWHEEL),
    CRIMSON(Items.f_42797_, EncasedBlocks.CRIMSON_SHAFT, EncasedBlocks.CRIMSON_COGWHEEL, EncasedBlocks.CRIMSON_LARGE_COGWHEEL),
    WARPED(Items.f_42798_, EncasedBlocks.WARPED_SHAFT, EncasedBlocks.WARPED_COGWHEEL, EncasedBlocks.WARPED_LARGE_COGWHEEL),
    ANDESITE((Item)AllItems.ANDESITE_ALLOY.get(), (BlockEntry<? extends Block>)AllBlocks.SHAFT, null, null),
    BRASS((Item)AllItems.BRASS_INGOT.get(), EncasedBlocks.BRASS_SHAFT, null, null),
    GLASS(Items.f_41904_, EncasedBlocks.GLASS_SHAFT, null, null),
    MLDEG(Items.f_42755_, EncasedBlocks.MLDEG_SHAFT, null, null);

    private final Item item;
    private final BlockEntry<? extends Block> shaft;
    private final BlockEntry<? extends Block> cogwheel;
    private final BlockEntry<? extends Block> largeCogwheel;

    private WoodBlocks(Item item, BlockEntry<? extends Block> shaft, BlockEntry<? extends Block> cogwheel, BlockEntry<? extends Block> largeCogwheel) {
        this.item = item;
        this.shaft = shaft;
        this.cogwheel = cogwheel;
        this.largeCogwheel = largeCogwheel;
    }

    public static WoodBlocks getBlockByItem(Item item) {
        return Arrays.stream(WoodBlocks.values()).filter(e -> e.item.equals(item)).findFirst().orElse(null);
    }

    public static boolean hasBlocksForItem(Item item) {
        return WoodBlocks.getBlockByItem(item) != null;
    }

    public Item getItem() {
        return this.item;
    }

    public BlockEntry<? extends Block> getShaft() {
        return this.shaft;
    }

    public BlockEntry<? extends Block> getCogwheel() {
        return this.cogwheel;
    }

    public BlockEntry<? extends Block> getLargeCogwheel() {
        return this.largeCogwheel;
    }

    public boolean hasShaft() {
        return this.getShaft() != null;
    }

    public boolean hasCogwheel() {
        return this.getCogwheel() != null;
    }

    public boolean hasLargeCogwheel() {
        return this.getLargeCogwheel() != null;
    }

    public static boolean isShaft(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasShaft() && b.getShaft().has(state));
    }

    public static boolean isCogwheel(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasCogwheel() && b.getCogwheel().has(state));
    }

    public static boolean isLargeCogwheel(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasLargeCogwheel() && b.getLargeCogwheel().has(state));
    }

    public boolean isInSet(BlockState state) {
        return this.hasShaft() && this.shaft.has(state) || this.hasCogwheel() && this.cogwheel.has(state) || this.hasLargeCogwheel() && this.largeCogwheel.has(state);
    }
}

