/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.multi_block;

import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.multi_block.MultiBlockCalculater;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.multi_block.MultiBlockRunner;
import de.geheimagentnr1.minecraft_forge_api.elements.blocks.BlockItemInterface;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public abstract class MultiBlock
extends Block
implements BlockItemInterface {
    protected IntegerProperty X_SIZE;
    protected IntegerProperty Y_SIZE;
    protected IntegerProperty Z_SIZE;

    protected MultiBlock(@NotNull BlockBehaviour.Properties _properties) {
        super(_properties.m_278166_(PushReaction.BLOCK));
    }

    protected abstract int getXSize();

    protected abstract int getYSize();

    protected abstract int getZSize();

    protected abstract boolean[][][] hasBlockStatesAtPos();

    @NotNull
    protected BlockState getDefaultState(boolean left_sided) {
        return this.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_8125_();
        Player player = context.m_43723_();
        int z_index = 0;
        boolean left_sided = false;
        if (player != null && (left_sided = MultiBlock.shouldSideBeLeft(facing, context.m_43723_()))) {
            z_index = this.getZSize() - 1;
            pos = pos.m_5484_(facing.m_122428_(), z_index);
        }
        if (this.isPlaceFree(context.m_43725_(), pos, facing, context)) {
            return this.withSize(this.withSize(this.withSize((BlockState)this.getDefaultState(left_sided).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing), this.X_SIZE, 0), this.Y_SIZE, 0), this.Z_SIZE, z_index);
        }
        return null;
    }

    private static boolean shouldSideBeLeft(@NotNull Direction direction, @NotNull Player player) {
        float player_yaw_degree = player.m_5675_(1.0f) * ((float)Math.PI / 180);
        return switch (direction) {
            case Direction.NORTH -> {
                if (Mth.m_14031_((float)player_yaw_degree) > 0.0f) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (Mth.m_14031_((float)player_yaw_degree) < 0.0f) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (Mth.m_14089_((float)player_yaw_degree) < 0.0f) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (Mth.m_14089_((float)player_yaw_degree) > 0.0f) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean isPlaceFree(final @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction facing, final @NotNull BlockPlaceContext context) {
        return this.calculateForBlocks(level, pos, facing, new MultiBlockCalculater<Boolean>(){

            @Override
            public Optional<Boolean> calculate(int x, int y, int z, BlockPos blockPos) {
                if (!level.m_8055_(blockPos).m_60629_(context)) {
                    return Optional.of(false);
                }
                return Optional.empty();
            }

            @Override
            public Boolean getAlternative() {
                return true;
            }
        }, false);
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        int z_index = this.getSize(state, this.Z_SIZE);
        if (z_index != 0) {
            pos = pos.m_5484_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122428_(), z_index);
        }
        this.runForBlocks(level, pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (x, y, z, blockPos) -> level.m_7731_(blockPos, this.withSize(this.withSize(this.withSize(state, this.X_SIZE, x), this.Y_SIZE, y), this.Z_SIZE, z), 3), false);
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        this.runForBlocks(level, this.getZeroPos(state, pos), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (x, y, z, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            if (!level.f_46443_ && !player.m_7500_() && player.m_36298_(blockState)) {
                Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)level.m_7702_(blockPos), (Entity)player, (ItemStack)player.m_21205_());
            }
        }, true);
        this.runForBlocks(level, this.getZeroPos(state, pos), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (x, y, z, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            level.m_7471_(blockPos, true);
            super.m_5707_(level, blockPos, blockState, player);
        }, true);
        super.m_5707_(level, pos, state, player);
    }

    public void onBlockExploded(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        this.runForBlocks(level, this.getZeroPos(state, pos), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (x, y, z, blockPos) -> {
            if (!blockPos.equals((Object)pos) && !level.f_46443_) {
                BlockState blockState = level.m_8055_(blockPos);
                Block.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, (BlockEntity)level.m_7702_(blockPos));
            }
        }, true);
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != this) {
            this.runForBlocks(level, this.getZeroPos(state, pos), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (x, y, z, blockPos) -> {
                BlockState blockState = level.m_8055_(blockPos);
                super.m_6810_(blockState, level, blockPos, Blocks.f_50016_.m_49966_(), isMoving);
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            }, true);
        }
    }

    @NotNull
    protected BlockPos getZeroPos(@NotNull BlockState state, @NotNull BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        pos = pos.m_5484_(facing.m_122424_(), this.getSize(state, this.X_SIZE));
        pos = pos.m_6625_(this.getSize(state, this.Y_SIZE));
        pos = pos.m_5484_(facing.m_122428_(), this.getSize(state, this.Z_SIZE));
        return pos;
    }

    protected boolean checkBlockAtPos(@NotNull Level level, @NotNull BlockPos pos, boolean checkIsBlockAtPos) {
        return !checkIsBlockAtPos || level.m_8055_(pos).m_60734_() == this;
    }

    protected void runForBlocks(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull MultiBlockRunner runner, boolean checkIsBlockAtPos) {
        boolean[][][] hasStatesAtPos = this.hasBlockStatesAtPos();
        BlockPos x_pos = pos;
        Direction z_facing = facing.m_122427_();
        int x = 0;
        while (x < this.getXSize()) {
            BlockPos y_pos = x_pos;
            int y = 0;
            while (y < this.getYSize()) {
                BlockPos z_pos = y_pos;
                int z = 0;
                while (z < this.getZSize()) {
                    if (hasStatesAtPos[x][y][z] && this.checkBlockAtPos(level, z_pos, checkIsBlockAtPos)) {
                        runner.run(x, y, z, z_pos);
                    }
                    ++z;
                    z_pos = z_pos.m_121945_(z_facing);
                }
                ++y;
                y_pos = y_pos.m_7494_();
            }
            ++x;
            x_pos = x_pos.m_121945_(facing);
        }
    }

    private <T> T calculateForBlocks(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull MultiBlockCalculater<T> calculater, boolean checkIsBlockAtPos) {
        boolean[][][] hasStatesAtPos = this.hasBlockStatesAtPos();
        Direction z_facing = facing.m_122427_();
        BlockPos x_pos = pos;
        int x = 0;
        while (x < this.getXSize()) {
            BlockPos y_pos = x_pos;
            int y = 0;
            while (y < this.getYSize()) {
                BlockPos z_pos = y_pos;
                int z = 0;
                while (z < this.getZSize()) {
                    Optional<T> result;
                    if (hasStatesAtPos[x][y][z] && this.checkBlockAtPos(level, z_pos, checkIsBlockAtPos) && (result = calculater.calculate(x, y, z, z_pos)).isPresent()) {
                        return result.get();
                    }
                    ++z;
                    z_pos = z_pos.m_121945_(z_facing);
                }
                ++y;
                y_pos = y_pos.m_7494_();
            }
            ++x;
            x_pos = x_pos.m_121945_(facing);
        }
        return calculater.getAlternative();
    }

    protected boolean isPowered(final @NotNull Level level, @NotNull BlockPos zeroPos, @NotNull Direction facing) {
        return this.calculateForBlocks(level, zeroPos, facing, new MultiBlockCalculater<Boolean>(){

            @Override
            public Optional<Boolean> calculate(int x, int y, int z, BlockPos blockPos) {
                if (level.m_276867_(blockPos)) {
                    return Optional.of(true);
                }
                return Optional.empty();
            }

            @Override
            public Boolean getAlternative() {
                return false;
            }
        }, true);
    }

    private int getSize(@NotNull BlockState state, @NotNull IntegerProperty property) {
        if (state.m_61138_((Property)property)) {
            return (Integer)state.m_61143_((Property)property);
        }
        return 0;
    }

    @NotNull
    private BlockState withSize(@NotNull BlockState state, @NotNull IntegerProperty property, int value) {
        if (state.m_61138_((Property)property)) {
            return (BlockState)state.m_61124_((Property)property, (Comparable)Integer.valueOf(value));
        }
        return state;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        if (this.getXSize() > 1) {
            this.X_SIZE = IntegerProperty.m_61631_((String)"x", (int)0, (int)(this.getXSize() - 1));
            builder.m_61104_(new Property[]{this.X_SIZE});
        }
        if (this.getYSize() > 1) {
            this.Y_SIZE = IntegerProperty.m_61631_((String)"y", (int)0, (int)(this.getYSize() - 1));
            builder.m_61104_(new Property[]{this.Y_SIZE});
        }
        if (this.getZSize() > 1) {
            this.Z_SIZE = IntegerProperty.m_61631_((String)"z", (int)0, (int)(this.getZSize() - 1));
            builder.m_61104_(new Property[]{this.Z_SIZE});
        }
    }
}

