/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.integrations.jei.categories.dyed;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlockItem;
import de.geheimagentnr1.manyideas_core.elements.recipes.ModRecipeTypesRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.ColorIngredient;
import de.geheimagentnr1.manyideas_core.elements.recipes.dyed_recipes.DyedRecipe;
import de.geheimagentnr1.manyideas_core.util.DyeBlockHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class JeiDyedRecipe {
    @NotNull
    private final List<List<ItemStack>> inputs;
    @NotNull
    private final ItemStack result;

    private JeiDyedRecipe(@NotNull List<List<ItemStack>> _inputs, @NotNull ItemStack _result) {
        this.inputs = _inputs;
        this.result = _result;
    }

    @NotNull
    private static ArrayList<JeiDyedRecipe> create(@NotNull DyedRecipe recipe) {
        ArrayList<JeiDyedRecipe> recipes = new ArrayList<JeiDyedRecipe>();
        ItemStack result = recipe.getResult();
        if (!result.m_41619_()) {
            for (Color color : Color.values()) {
                ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
                for (Ingredient ingredient : recipe.m_7527_()) {
                    ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                    if (ingredient instanceof ColorIngredient) {
                        ItemStack colorStack = ((ColorIngredient)ingredient).getStack(color);
                        if (colorStack != null) {
                            itemStacks.add(colorStack);
                        }
                    } else {
                        ItemStack[] matchingStacks = ingredient.m_43908_();
                        if (matchingStacks.length == 1 && matchingStacks[0].m_41720_() instanceof DyeBlockItem) {
                            for (Color matchingStackColor : Color.values()) {
                                itemStacks.add(DyeBlockHelper.setColorToItemStack(matchingStacks[0].m_41777_(), matchingStackColor));
                            }
                        } else {
                            itemStacks.addAll(Arrays.asList(ingredient.m_43908_()));
                        }
                    }
                    inputs.add(itemStacks);
                }
                recipes.add(new JeiDyedRecipe(inputs, DyeBlockHelper.setColorToItemStack(result.m_41777_(), color)));
            }
        }
        return recipes;
    }

    @NotNull
    public static List<JeiDyedRecipe> getRecipes() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_).map(clientWorld -> clientWorld.m_7465_().m_44013_(ModRecipeTypesRegisterFactory.DYED)).orElseGet(ArrayList::new).stream().map(JeiDyedRecipe::create).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NotNull
    List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }
}

