/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.util.voxel_shapes;

import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeHelper;
import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeVector;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeMemory {
    private final VoxelShape north;
    private final VoxelShape east;
    private final VoxelShape south;
    private final VoxelShape west;
    private final VoxelShape up;
    private final VoxelShape down;

    private VoxelShapeMemory(VoxelShape _north, VoxelShape _east, VoxelShape _south, VoxelShape _west, VoxelShape _up, VoxelShape _down) {
        this.north = _north;
        this.east = _east;
        this.south = _south;
        this.west = _west;
        this.up = _up;
        this.down = _down;
    }

    public static VoxelShapeMemory createHorizontalAxisVoxelShapes(Direction facing, VoxelShapeVector ... vectors) {
        VoxelShapeVector[] north_vectors = VoxelShapeHelper.vectorsToNorthVectors(vectors, facing);
        VoxelShape north = VoxelShapeHelper.vectorsToVoxelShape(north_vectors);
        VoxelShape east = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.eastVectors(north_vectors));
        return new VoxelShapeMemory(north, east, null, null, null, null);
    }

    public static VoxelShapeMemory createHorizontalVoxelShapes(Direction facing, VoxelShapeVector ... vectors) {
        VoxelShapeVector[] north_vectors = VoxelShapeHelper.vectorsToNorthVectors(vectors, facing);
        VoxelShape north = VoxelShapeHelper.vectorsToVoxelShape(north_vectors);
        VoxelShape east = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.eastVectors(north_vectors));
        VoxelShape south = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.southVectors(north_vectors));
        VoxelShape west = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.westVectors(north_vectors));
        return new VoxelShapeMemory(north, east, south, west, null, null);
    }

    public static VoxelShapeMemory createVoxelShapes(Direction facing, VoxelShapeVector ... vectors) {
        VoxelShapeVector[] north_vectors = VoxelShapeHelper.vectorsToNorthVectors(vectors, facing);
        VoxelShape north = VoxelShapeHelper.vectorsToVoxelShape(north_vectors);
        VoxelShape east = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.eastVectors(north_vectors));
        VoxelShape south = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.southVectors(north_vectors));
        VoxelShape west = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.westVectors(north_vectors));
        VoxelShape up = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.upVectors(north_vectors));
        VoxelShape down = VoxelShapeHelper.vectorsToVoxelShape(VoxelShapeHelper.downVectors(north_vectors));
        return new VoxelShapeMemory(north, east, south, west, up, down);
    }

    public static VoxelShape createVoxelShape(VoxelShapeVector ... vectors) {
        return VoxelShapeHelper.vectorsToVoxelShape(vectors);
    }

    public VoxelShape getShapeFromHorizontalAxis(Direction.Axis horizontal_axis) {
        return switch (horizontal_axis) {
            case Direction.Axis.Z -> this.north;
            case Direction.Axis.X -> this.east;
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape getShapeFromHorizontalFacing(Direction horizontal_facing) {
        return switch (horizontal_facing) {
            case Direction.NORTH -> this.north;
            case Direction.EAST -> this.east;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape getShapeFromFacing(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.north;
            case Direction.EAST -> this.east;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
        };
    }
}

