/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class SawmillRecipeSerializer<RECIPE extends SawmillRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public SawmillRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)input);
        ItemStack mainOutput = ItemStack.f_41583_;
        ItemStack secondaryOutput = ItemStack.f_41583_;
        double secondaryChance = 0.0;
        if (json.has("secondaryOutput") || json.has("secondaryChance")) {
            if (json.has("mainOutput") && (mainOutput = SerializerHelper.getItemStack(json, "mainOutput")).m_41619_()) {
                throw new JsonSyntaxException("Sawmill main recipe output must not be empty, if it is defined.");
            }
            JsonElement chance = json.get("secondaryChance");
            if (!GsonHelper.m_13872_((JsonElement)chance)) {
                throw new JsonSyntaxException("Expected secondaryChance to be a number greater than zero.");
            }
            secondaryChance = chance.getAsJsonPrimitive().getAsDouble();
            if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
                throw new JsonSyntaxException("Expected secondaryChance to be greater than zero, and less than or equal to one.");
            }
            secondaryOutput = SerializerHelper.getItemStack(json, "secondaryOutput");
            if (secondaryOutput.m_41619_()) {
                throw new JsonSyntaxException("Sawmill secondary recipe output must not be empty, if there is no main output.");
            }
        } else {
            mainOutput = SerializerHelper.getItemStack(json, "mainOutput");
            if (mainOutput.m_41619_()) {
                throw new JsonSyntaxException("Sawmill main recipe output must not be empty, if there is no secondary output.");
            }
        }
        return this.factory.create(recipeId, inputIngredient, mainOutput, secondaryOutput, secondaryChance);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStack mainOutput = buffer.m_130267_();
            ItemStack secondaryOutput = buffer.m_130267_();
            double secondaryChance = buffer.readDouble();
            return this.factory.create(recipeId, inputIngredient, mainOutput, secondaryOutput, secondaryChance);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading sawmill recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((SawmillRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing sawmill recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends SawmillRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStack var3, ItemStack var4, double var5);
    }
}

