/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public final class ContainerSerializationHelper
extends ContainerHelper {
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SLOT = "Slot";

    private ContainerSerializationHelper() {
    }

    @Deprecated
    public static CompoundTag saveAllItems(CompoundTag tag, Container container) {
        return ContainerSerializationHelper.saveAllItems(tag, container, true);
    }

    @Deprecated
    public static CompoundTag saveAllItems(CompoundTag tag, Container container, boolean saveEmpty) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128344_(TAG_SLOT, (byte)i);
            itemStack.m_41739_(compoundTag);
            listTag.add((Object)compoundTag);
        }
        if (!listTag.isEmpty() || saveEmpty) {
            tag.m_128365_(TAG_ITEMS, (Tag)listTag);
        }
        return tag;
    }

    @Deprecated
    public static void loadAllItems(CompoundTag tag, Container container) {
        ListTag listTag = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            int j = compoundTag.m_128445_(TAG_SLOT) & 0xFF;
            if (j >= container.m_6643_()) continue;
            container.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag));
        }
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        return ContainerHelper.m_18973_((CompoundTag)tag, items);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tag, container, true, lookupProvider);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items, true, lookupProvider);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, Container container, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(TAG_ITEMS, tag, container.m_6643_(), arg_0 -> ((Container)container).m_8020_(arg_0), saveEmpty, lookupProvider);
    }

    public static CompoundTag saveAllItems(CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerHelper.m_18976_((CompoundTag)tag, items, (boolean)saveEmpty);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        return ContainerSerializationHelper.saveAllItems(tagKey, tag, items.size(), arg_0 -> items.get(arg_0), saveEmpty, lookupProvider);
    }

    public static CompoundTag saveAllItems(String tagKey, CompoundTag tag, int size, IntFunction<ItemStack> itemGetter, boolean saveEmpty, HolderLookup.Provider lookupProvider) {
        ListTag listTag = ContainerSerializationHelper.createTag(size, itemGetter, lookupProvider);
        if (!listTag.isEmpty() || saveEmpty) {
            tag.m_128365_(tagKey, (Tag)listTag);
        }
        return tag;
    }

    public static ListTag createTag(int size, IntFunction<ItemStack> itemGetter, HolderLookup.Provider lookupProvider) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = itemGetter.apply(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128344_(TAG_SLOT, (byte)i);
            listTag.add((Object)itemStack.m_41739_(compoundTag));
        }
        return listTag;
    }

    public static void loadAllItems(CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        ContainerHelper.m_18980_((CompoundTag)tag, items);
    }

    public static void loadAllItems(CompoundTag tag, Container container, HolderLookup.Provider lookupProvider) {
        ContainerSerializationHelper.loadAllItems(TAG_ITEMS, tag, container.m_6643_(), (stack, value) -> container.m_6836_(value, stack), lookupProvider);
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider lookupProvider) {
        ContainerSerializationHelper.loadAllItems(tagKey, tag, items.size(), (stack, value) -> items.set(value, stack), lookupProvider);
    }

    public static void loadAllItems(String tagKey, CompoundTag tag, int size, ObjIntConsumer<ItemStack> itemSetter, HolderLookup.Provider lookupProvider) {
        ListTag listTag = tag.m_128437_(tagKey, 10);
        ContainerSerializationHelper.fromTag(listTag, size, itemSetter, lookupProvider);
    }

    public static void fromTag(ListTag listTag, int size, ObjIntConsumer<ItemStack> itemSetter, HolderLookup.Provider lookupProvider) {
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            int slot = compoundTag.m_128445_(TAG_SLOT) & 0xFF;
            if (slot >= size) continue;
            itemSetter.accept(ItemStack.m_41712_((CompoundTag)compoundTag), slot);
        }
    }
}

