/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropUpgradeItems(Level level, BlockPos pos, UpgradeData upgrades) {
        for (int i = 0; i < upgrades.getSlotCount(); ++i) {
            ItemStack stack = upgrades.getUpgrade(i);
            if (!stack.m_41619_() && stack.m_41720_() != ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                DrawerInventoryHelper.spawnItemStack(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
            }
            upgrades.setUpgrade(i, ItemStack.f_41583_);
        }
    }

    public static void dropInventoryItems(Level world, BlockPos pos, IDrawerGroup group) {
        int remainingStacks = (Integer)ModCommonConfig.INSTANCE.DRAWERS.storage.dropStackLimit.get();
        while (remainingStacks > 0) {
            int remainingStart = remainingStacks;
            for (int i = 0; i < group.getDrawerCount(); ++i) {
                IDrawer drawer = group.getDrawer(i);
                if (!drawer.isEnabled() || drawer.getStoredItemCount() == 0 || remainingStacks == 0) continue;
                ItemStack stack = drawer.getStoredItemPrototype().m_41777_();
                int storedCount = drawer.getStoredItemCount();
                int stackLimit = stack.m_41741_();
                int stackSize = Math.min(storedCount, stackLimit);
                stack.m_41764_(stackSize);
                if (stack.m_41619_()) continue;
                DrawerInventoryHelper.spawnItemStack(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
                drawer.adjustStoredItemCount(-stackSize);
                --remainingStacks;
            }
            if (remainingStart != remainingStacks) continue;
            break;
        }
    }

    private static void spawnItemStack(Level world, double x, double y, double z, ItemStack stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.m_41619_()) {
            ItemEntity entityitem = new ItemEntity(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, stack.m_41620_(RANDOM.nextInt(21) + 10));
            float velocity = 0.05f;
            entityitem.m_20334_(RANDOM.nextGaussian() * (double)velocity, RANDOM.nextGaussian() * (double)velocity + (double)0.2f, RANDOM.nextGaussian() * (double)velocity);
            world.m_7967_((Entity)entityitem);
        }
    }
}

