/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.block.XKDBlock;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class MimicWallsLoader {
    public static ImmutableList<MimicWallBlock> MIMIC_WALLS = ImmutableList.of();
    public static final ResourceKey<CreativeModeTab> STRUCTURE_TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)XKDeco.id("structure"));

    public static void addMimicWallBlocks(BiConsumer<ResourceLocation, Block> consumer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder holder : BuiltInRegistries.f_256975_.m_206115_()) {
            ResourceLocation registryName;
            Block block = (Block)holder.m_203334_();
            if (!(block instanceof WallBlock)) continue;
            WallBlock wall = (WallBlock)block;
            if (block instanceof MimicWallBlock || block.m_49966_().m_155947_() || block.m_49965_().m_61092_().size() != Blocks.f_50274_.m_49965_().m_61092_().size() || !(registryName = ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_()).m_135815_().endsWith("_wall")) continue;
            MimicWallBlock mimicWall = new MimicWallBlock(wall);
            String name = MimicWallBlock.toMimicId(((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_());
            consumer.accept(XKDeco.id(name), (Block)mimicWall);
            builder.add((Object)mimicWall);
        }
        MIMIC_WALLS = builder.build();
    }

    public static void addMimicWallItems(BiConsumer<ResourceLocation, Item> consumer) {
        for (MimicWallBlock wall : MIMIC_WALLS) {
            ResourceLocation name = BuiltInRegistries.f_256975_.m_7981_((Object)wall);
            consumer.accept(name, (Item)new ModBlockItem((Block)wall, new Item.Properties()));
        }
    }

    public static void addMimicWallBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> tags) {
        List walls = MIMIC_WALLS.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_263177_(arg_0)).toList();
        MimicWallsLoader.appendTagValues(tags, BlockTags.f_13032_, walls);
        MimicWallsLoader.appendTagValues(tags, BlockTags.f_144282_, walls);
        MimicWallsLoader.appendTagValues(tags, XKDBlock.NON_DIAGONAL_WALLS, walls);
    }

    public static void addMimicWallItemTags(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        List walls = MIMIC_WALLS.stream().map(Block::m_5456_).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_263177_(arg_0)).toList();
        MimicWallsLoader.appendTagValues(tags, ItemTags.f_13140_, walls);
    }

    private static <T> void appendTagValues(Map<ResourceLocation, Collection<Holder<T>>> tags, TagKey<T> key, List<Holder<T>> holders) {
        ArrayList list = Lists.newArrayList((Iterable)tags.getOrDefault(key.f_203868_(), List.of()));
        list.addAll(holders);
        tags.put(key.f_203868_(), list);
    }
}

