/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.blocks.machines.EnergizerBlock;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class EnergizerBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.PUSH_PULL, ConstantComponents.SIDE_CONFIG_ENERGY));

    public EnergizerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 1);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return null;
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new SimpleEnergyContainer(MachineConfig.energizerEnergyCapacity, MachineConfig.ostrumTierMaxEnergyInOut, MachineConfig.ostrumTierMaxEnergyInOut){

            public void setEnergy(long energy) {
                super.setEnergy(energy);
                if (EnergizerBlockEntity.this.level().m_46467_() % 10L != 0L) {
                    return;
                }
                EnergizerBlockEntity.this.onEnergyChange();
            }
        });
        return this.energyContainer;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (!this.canFunction()) {
            return;
        }
        this.distributeToChargeSlot(level, pos);
        if (time % 10L == 0L) {
            this.setLit(!this.m_8020_(0).m_41619_());
        }
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pushEnergyNearby(this, pos, this.getEnergyStorage().maxExtract(), sideConfig.get(0), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{0};
    }

    @Override
    public EnergyContainerMachineBlockEntity.ChargeSlotType getChargeSlotType() {
        return EnergyContainerMachineBlockEntity.ChargeSlotType.NONE;
    }

    public void onEnergyChange() {
        int charge = Math.round((float)this.getEnergyStorage().getStoredEnergy() / (float)this.getEnergyStorage().getMaxCapacity() * 5.0f);
        this.level().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)EnergizerBlock.POWER, (Comparable)Integer.valueOf(charge)), 2);
    }

    public void distributeToChargeSlot(ServerLevel level, BlockPos pos) {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41619_()) {
            return;
        }
        if (!EnergyContainer.holdsEnergy((ItemStack)stack)) {
            return;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        if (EnergyApi.moveEnergy((BlockEntity)this, null, (ItemStackHolder)holder, (long)this.getEnergyStorage().maxExtract(), (boolean)false) == 0L) {
            return;
        }
        this.m_6836_(0, holder.getStack());
        ModUtils.sendParticles(level, ParticleTypes.f_175830_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.8, (double)pos.m_123343_() + 0.5, 2, 0.1, 0.1, 0.1, 0.1);
    }
}

