/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LaunchingDimensionHandler
extends SaveHandler {
    private final Map<UUID, LaunchedDimensions> data = new HashMap<UUID, LaunchedDimensions>();

    public void loadData(CompoundTag tag) {
        tag.m_128431_().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            CompoundTag planetsTag = tag.m_128469_(key);
            HashMap<ResourceKey<Level>, GlobalPos> planets = new HashMap<ResourceKey<Level>, GlobalPos>();
            for (String allKey : planetsTag.m_128431_()) {
                GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)planetsTag.m_128469_(allKey)).result().ifPresent(pos -> {
                    ResourceLocation planet = ResourceLocation.m_135820_((String)allKey);
                    planets.put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Objects.requireNonNull(planet)), (GlobalPos)pos);
                });
            }
            this.data.put(uuid, new LaunchedDimensions(planets));
        });
    }

    public void saveData(CompoundTag tag) {
        this.data.forEach((uuid, data) -> {
            CompoundTag planetsTag = new CompoundTag();
            for (Map.Entry<ResourceKey<Level>, GlobalPos> entry : data.dimensions.entrySet()) {
                GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue()).result().ifPresent(pos -> planetsTag.m_128365_(((ResourceKey)entry.getKey()).m_135782_().toString(), pos));
            }
            tag.m_128365_(uuid.toString(), (Tag)planetsTag);
        });
    }

    public static LaunchingDimensionHandler read(ServerLevel level) {
        return (LaunchingDimensionHandler)LaunchingDimensionHandler.read((Level)level, null, LaunchingDimensionHandler::new, (String)"adastra_launching_dimensions");
    }

    private static LaunchedDimensions get(Player player, ServerLevel level, boolean create) {
        Map<UUID, LaunchedDimensions> data = LaunchingDimensionHandler.read((ServerLevel)level).data;
        if (data.containsKey(player.m_20148_())) {
            return data.get(player.m_20148_());
        }
        if (create) {
            LaunchedDimensions dimensions = new LaunchedDimensions();
            data.put(player.m_20148_(), dimensions);
            return dimensions;
        }
        return null;
    }

    public static Optional<GlobalPos> getSpawningLocation(Player player, ServerLevel level, Planet planet) {
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get(player, level, false);
        if (dimensions == null) {
            return Optional.empty();
        }
        GlobalPos pos = dimensions.dimensions.get(planet.dimension());
        if (pos != null) {
            boolean validPlanet;
            boolean bl = validPlanet = planet.additionalLaunchDimensions().contains(pos.m_122640_()) || planet.dimension().equals((Object)pos.m_122640_());
            if (validPlanet) {
                return Optional.of(pos);
            }
        }
        return Optional.empty();
    }

    public static Collection<GlobalPos> getAllSpawnLocations(ServerPlayer player) {
        HashSet<GlobalPos> positions = new HashSet<GlobalPos>();
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get((Player)player, player.m_284548_(), false);
        if (dimensions == null) {
            return positions;
        }
        for (Map.Entry<ResourceKey<Level>, GlobalPos> entry : dimensions.dimensions.entrySet()) {
            positions.add(entry.getValue());
        }
        return positions;
    }

    public static void addSpawnLocation(Player player, ServerLevel level) {
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get(player, level, true);
        if (dimensions == null) {
            return;
        }
        ResourceKey<Level> planet = AdAstraData.getPlanetLocation((ResourceKey<Level>)level.m_46472_());
        if (planet == null) {
            return;
        }
        dimensions.dimensions.put(planet, GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)player.m_20183_()));
    }

    public boolean m_77764_() {
        return true;
    }

    private record LaunchedDimensions(Map<ResourceKey<Level>, GlobalPos> dimensions) {
        public LaunchedDimensions() {
            this(new HashMap<ResourceKey<Level>, GlobalPos>());
        }
    }
}

