/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut.cap;

import com.kipti.bnb.content.girder_strut.geometry.GirderGeometry;
import com.kipti.bnb.content.girder_strut.geometry.GirderVertex;
import com.kipti.bnb.content.girder_strut.mesh.GirderMeshQuad;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class GirderCapAccumulator {
    private final ResourceLocation capTexture;
    private final List<CapSegment> segments = new ArrayList<CapSegment>();

    public GirderCapAccumulator(ResourceLocation capTexture) {
        this.capTexture = capTexture;
    }

    public void addSegments(TextureAtlasSprite sourceSprite, int tintIndex, boolean shade, List<GirderMeshQuad.Segment> newSegments) {
        for (GirderMeshQuad.Segment segment : newSegments) {
            CapVertex start = new CapVertex(segment.start(), sourceSprite);
            CapVertex end = new CapVertex(segment.end(), sourceSprite);
            if (GirderGeometry.positionsEqual(start.position(), end.position())) continue;
            CapSegment candidate = new CapSegment(start, end, tintIndex, shade);
            this.segments.add(candidate);
        }
    }

    public void emitCapsToConsumer(Vector3f planeNormal, List<Consumer<BufferBuilder>> bufferConsumer, Function<Vector3f, Integer> lightFunction) {
        LoopEdge startEdge;
        if (this.segments.isEmpty()) {
            return;
        }
        Vector3f normal = new Vector3f((Vector3fc)planeNormal);
        if (normal.lengthSquared() <= 1.0E-4f) {
            return;
        }
        normal.normalize();
        TextureAtlasSprite capSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.capTexture);
        ArrayList<CapVertex> uniqueVertices = new ArrayList<CapVertex>();
        ArrayList<LoopEdge> edges = new ArrayList<LoopEdge>();
        for (CapSegment segment : this.segments) {
            int endIndex;
            int startIndex = this.indexFor(uniqueVertices, segment.start());
            if (startIndex == (endIndex = this.indexFor(uniqueVertices, segment.end()))) continue;
            edges.add(new LoopEdge(startIndex, endIndex, segment.tintIndex(), segment.shade()));
        }
        int loopCount = 0;
        while ((startEdge = this.findUnusedEdge(edges)) != null) {
            ArrayList<Integer> loop = new ArrayList<Integer>();
            loop.add(startEdge.start());
            loop.add(startEdge.end());
            startEdge.markUsed();
            int tintIndex = startEdge.tintIndex();
            boolean shade = startEdge.shade();
            int current = startEdge.end();
            boolean closed = false;
            int maxSteps = edges.size() + 1;
            for (int steps = 0; steps < maxSteps; ++steps) {
                if (current == (Integer)loop.get(0)) {
                    closed = true;
                    break;
                }
                LoopEdge nextEdge = this.findAndUseEdge(edges, current);
                if (nextEdge == null) {
                    int loopPre = (Integer)loop.get(loop.size() - 2);
                    int loopPost = (Integer)loop.get(loop.size() - 1);
                    Vector3f dir = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(loopPost)).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPre)).position()).normalize();
                    for (LoopEdge edge : edges) {
                        Vector3f toEndR;
                        Vector3f toStartR;
                        Vector3f toEnd;
                        Vector3f edgeDir;
                        if (edge.used() || edge.start() == current || edge.end() == current || !(Math.abs(dir.dot((Vector3fc)(edgeDir = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).normalize()))) > 0.999f)) continue;
                        Vector3f toStart = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPost)).position()).normalize();
                        if (toStart.dot((Vector3fc)(toEnd = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPre)).position()).normalize())) < 0.01f) {
                            edge.markUsed();
                            loop.add(edge.end());
                            loop.add(edge.start());
                            loop.add(edge.end());
                            closed = true;
                        }
                        if (!((toStartR = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get((Integer)loop.get(0))).position()).normalize()).dot((Vector3fc)(toEndR = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get((Integer)loop.get(1))).position()).normalize())) < 0.01f)) continue;
                        edge.markUsed();
                        loop.add(edge.end());
                        loop.add(edge.start());
                        loop.add(edge.end());
                        closed = true;
                    }
                    break;
                }
                int nextVertex = nextEdge.other(current);
                loop.add(nextVertex);
                current = nextVertex;
            }
            if (!closed || loop.size() <= 2) continue;
            loop.remove(loop.size() - 1);
            this.applyCapUVToVertices(loop, uniqueVertices, normal, capSprite);
            this.emitLoopToConsumer(loop, uniqueVertices, normal, bufferConsumer, lightFunction);
            ++loopCount;
        }
        this.segments.clear();
    }

    private void emitLoopToConsumer(List<Integer> loopIndices, List<CapVertex> vertices, Vector3f normal, List<Consumer<BufferBuilder>> bufferConsumer, Function<Vector3f, Integer> lightFunction) {
        Vector3f faceNormal;
        List<GirderVertex> loopVertices;
        List<GirderVertex> cleaned;
        Vector3f normalizedPlane = new Vector3f((Vector3fc)normal);
        if (normalizedPlane.lengthSquared() > 1.0E-4f) {
            normalizedPlane.normalize();
        }
        if ((cleaned = GirderGeometry.dedupeLoopVertices(loopVertices = GirderCapAccumulator.getGirderVertices(loopIndices, vertices, faceNormal = new Vector3f((Vector3fc)normalizedPlane).negate()))).size() < 3) {
            return;
        }
        Vector3f polygonNormal = GirderGeometry.computePolygonNormal(cleaned);
        if (polygonNormal.lengthSquared() > 1.0E-4f && polygonNormal.dot((Vector3fc)faceNormal) < 0.0f) {
            Collections.reverse(cleaned);
        }
        GirderGeometry.emitPolygonToConsumer(cleaned, bufferConsumer, lightFunction);
    }

    public void emitCaps(Vector3f planePoint, Vector3f planeNormal, List<BakedQuad> consumer) {
        LoopEdge startEdge;
        if (this.segments.isEmpty()) {
            return;
        }
        Vector3f normal = new Vector3f((Vector3fc)planeNormal);
        if (normal.lengthSquared() <= 1.0E-4f) {
            return;
        }
        normal.normalize();
        TextureAtlasSprite stoneSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.capTexture);
        ArrayList<CapVertex> uniqueVertices = new ArrayList<CapVertex>();
        ArrayList<LoopEdge> edges = new ArrayList<LoopEdge>();
        for (CapSegment segment : this.segments) {
            int endIndex;
            int startIndex = this.indexFor(uniqueVertices, segment.start());
            if (startIndex == (endIndex = this.indexFor(uniqueVertices, segment.end()))) continue;
            edges.add(new LoopEdge(startIndex, endIndex, segment.tintIndex(), segment.shade()));
        }
        int loopCount = 0;
        while ((startEdge = this.findUnusedEdge(edges)) != null) {
            ArrayList<Integer> loop = new ArrayList<Integer>();
            loop.add(startEdge.start());
            loop.add(startEdge.end());
            startEdge.markUsed();
            int tintIndex = startEdge.tintIndex();
            boolean shade = startEdge.shade();
            int current = startEdge.end();
            boolean closed = false;
            int maxSteps = edges.size() + 1;
            for (int steps = 0; steps < maxSteps; ++steps) {
                if (current == (Integer)loop.get(0)) {
                    closed = true;
                    break;
                }
                LoopEdge nextEdge = this.findAndUseEdge(edges, current);
                if (nextEdge == null) {
                    int loopPre = (Integer)loop.get(loop.size() - 2);
                    int loopPost = (Integer)loop.get(loop.size() - 1);
                    Vector3f dir = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(loopPost)).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPre)).position()).normalize();
                    for (LoopEdge edge : edges) {
                        Vector3f toEndR;
                        Vector3f toStartR;
                        Vector3f toEnd;
                        Vector3f edgeDir;
                        if (edge.used() || edge.start() == current || edge.end() == current || !(Math.abs(dir.dot((Vector3fc)(edgeDir = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).normalize()))) > 0.999f)) continue;
                        Vector3f toStart = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPost)).position()).normalize();
                        if (toStart.dot((Vector3fc)(toEnd = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get(loopPre)).position()).normalize())) < 0.01f) {
                            edge.markUsed();
                            loop.add(edge.end());
                            loop.add(edge.start());
                            loop.add(edge.end());
                            closed = true;
                        }
                        if (!((toStartR = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.start())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get((Integer)loop.get(0))).position()).normalize()).dot((Vector3fc)(toEndR = new Vector3f((Vector3fc)((CapVertex)uniqueVertices.get(edge.end())).position()).sub((Vector3fc)((CapVertex)uniqueVertices.get((Integer)loop.get(1))).position()).normalize())) < 0.01f)) continue;
                        edge.markUsed();
                        loop.add(edge.end());
                        loop.add(edge.start());
                        loop.add(edge.end());
                        closed = true;
                    }
                    break;
                }
                int nextVertex = nextEdge.other(current);
                loop.add(nextVertex);
                current = nextVertex;
            }
            if (!closed || loop.size() <= 2) continue;
            loop.remove(loop.size() - 1);
            this.applyCapUVToVertices(loop, uniqueVertices, normal, stoneSprite);
            this.emitLoop(loop, uniqueVertices, tintIndex, shade, normal, stoneSprite, consumer);
            ++loopCount;
        }
        this.segments.clear();
    }

    private void applyCapUVToVertices(List<Integer> loop, List<CapVertex> uniqueVertices, Vector3f normal, TextureAtlasSprite sprite) {
        Vector3f uvUp = new Vector3f(0.0f, 1.0f, 0.0f).cross((Vector3fc)normal);
        if (uvUp.lengthSquared() <= 1.0E-4f) {
            uvUp.set(1.0f, 0.0f, 0.0f);
        }
        uvUp.normalize();
        Vector3f uvRight = new Vector3f((Vector3fc)normal).cross((Vector3fc)uvUp).normalize();
        Vector3f uvOrigin = new Vector3f();
        for (int index : loop) {
            uvOrigin.add((Vector3fc)uniqueVertices.get(index).position());
        }
        uvOrigin.mul(1.0f / (float)loop.size());
        float uScale = sprite.m_118410_() - sprite.m_118409_();
        float vScale = sprite.m_118412_() - sprite.m_118411_();
        float uOffset = sprite.m_118409_() + uScale / 2.0f;
        float vOffset = sprite.m_118411_() + vScale / 2.0f;
        for (int index : loop) {
            CapVertex vertex = uniqueVertices.get(index);
            Vector3f toVertex = new Vector3f((Vector3fc)vertex.position()).sub((Vector3fc)uvOrigin);
            float u = Math.min(Math.max(toVertex.dot((Vector3fc)uvRight), -0.5f), 0.5f);
            float v = Math.min(Math.max(toVertex.dot((Vector3fc)uvUp), -0.5f), 0.5f);
            uniqueVertices.set(index, new CapVertex(vertex.position(), uScale * u + uOffset, vScale * v + vOffset, vertex.color(), vertex.light(), vertex.sourceSprite()));
        }
    }

    private int indexFor(List<CapVertex> vertices, CapVertex vertex) {
        for (int i = 0; i < vertices.size(); ++i) {
            if (!GirderCapAccumulator.positionsClose(vertices.get(i).position(), vertex.position())) continue;
            return i;
        }
        vertices.add(vertex.copy());
        return vertices.size() - 1;
    }

    private static boolean positionsClose(Vector3f a, Vector3f b) {
        float dx = a.x - b.x;
        float dy = a.y - b.y;
        float dz = a.z - b.z;
        float tol = 0.01f;
        return dx * dx + dy * dy + dz * dz <= tol * tol;
    }

    private LoopEdge findUnusedEdge(List<LoopEdge> edges) {
        for (LoopEdge edge : edges) {
            if (edge.used()) continue;
            return edge;
        }
        return null;
    }

    private LoopEdge findAndUseEdge(List<LoopEdge> edges, int vertexIndex) {
        for (LoopEdge edge : edges) {
            if (edge.used() || edge.start() != vertexIndex && edge.end() != vertexIndex) continue;
            edge.markUsed();
            return edge;
        }
        return null;
    }

    private void emitLoop(List<Integer> loopIndices, List<CapVertex> vertices, int tintIndex, boolean shade, Vector3f normal, TextureAtlasSprite stoneSprite, List<BakedQuad> consumer) {
        Vector3f faceNormal;
        List<GirderVertex> loopVertices;
        List<GirderVertex> cleaned;
        Vector3f normalizedPlane = new Vector3f((Vector3fc)normal);
        if (normalizedPlane.lengthSquared() > 1.0E-4f) {
            normalizedPlane.normalize();
        }
        if ((cleaned = GirderGeometry.dedupeLoopVertices(loopVertices = GirderCapAccumulator.getGirderVertices(loopIndices, vertices, faceNormal = new Vector3f((Vector3fc)normalizedPlane).negate()))).size() < 3) {
            return;
        }
        Vector3f polygonNormal = GirderGeometry.computePolygonNormal(cleaned);
        if (polygonNormal.lengthSquared() > 1.0E-4f && polygonNormal.dot((Vector3fc)faceNormal) < 0.0f) {
            Collections.reverse(cleaned);
        }
        Direction face = Direction.m_122372_((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
        GirderGeometry.emitPolygon(cleaned, stoneSprite, face, tintIndex, shade, consumer);
    }

    @NotNull
    private static List<GirderVertex> getGirderVertices(List<Integer> loopIndices, List<CapVertex> vertices, Vector3f faceNormal) {
        ArrayList<GirderVertex> loopVertices = new ArrayList<GirderVertex>(loopIndices.size());
        for (int index : loopIndices) {
            CapVertex data = vertices.get(index);
            Vector3f point = new Vector3f((Vector3fc)data.position());
            loopVertices.add(new GirderVertex(point, new Vector3f((Vector3fc)faceNormal), data.u, data.v, data.color(), data.light()));
        }
        return loopVertices;
    }

    private static final class CapVertex {
        private final Vector3f position;
        private final float u;
        private final float v;
        private final int color;
        private final int light;
        private final TextureAtlasSprite sourceSprite;

        CapVertex(GirderVertex vertex, TextureAtlasSprite sprite) {
            this(new Vector3f((Vector3fc)vertex.position()), vertex.u(), vertex.v(), vertex.color(), vertex.light(), sprite);
        }

        private CapVertex(Vector3f position, float u, float v, int color, int light, TextureAtlasSprite sourceSprite) {
            this.position = position;
            this.u = u;
            this.v = v;
            this.color = color;
            this.light = light;
            this.sourceSprite = sourceSprite;
        }

        Vector3f position() {
            return this.position;
        }

        float u() {
            return this.u;
        }

        float v() {
            return this.v;
        }

        int color() {
            return this.color;
        }

        int light() {
            return this.light;
        }

        TextureAtlasSprite sourceSprite() {
            return this.sourceSprite;
        }

        CapVertex copy() {
            return new CapVertex(new Vector3f((Vector3fc)this.position), this.u, this.v, this.color, this.light, this.sourceSprite);
        }
    }

    private record CapSegment(CapVertex start, CapVertex end, int tintIndex, boolean shade) {
    }

    private static final class LoopEdge {
        private final int start;
        private final int end;
        private final int tintIndex;
        private final boolean shade;
        private boolean used;

        LoopEdge(int start, int end, int tintIndex, boolean shade) {
            this.start = start;
            this.end = end;
            this.tintIndex = tintIndex;
            this.shade = shade;
        }

        int start() {
            return this.start;
        }

        int end() {
            return this.end;
        }

        int tintIndex() {
            return this.tintIndex;
        }

        boolean shade() {
            return this.shade;
        }

        boolean used() {
            return this.used;
        }

        void markUsed() {
            this.used = true;
        }

        int other(int vertex) {
            return vertex == this.start ? this.end : this.start;
        }
    }
}

