/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.light.headlamp;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.light.headlamp.HeadlampBlock;
import com.kipti.bnb.content.light.headlamp.HeadlampBlockEntity;
import com.kipti.bnb.registry.BnbPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class HeadlampModelBuilder
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<HeadlampModelData> HEADLAMP_PROPERTY = new ModelProperty();

    public HeadlampModelBuilder(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        HeadlampModelData data = new HeadlampModelData();
        int[] activePlacements = new int[9];
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            int[] existingPlacements = headlampBlockEntity.getActivePlacements();
            System.arraycopy(existingPlacements, 0, activePlacements, 0, existingPlacements.length);
        }
        data.setActivePlacements(activePlacements);
        return ModelData.builder().with(HEADLAMP_PROPERTY, (Object)data).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        if (data.has(HEADLAMP_PROPERTY)) {
            ArrayList<BakedQuad> model = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, data, renderType));
            HeadlampModelData headlampModelData = (HeadlampModelData)data.get(HEADLAMP_PROPERTY);
            for (int i = 0; i < HeadlampBlockEntity.HeadlampPlacement.values().length; ++i) {
                HeadlampBlockEntity.HeadlampPlacement placement = HeadlampBlockEntity.HeadlampPlacement.values()[i];
                int placementValue = headlampModelData.getActivePlacements()[i];
                if (placementValue == 0) continue;
                PoseStack poseStack = new PoseStack();
                poseStack.m_252880_(0.5f, 0.5f, 0.5f);
                poseStack.m_252781_(((Direction)state.m_61143_((Property)HeadlampBlock.f_52588_)).m_253075_());
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                poseStack.m_85837_(placement.horizontalAlignment().getOffset(), 0.0, placement.verticalAlignment().getOffset());
                model.addAll(this.transformQuadsForLamp(((Integer)state.m_61143_((Property)HeadlampBlock.POWER) > 6 ? BnbPartialModels.HEADLAMP_ON : BnbPartialModels.HEADLAMP_OFF).get().getQuads(state, side, rand, data, renderType), poseStack, placementValue));
            }
            return model;
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> transformQuadsForLamp(List<BakedQuad> quads, PoseStack poseStack, int placementValue) {
        DyeColor color = placementValue == 1 ? null : DyeColor.values()[Math.min(Math.max(placementValue - 2, 0), DyeColor.values().length - 1)];
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            int[] vertices = quad.m_111303_();
            int[] transformedVertices = Arrays.copyOf(vertices, vertices.length);
            TextureAtlasSprite oldSprite = quad.m_173410_();
            boolean oldSpriteIsBlockTexture = oldSprite.m_245424_().m_246162_().equals((Object)CreateBitsnBobs.asResource("block/headlight/headlight"));
            boolean oldSpriteIsOffLampTexture = oldSprite.m_245424_().m_246162_().equals((Object)CreateBitsnBobs.asResource("block/headlight/headlight_off"));
            TextureAtlasSprite newSprite = oldSpriteIsBlockTexture || color == null ? oldSprite : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(CreateBitsnBobs.asResource("block/headlight/headlight_" + (oldSpriteIsOffLampTexture ? "off" : "on") + "_" + color.m_41065_()));
            Vec3 quadNormal = Vec3.m_82528_((Vec3i)quad.m_111306_().m_122436_());
            Vector3f quadNormalJoml = pose.transformDirection((float)quadNormal.f_82479_, (float)quadNormal.f_82480_, (float)quadNormal.f_82481_, new Vector3f());
            for (int i = 0; i < vertices.length / BakedQuadHelper.VERTEX_STRIDE; ++i) {
                Vec3 vertex = BakedQuadHelper.getXYZ((int[])vertices, (int)i);
                Vec3 normal = BakedQuadHelper.getNormalXYZ((int[])vertices, (int)i);
                float uvX = BakedQuadHelper.getU((int[])vertices, (int)i);
                float uvY = BakedQuadHelper.getV((int[])vertices, (int)i);
                if (!oldSprite.equals(newSprite)) {
                    uvX = (uvX - oldSprite.m_118409_()) / (oldSprite.m_118410_() - oldSprite.m_118409_()) * (newSprite.m_118410_() - newSprite.m_118409_()) + newSprite.m_118409_();
                    uvY = (uvY - oldSprite.m_118411_()) / (oldSprite.m_118412_() - oldSprite.m_118411_()) * (newSprite.m_118412_() - newSprite.m_118411_()) + newSprite.m_118411_();
                }
                Vector3f vertexJoml = pose.transformPosition((float)vertex.f_82479_, (float)vertex.f_82480_, (float)vertex.f_82481_, new Vector3f());
                Vector3f normalJoml = pose.transformDirection((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_, new Vector3f());
                BakedQuadHelper.setXYZ((int[])transformedVertices, (int)i, (Vec3)new Vec3((double)vertexJoml.x, (double)vertexJoml.y, (double)vertexJoml.z));
                BakedQuadHelper.setNormalXYZ((int[])transformedVertices, (int)i, (Vec3)new Vec3((double)normalJoml.x, (double)normalJoml.y, (double)normalJoml.z));
                BakedQuadHelper.setU((int[])transformedVertices, (int)i, (float)uvX);
                BakedQuadHelper.setV((int[])transformedVertices, (int)i, (float)uvY);
            }
            Direction newNormal = Direction.m_122378_((int)Math.round(quadNormalJoml.x), (int)Math.round(quadNormalJoml.y), (int)Math.round(quadNormalJoml.z));
            transformedQuads.add(new BakedQuad(transformedVertices, quad.m_111305_(), newNormal, newSprite, false));
        }
        return transformedQuads;
    }

    private static class HeadlampModelData {
        int[] activePlacements;

        private HeadlampModelData() {
        }

        public void setActivePlacements(int[] activePlacements) {
            if (activePlacements.length != 9) {
                throw new IllegalArgumentException("Active placements array must have length " + this.activePlacements.length);
            }
            this.activePlacements = activePlacements;
        }

        public int[] getActivePlacements() {
            return this.activePlacements;
        }
    }
}

