/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.network.packets.from_client;

import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainPathfinder;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlaceCogwheelChainPacket
extends SimplePacketBase {
    PlacingCogwheelChain worldSpacePartialChain;
    int priorityChainTakeHand;

    public PlaceCogwheelChainPacket(PlacingCogwheelChain worldSpacePartialChain, int priorityChainTakeHand) {
        this.worldSpacePartialChain = worldSpacePartialChain;
        this.priorityChainTakeHand = priorityChainTakeHand;
    }

    public PlaceCogwheelChainPacket(FriendlyByteBuf buffer) {
        this.worldSpacePartialChain = PlacingCogwheelChain.readFromBuffer(buffer);
        this.priorityChainTakeHand = buffer.readInt();
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            MinecraftServer server = player.m_20194_();
            this.handle(server, player);
        });
        return true;
    }

    public void handle(@Nullable MinecraftServer server, @Nullable ServerPlayer player) {
        List<PathedCogwheelNode> chainGeometry;
        boolean hasEnough;
        if (this.worldSpacePartialChain.maxBounds() > PlacingCogwheelChain.MAX_CHAIN_BOUNDS) {
            return;
        }
        if (!this.worldSpacePartialChain.checkMatchingNodesInLevel(player.m_9236_())) {
            return;
        }
        int chainsRequired = this.worldSpacePartialChain.getChainsRequiredInLoop();
        boolean bl = hasEnough = player.m_7500_() || ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.f_42026_.m_7968_(), (int)chainsRequired, (boolean)true);
        if (!hasEnough) {
            return;
        }
        if (!player.m_7500_()) {
            ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.f_42026_.m_7968_(), (int)chainsRequired, (boolean)false);
        }
        try {
            chainGeometry = CogwheelChainPathfinder.buildChainPath(this.worldSpacePartialChain);
        }
        catch (ChainInteractionFailedException ignored) {
            return;
        }
        if (chainGeometry == null) {
            return;
        }
        CogwheelChain chain = new CogwheelChain(chainGeometry);
        chain.placeInLevel(player.m_9236_(), this.worldSpacePartialChain);
    }

    public void write(FriendlyByteBuf buffer) {
        PlacingCogwheelChain.writeToBuffer(this.worldSpacePartialChain, buffer);
        buffer.writeInt(this.priorityChainTakeHand);
    }
}

