/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy.client;

import codyhuh.breezy.client.render.HotAirBalloonRenderer;
import codyhuh.breezy.common.network.BreezyNetworking;
import codyhuh.breezy.common.network.NewWindSavedData;
import codyhuh.breezy.core.other.util.WindMathUtil;
import codyhuh.breezy.core.registry.BreezyEntities;
import codyhuh.breezy.core.registry.BreezyItems;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="breezy", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BreezyEntities.HOT_AIR_BALLOON.get(), HotAirBalloonRenderer::new);
    }

    @SubscribeEvent
    public static void registerClient(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)BreezyItems.GUST_GAUGE.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private final GustGaugeWobble gaugeWobble = new GustGaugeWobble();
            private final GustGaugeWobble randomWobble = new GustGaugeWobble();

            public float m_142187_(@NotNull ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int seed) {
                long gameTime;
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientLevel == null && entity.m_9236_() instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.m_9236_();
                }
                NewWindSavedData windData = BreezyNetworking.CLIENT_CACHE;
                long l = gameTime = clientLevel != null ? clientLevel.m_46467_() : 0L;
                if (windData != null) {
                    double finalAngle;
                    Player player;
                    double windDirection = windData.getWindAtHeight(entity.m_20183_().m_123342_(), entity.m_9236_());
                    boolean isLocal = livingEntity instanceof Player && (player = (Player)livingEntity).m_7578_();
                    double entityRot = 0.0;
                    if (isLocal) {
                        entityRot = livingEntity.m_146908_();
                    } else if (entity instanceof ItemFrame) {
                        entityRot = this.getFrameRotation((ItemFrame)entity);
                    } else if (entity instanceof ItemEntity) {
                        entityRot = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (livingEntity != null) {
                        entityRot = livingEntity.f_20883_;
                    }
                    entityRot = Mth.m_14109_((double)(entityRot / 360.0), (double)1.0);
                    double windAngle = this.getAngleTo(new Vec3(WindMathUtil.stepX(windDirection), 0.0, WindMathUtil.stepZ(windDirection)).m_82490_(Double.MAX_VALUE), (Entity)entity) / 6.2831854820251465;
                    if (isLocal) {
                        if (this.gaugeWobble.shouldUpdate(gameTime)) {
                            this.gaugeWobble.update(gameTime, 0.5 - (entityRot - 0.25));
                        }
                        finalAngle = windAngle + this.gaugeWobble.rotation;
                    } else {
                        finalAngle = 0.5 - (entityRot - 0.25 - windAngle);
                    }
                    return Mth.m_14091_((float)((float)finalAngle), (float)1.0f);
                }
                if (this.randomWobble.shouldUpdate(gameTime)) {
                    this.randomWobble.update(gameTime, Math.random());
                }
                double randomAngle = this.randomWobble.rotation + (double)((float)this.hash(seed) / 2.1474836E9f);
                return Mth.m_14091_((float)((float)randomAngle), (float)1.0f);
            }

            private int hash(int seed) {
                return seed * 1327217883;
            }

            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.m_6350_();
                int rotationOffset = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrame.m_31823_() * 45 + rotationOffset));
            }

            private double getAngleTo(Vec3 targetPosition, Entity entity) {
                return Math.atan2(targetPosition.m_7094_() - entity.m_20189_(), targetPosition.m_7096_() - entity.m_20185_());
            }
        });
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((stack, color) -> color > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)BreezyItems.HOT_AIR_BALLOON.get()});
    }

    private static class GustGaugeWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private GustGaugeWobble() {
        }

        boolean shouldUpdate(long currentTick) {
            return this.lastUpdateTick != currentTick;
        }

        void update(long currentTick, double targetRotation) {
            this.lastUpdateTick = currentTick;
            double rotationDifference = targetRotation - this.rotation;
            rotationDifference = Mth.m_14109_((double)(rotationDifference + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += rotationDifference * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

