/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class SycamoreTrunkPlacer
extends TrunkPlacer {
    public static final Codec<SycamoreTrunkPlacer> CODEC = RecordCodecBuilder.create(crabappleTrunkPlacerInstance -> SycamoreTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)crabappleTrunkPlacerInstance).apply((Applicative)crabappleTrunkPlacerInstance, SycamoreTrunkPlacer::new));

    public SycamoreTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.SYCAMORE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        SycamoreTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageSpots = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = pFreeTreeHeight + pRandom.m_216339_(this.f_70264_, this.f_70265_);
        ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));
        if ((double)pRandom.m_188501_() > 0.5) {
            pPos = pPos.m_121945_(Direction.SOUTH);
        }
        if ((double)pRandom.m_188501_() > 0.5) {
            pPos = pPos.m_121945_(Direction.WEST);
        }
        for (int i = 0; i < maxHeight; ++i) {
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_6630_(i), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_121945_(Direction.NORTH).m_6630_(i), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_121945_(Direction.EAST).m_6630_(i), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST).m_6630_(i), pConfig);
        }
        foliageSpots.add(new FoliagePlacer.FoliageAttachment(pPos.m_6630_(maxHeight).m_122012_(), 0, true));
        int branches = pRandom.m_216339_(1, 4);
        for (int j = 0; j < branches; ++j) {
            Direction branchDirection = (Direction)directions.get(pRandom.m_216339_(0, directions.size()));
            directions.remove(branchDirection);
            if (branchDirection.equals((Object)Direction.NORTH)) {
                pPos = pPos.m_122012_();
            } else if (branchDirection.equals((Object)Direction.EAST)) {
                pPos = pPos.m_122029_();
            }
            if (branchDirection.equals((Object)Direction.NORTH) || branchDirection.equals((Object)Direction.SOUTH)) {
                if (pRandom.m_188499_()) {
                    pPos = pPos.m_122029_();
                }
            } else if (pRandom.m_188499_()) {
                pPos = pPos.m_122012_();
            }
            int branchHeight = pRandom.m_216339_(3, maxHeight - 2);
            int branchLength = pRandom.m_216339_(2, 5);
            BlockState log = (BlockState)pConfig.f_68185_.m_213972_(pRandom, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)branchDirection.m_122434_());
            BlockPos nextPos = pPos;
            int b = 0;
            while (b < branchLength) {
                nextPos = pPos.m_6630_(branchHeight).m_5484_(branchDirection, b + 1);
                if ((double)pRandom.m_188501_() < 0.2) {
                    pBlockSetter.accept(nextPos, (BlockState)Function.identity().apply(log));
                    ++branchHeight;
                }
                pBlockSetter.accept(nextPos, (BlockState)Function.identity().apply(log));
                if (b == 0) {
                    pBlockSetter.accept(nextPos.m_5484_(branchDirection, -1), (BlockState)Function.identity().apply(log));
                }
                if (++b != branchLength) continue;
                foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
            }
        }
        return foliageSpots;
    }
}

