/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class WillowTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.create(willowTrunkPlacerInstance -> WillowTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)willowTrunkPlacerInstance).apply((Applicative)willowTrunkPlacerInstance, WillowTrunkPlacer::new));

    public WillowTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.WILLOW_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int freeTreeHeight, BlockPos pPos, TreeConfiguration treeConfiguration) {
        WillowTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, biConsumer, (RandomSource)randomSource, (BlockPos)pPos.m_7495_(), (TreeConfiguration)treeConfiguration);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageSpots = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = this.f_70263_ + randomSource.m_216339_(this.f_70264_, this.f_70265_ + 1);
        int xOffset = 0;
        int zOffset = 0;
        List<Integer> sideHeights = List.of(Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)), Integer.valueOf(randomSource.m_216339_(0, 4)));
        BlockPos nextPos = pPos;
        this.m_226187_(pLevel, biConsumer, randomSource, pPos, treeConfiguration);
        for (int i = 0; i < maxHeight; ++i) {
            if (randomSource.m_188501_() > 0.85f) {
                zOffset += randomSource.m_216339_(-1, 1);
            }
            if (randomSource.m_188501_() > 0.85f) {
                xOffset += randomSource.m_216339_(-1, 1);
            }
            nextPos = new BlockPos(pPos.m_123341_() + xOffset, pPos.m_123342_() + i, pPos.m_123343_() + zOffset);
            this.m_226187_(pLevel, biConsumer, randomSource, nextPos, treeConfiguration);
            this.m_226187_(pLevel, biConsumer, randomSource, nextPos.m_7495_(), treeConfiguration);
            if (i - 2 <= sideHeights.get(0) || i >= maxHeight - sideHeights.get(4)) {
                this.m_226187_(pLevel, biConsumer, randomSource, nextPos.m_122012_(), treeConfiguration);
            }
            if (i - 2 <= sideHeights.get(1) || i >= maxHeight - sideHeights.get(5)) {
                this.m_226187_(pLevel, biConsumer, randomSource, nextPos.m_122029_(), treeConfiguration);
            }
            if (i - 2 <= sideHeights.get(2) || i >= maxHeight - sideHeights.get(6)) {
                this.m_226187_(pLevel, biConsumer, randomSource, nextPos.m_122019_(), treeConfiguration);
            }
            if (i - 2 > sideHeights.get(3) && i < maxHeight - sideHeights.get(7)) continue;
            this.m_226187_(pLevel, biConsumer, randomSource, nextPos.m_122024_(), treeConfiguration);
        }
        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
        int branchNumber = randomSource.m_216339_(3, 8);
        BlockPos pastPos = nextPos;
        for (int j = 1; j <= branchNumber; ++j) {
            nextPos = pastPos;
            int branchMaxBlocks = (int)((float)maxHeight * ((float)randomSource.m_216339_(60, 90) / 100.0f)) + randomSource.m_216339_(-2, 5);
            int branchAngle = (int)(360.0f / (float)branchNumber) * j + randomSource.m_216339_(-15, 16);
            if (branchAngle < 0) {
                branchAngle += 360;
            } else if (branchAngle >= 360) {
                branchAngle -= 360;
            }
            BlockState logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            if (branchAngle > 45 && branchAngle <= 135 || branchAngle < 315 && branchAngle >= 225) {
                logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            }
            BlockState pastLogDirection = logDirection;
            boolean wentDown = false;
            if (branchAngle < 90) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.m_188501_() > (float)branchAngle / 90.0f ? nextPos.m_122029_() : nextPos.m_122012_();
                    if (randomSource.m_188501_() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.m_216339_(0, 2)))) {
                        nextPos = nextPos.m_7495_();
                        logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.m_7494_(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else if (branchAngle < 180) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.m_188501_() > (float)(branchAngle - 90) / 90.0f ? nextPos.m_122019_() : nextPos.m_122029_();
                    if (randomSource.m_188501_() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.m_216339_(0, 2)))) {
                        nextPos = nextPos.m_7495_();
                        logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.m_7494_(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else if (branchAngle < 270) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.m_188501_() > (float)(branchAngle - 180) / 90.0f ? nextPos.m_122024_() : nextPos.m_122019_();
                    if (randomSource.m_188501_() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.m_216339_(0, 2)))) {
                        nextPos = nextPos.m_7495_();
                        logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.m_7494_(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.m_188501_() > (float)(branchAngle - 270) / 90.0f ? nextPos.m_122012_() : nextPos.m_122024_();
                    if (randomSource.m_188501_() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.m_216339_(0, 2)))) {
                        nextPos = nextPos.m_7495_();
                        logDirection = (BlockState)treeConfiguration.f_68185_.m_213972_(randomSource, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.m_7494_(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            }
            foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
        }
        return foliageSpots;
    }
}

