/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.crab;

import alabaster.crabbersdelight.common.entity.crab.CrabVariant;
import alabaster.crabbersdelight.common.registry.CDModEntities;
import alabaster.crabbersdelight.common.registry.CDModItems;
import alabaster.crabbersdelight.common.tags.CDModTags;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends Animal
implements Bucketable {
    private static EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Ingredient temptationItems;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CrabEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.75, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public int m_6062_() {
        return 100;
    }

    protected void handleAirSupply(int airSupply) {
        this.m_20301_(this.m_6062_());
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(i);
        }
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag dataTag) {
        Holder holder = level.m_204166_(this.m_20183_());
        if (holder.m_203565_(Biomes.f_220595_)) {
            this.setVariant(CrabVariant.BLUE);
        } else if (holder.m_203565_(Biomes.f_48217_)) {
            this.setVariant(CrabVariant.RED);
        } else if (holder.m_203565_(Biomes.f_48207_)) {
            this.setVariant(CrabVariant.GREEN);
        } else if (holder.m_203565_(Biomes.f_186760_)) {
            this.setVariant(CrabVariant.LIGHT_GRAY);
        } else if (holder.m_203565_(Biomes.f_48148_)) {
            this.setVariant(CrabVariant.WHITE);
        } else {
            this.setVariant(CrabVariant.BLUE);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, dataTag);
    }

    public static boolean checkCrabSpawnRules(EntityType<CrabEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        return stateBelow.m_204336_(CDModTags.CRAB_SPAWN_ON);
    }

    public static boolean canCrabSpawn(EntityType<CrabEntity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(CDModTags.CRAB_SPAWN_ON);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public CrabVariant getVariant() {
        return CrabVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(CrabVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)compound.m_128471_("FromBucket"));
    }

    @Nullable
    public CrabEntity getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        CrabEntity baby = (CrabEntity)((EntityType)CDModEntities.CRAB.get()).m_20615_((Level)level);
        if (!(otherParent instanceof CrabEntity)) {
            return baby;
        }
        CrabEntity otherCrab = (CrabEntity)otherParent;
        DyeColor color1 = this.getVariant().getDyeColor();
        DyeColor color2 = otherCrab.getVariant().getDyeColor();
        DyeColor mixedColor = CrabEntity.getMixedDyeColor(level, color1, color2);
        baby.setVariant(CrabVariant.fromDyeColor(mixedColor != null ? mixedColor : color1));
        return baby;
    }

    @Nullable
    private static DyeColor getMixedDyeColor(ServerLevel level, DyeColor color1, DyeColor color2) {
        if (color1 == color2) {
            return color1;
        }
        RecipeManager recipeManager = level.m_7465_();
        for (Recipe recipe : recipeManager.m_44013_(RecipeType.f_44107_)) {
            List<DyeColor> inputColors;
            ShapelessRecipe shapeless;
            Item item;
            if (!(recipe instanceof ShapelessRecipe) || !((item = (shapeless = (ShapelessRecipe)recipe).m_8043_(level.m_9598_()).m_41720_()) instanceof DyeItem)) continue;
            DyeItem resultDye = (DyeItem)item;
            if (shapeless.m_7527_().size() != 2 || (inputColors = shapeless.m_7527_().stream().map(ingredient -> {
                Item patt8166$temp;
                ItemStack[] stacks = ingredient.m_43908_();
                if (stacks.length > 0 && (patt8166$temp = stacks[0].m_41720_()) instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)patt8166$temp;
                    return dyeItem.m_41089_();
                }
                return null;
            }).filter(c -> c != null).toList()).size() != 2 || (inputColors.get(0) != color1 || inputColors.get(1) != color2) && (inputColors.get(0) != color2 || inputColors.get(1) != color1)) continue;
            return resultDye.m_41089_();
        }
        return null;
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.m_204132_(CDModTags.CRAB_TEMPT_ITEM);
        }
        return this.temptationItems;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)true);
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    public void m_6872_(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        tag.m_128405_("Age", this.m_146764_());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_142278_(@Nonnull CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(CrabVariant.byId(tag.m_128451_("Variant")));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)CDModItems.CRAB_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        DyeItem dyeItem;
        DyeColor dyeColor;
        CrabVariant newVariant;
        Optional result = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this);
        if (result.isPresent()) {
            return (InteractionResult)result.get();
        }
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof DyeItem && (newVariant = CrabVariant.fromDyeColor(dyeColor = (dyeItem = (DyeItem)item).m_41089_())) != this.getVariant()) {
            this.setVariant(newVariant);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }
}

