/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.simibubi.create.Create;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CopperRegistries {
    private static final BiMap<java.util.function.Supplier<Block>, java.util.function.Supplier<Block>> WEATHERING = HashBiMap.create();
    private static final BiMap<java.util.function.Supplier<Block>, java.util.function.Supplier<Block>> WAXABLE = HashBiMap.create();
    private static boolean injected;
    private static boolean weatheringMemoized;
    private static boolean waxableMemoized;

    public static synchronized void addWeathering(java.util.function.Supplier<Block> original, java.util.function.Supplier<Block> weathered) {
        if (weatheringMemoized) {
            throw new IllegalStateException("Cannot add weathering entry to CopperRegistries after memoization!");
        }
        WEATHERING.put(original, weathered);
    }

    public static synchronized void addWaxable(java.util.function.Supplier<Block> original, java.util.function.Supplier<Block> waxed) {
        if (waxableMemoized) {
            throw new IllegalStateException("Cannot add waxable entry to CopperRegistries after memoization!");
        }
        WAXABLE.put(original, waxed);
    }

    public static void inject() {
        if (injected) {
            throw new IllegalStateException("Cannot inject CopperRegistries twice!");
        }
        injected = true;
        try {
            Field delegateField = WeatheringCopper.f_154886_.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            java.util.function.Supplier originalWeatheringMapDelegate = (java.util.function.Supplier)delegateField.get(WeatheringCopper.f_154886_);
            Supplier weatheringMapDelegate = () -> CopperRegistries.lambda$inject$1((java.util.function.Supplier)originalWeatheringMapDelegate);
            delegateField.set(WeatheringCopper.f_154886_, weatheringMapDelegate);
        }
        catch (Exception e) {
            Create.LOGGER.error("Failed to inject weathering copper from CopperRegistries", (Throwable)e);
        }
        java.util.function.Supplier originalWaxableMapSupplier = HoneycombItem.f_150863_;
        Supplier waxableMapSupplier = Suppliers.memoize(() -> CopperRegistries.lambda$inject$3((java.util.function.Supplier)originalWaxableMapSupplier));
        HoneycombItem.f_150863_ = waxableMapSupplier;
    }

    private static /* synthetic */ BiMap lambda$inject$3(java.util.function.Supplier originalWaxableMapSupplier) {
        waxableMemoized = true;
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWaxableMapSupplier.get());
        ErrorHandlingBiConsumer<java.util.function.Supplier, java.util.function.Supplier> consumer = new ErrorHandlingBiConsumer<java.util.function.Supplier, java.util.function.Supplier>((original, waxed) -> builder.put((Object)((Block)original.get()), (Object)((Block)waxed.get())));
        WAXABLE.forEach(consumer);
        consumer.reportExceptions(Create.LOGGER, "waxable");
        return builder.build();
    }

    private static /* synthetic */ BiMap lambda$inject$1(java.util.function.Supplier originalWeatheringMapDelegate) {
        weatheringMemoized = true;
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWeatheringMapDelegate.get());
        ErrorHandlingBiConsumer<java.util.function.Supplier, java.util.function.Supplier> consumer = new ErrorHandlingBiConsumer<java.util.function.Supplier, java.util.function.Supplier>((original, weathered) -> builder.put((Object)((Block)original.get()), (Object)((Block)weathered.get())));
        WEATHERING.forEach(consumer);
        consumer.reportExceptions(Create.LOGGER, "weathering");
        return builder.build();
    }

    private static class ErrorHandlingBiConsumer<T, U>
    implements BiConsumer<T, U> {
        private final BiConsumer<T, U> delegate;
        private int exceptionCount = 0;
        @Nullable
        private Throwable firstException;

        public ErrorHandlingBiConsumer(BiConsumer<T, U> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(T t, U u) {
            block2: {
                try {
                    this.delegate.accept(t, u);
                }
                catch (Throwable throwable) {
                    ++this.exceptionCount;
                    if (this.firstException != null) break block2;
                    this.firstException = throwable;
                }
            }
        }

        public void reportExceptions(Logger logger, String type) {
            if (this.exceptionCount != 0) {
                logger.error("Adding " + type + " copper entries from CopperRegistries encountered " + this.exceptionCount + " exception(s)!");
                if (this.firstException != null) {
                    logger.error("The first exception that was thrown is logged below.", this.firstException);
                }
            }
        }
    }
}

