/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.item;

import com.nukateam.cgs.common.faundation.registry.items.CgsItems;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.RegistryObject;

public class FluidContainerItem
extends Item {
    private final Supplier<? extends Fluid> fluidSupplier;

    public FluidContainerItem(Supplier<? extends Fluid> fluid, Item.Properties properties) {
        super(properties);
        this.fluidSupplier = fluid;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        if (this == CgsItems.LAVA_CONTAINER.get()) {
            return 20000;
        }
        return -1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hitResult = FluidContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        if (this.fluidSupplier.get() != Fluids.f_76191_) {
            InteractionResult placementResult = this.tryPlaceFluid(player, level, hitResult, stack);
            if (placementResult.m_19077_()) {
                return InteractionResultHolder.m_19092_((Object)this.handleContainerAfterUse(player, stack, false), (boolean)level.m_5776_());
            }
        } else {
            InteractionResult pickupResult = this.tryPickupFluid(level, hitResult);
            if (pickupResult.m_19077_()) {
                return InteractionResultHolder.m_19092_((Object)this.handleContainerAfterUse(player, stack, true), (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private InteractionResult tryPlaceFluid(Player player, Level level, BlockHitResult hitResult, ItemStack stack) {
        Direction direction;
        Fluid fluid = this.fluidSupplier.get();
        if (fluid == Fluids.f_76191_) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = hitResult.m_82425_();
        BlockPos placePos = pos.m_121945_(direction = hitResult.m_82434_());
        if (player.m_36204_(placePos, direction, player.m_21120_(InteractionHand.MAIN_HAND)) && this.placeFluid(player, level, placePos, hitResult, fluid)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean placeFluid(Player player, Level level, BlockPos pos, BlockHitResult hitResult, Fluid fluid) {
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        boolean canReplace = state.m_60722_(fluid);
        boolean isReplaceable = state.m_247087_();
        if (level.m_46859_(pos) || canReplace || isReplaceable) {
            if (!level.f_46443_ && isReplaceable && !state.m_278721_()) {
                level.m_46961_(pos, true);
            }
            if (level.m_7731_(pos, fluid.m_76145_().m_76188_(), 11) || state.m_60819_().m_76170_()) {
                return true;
            }
        }
        return false;
    }

    private InteractionResult tryPickupFluid(Level level, BlockHitResult hitResult) {
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = state.m_60819_();
        if (fluidState.m_76170_() && fluidState.m_76152_() != Fluids.f_76191_) {
            if (!level.f_46443_) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private ItemStack handleContainerAfterUse(Player player, ItemStack stack, boolean filled) {
        Item newContainer;
        Item item = newContainer = filled ? this.getFilledContainerForFluid(this.getTargetFluid(player.m_9236_(), player)) : (Item)CgsItems.EMPTY_CONTAINER.get();
        if (newContainer == null) {
            return stack;
        }
        ItemStack newStack = new ItemStack((ItemLike)newContainer);
        if (stack.m_41782_()) {
            newStack.m_41751_(stack.m_41783_().m_6426_());
        }
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            return newStack;
        }
        if (!player.m_150109_().m_36054_(newStack)) {
            player.m_36176_(newStack, false);
        }
        return stack;
    }

    private Fluid getTargetFluid(Level level, Player player) {
        BlockHitResult hitResult = FluidContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = hitResult.m_82425_();
        FluidState fluidState = level.m_6425_(pos);
        return fluidState.m_76152_();
    }

    private Item getFilledContainerForFluid(Fluid fluid) {
        for (Map.Entry<Fluid, RegistryObject<Item>> entry : CgsItems.CONTAINERS.entrySet()) {
            if (entry.getKey() != fluid) continue;
            return (Item)entry.getValue().get();
        }
        return null;
    }

    public boolean m_41470_() {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (this.fluidSupplier.get() == Fluids.f_76191_) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)CgsItems.EMPTY_CONTAINER.get());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack);
    }
}

