/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DetachedPlayerDirController {
    private static DetachedPlayerDirController INSTANCE;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private static final double SMOOTHING_ROTATION = 0.9;
    private boolean detached = false;
    private float rotatingYaw = 0.0f;

    public static DetachedPlayerDirController get() {
        if (INSTANCE == null) {
            INSTANCE = new DetachedPlayerDirController();
        }
        return INSTANCE;
    }

    public void updateRotation(float newYaw, float newPitch) {
        boolean goingDown;
        if (!this.detached) {
            this.yaw = newYaw;
            this.pitch = newPitch;
            return;
        }
        boolean goingUp = this.pitch >= 85.0f;
        boolean bl = goingDown = this.pitch <= -85.0f;
        if (!goingUp && !goingDown) {
            this.rotatingYaw = newYaw;
        } else {
            newYaw = this.rotatingYaw += 5.0f;
        }
        this.targetYaw = newYaw;
        this.targetPitch = newPitch;
    }

    public void tickPlayerDirection() {
        if (!this.detached) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        this.yaw = this.lerpAngle(this.yaw, this.targetYaw, 0.9f);
        this.pitch = (float)Mth.m_14139_((double)0.9, (double)this.pitch, (double)this.targetPitch);
        player.m_146922_(this.yaw);
        player.m_146926_(this.pitch);
    }

    private float lerpAngle(float from, float to, float t) {
        float delta = Mth.m_14177_((float)(to - from));
        return from + delta * t;
    }

    public static void tickPlayer() {
        DetachedPlayerDirController.get().tickPlayerDirection();
    }

    public Vec3 getDirection() {
        return new Vec3((double)(-Mth.m_14031_((float)((float)Math.toRadians(this.yaw))) * Mth.m_14089_((float)((float)Math.toRadians(this.pitch)))), (double)(-Mth.m_14031_((float)((float)Math.toRadians(this.pitch)))), (double)(Mth.m_14089_((float)((float)Math.toRadians(this.yaw))) * Mth.m_14089_((float)((float)Math.toRadians(this.pitch)))));
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getTargetYaw() {
        return this.targetYaw;
    }

    public float getTargetPitch() {
        return this.targetPitch;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public float getRotatingYaw() {
        return this.rotatingYaw;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }
}

