/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.events;

import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.network.NetworkHandler;
import com.pedrorok.hypertube.network.packets.SyncPersistentDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="create_hypertube", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerSyncEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerSyncEvents.syncAllStatesToPlayer(serverPlayer);
            PlayerSyncEvents.syncPlayerStateToAll((LivingEntity)serverPlayer, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TravelManager.finishTravel(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerSyncEvents.syncAllStatesToPlayer(serverPlayer);
            PlayerSyncEvents.syncPlayerStateToAll((LivingEntity)serverPlayer, false);
        }
    }

    private static void syncAllStatesToPlayer(ServerPlayer targetPlayer) {
        for (ServerPlayer otherPlayer : targetPlayer.m_20194_().m_6846_().m_11314_()) {
            if (otherPlayer == targetPlayer || !TravelManager.hasHyperTubeData((Entity)otherPlayer)) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> targetPlayer), (Object)new SyncPersistentDataPacket(targetPlayer.m_19879_(), targetPlayer.getPersistentData()));
        }
    }

    public static void syncPlayerStateToAll(LivingEntity sourcePlayer, boolean force) {
        if (!TravelManager.hasHyperTubeData((Entity)sourcePlayer) && !force) {
            return;
        }
        for (ServerPlayer otherPlayer : sourcePlayer.m_20194_().m_6846_().m_11314_()) {
            if (otherPlayer == sourcePlayer) continue;
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPersistentDataPacket(sourcePlayer.m_19879_(), sourcePlayer.getPersistentData()));
        }
    }
}

