/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.core.travel.ClientTravelPathMover;
import com.pedrorok.hypertube.network.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncEntityPosPacket(int entityId, int segment) implements Packet<SyncEntityPosPacket>
{
    public SyncEntityPosPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readInt());
    }

    public static SyncEntityPosPacket create(Entity entity, int segment) {
        return new SyncEntityPosPacket(entity.m_19879_(), segment);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.segment);
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SyncEntityPosPacket.handleClient(this));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncEntityPosPacket packet) {
        ClientTravelPathMover.updateSegment(packet.entityId, packet.segment);
    }
}

