/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.data.event.GatherDataEvent;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.data.CreateVibrantVaultsRecipeProvider;
import net.zlt.create_vibrant_vaults.data.CreateVibrantVaultsTagProvider;
import net.zlt.create_vibrant_vaults.duck.ModelBuilderMixinDuck;

public class CreateVibrantVaultsDatagen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> CreateVibrantVaultsDatagen.provideDefaultLang("interface", (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1)));
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, CreateVibrantVaultsDatagen::providePackageFrogportModels);
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, CreateVibrantVaultsDatagen::provideRedstoneRequesterModels);
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, CreateVibrantVaultsDatagen::providePackagerModels);
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, CreateVibrantVaultsDatagen::provideGaugeModels);
        CreateVibrantVaultsTagProvider.addGenerators();
        generator.addProvider(true, (DataProvider)new CreateVibrantVaultsRecipeProvider(output));
    }

    private static void provideDefaultLang(String filename, BiConsumer<String, String> consumer) {
        String path = "assets/create_vibrant_vaults/lang/default/" + filename + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePackageFrogportModels(RegistrateBlockstateProvider provider) {
        ModBlocks.VibrantVaultColor[] colors;
        for (ModBlocks.VibrantVaultColor color : colors = ModBlocks.VibrantVaultColor.values()) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            String colorId = color.asId();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/block")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/block")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("particle", provider.modLoc("block/item_vault/" + colorId + "/vault_top_small"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/body")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/body")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("1", provider.modLoc("block/package_frogport/" + colorId + "/port"))).texture("particle", provider.modLoc("block/package_frogport/" + colorId + "/port2"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/head")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/head")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("1", provider.modLoc("block/package_frogport/" + colorId + "/port"))).texture("particle", provider.modLoc("block/package_frogport/" + colorId + "/port2"));
            BlockModelBuilder headGogglesBuilder = (BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/head_goggles");
            ((BlockModelBuilder)((BlockModelBuilder)headGogglesBuilder.parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/head_goggles")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("1", provider.modLoc("block/package_frogport/" + colorId + "/port"));
            ((ModelBuilderMixinDuck)headGogglesBuilder).createVibrantVaults$uncheckedTexture("2", Create.asResource((String)"block/froggles"));
            headGogglesBuilder.texture("particle", provider.modLoc("block/package_frogport/" + colorId + "/port2"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/item")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/item")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("1", provider.modLoc("block/package_frogport/" + colorId + "/port"))).texture("particle", provider.modLoc("block/item_vault/" + colorId + "/vault_top_small"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_package_frogport/tongue")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/package_frogport/tongue")))).texture("0", provider.modLoc("block/package_frogport/" + colorId + "/port2"))).texture("particle", provider.modLoc("block/package_frogport/" + colorId + "/port2"));
        }
    }

    private static void provideRedstoneRequesterModels(RegistrateBlockstateProvider provider) {
        ModBlocks.VibrantVaultColor[] colors;
        for (ModBlocks.VibrantVaultColor color : colors = ModBlocks.VibrantVaultColor.values()) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            String colorId = color.asId();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_redstone_requester/block")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/redstone_requester/block")))).texture("0", CreateVibrantVaults.asResource("block/redstone_requester/" + colorId + "/redstone_requester"))).texture("1", CreateVibrantVaults.asResource("block/redstone_requester/" + colorId + "/redstone_requester_unpowered"))).texture("particle", CreateVibrantVaults.asResource("block/redstone_requester/" + colorId + "/redstone_requester_unpowered"));
            ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent("block/" + colorId + "_redstone_requester/block_powered", CreateVibrantVaults.asResource("block/" + colorId + "_redstone_requester/block"))).texture("1", CreateVibrantVaults.asResource("block/redstone_requester/" + colorId + "/redstone_requester_powered"))).texture("particle", CreateVibrantVaults.asResource("block/redstone_requester/" + colorId + "/redstone_requester_powered"));
        }
    }

    private static void providePackagerModels(RegistrateBlockstateProvider provider) {
        ModBlocks.VibrantVaultColor[] colors;
        for (ModBlocks.VibrantVaultColor color : colors = ModBlocks.VibrantVaultColor.values()) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            String colorId = color.asId();
            BlockModelBuilder hatchClosedBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_packager/hatch_closed")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/packager/hatch_closed")))).texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"));
            ((ModelBuilderMixinDuck)hatchClosedBuilder).createVibrantVaults$uncheckedTexture("3", Create.asResource((String)"block/packager_iris_closed"));
            hatchClosedBuilder.texture("particle", CreateVibrantVaults.asResource("block/item_vault/" + colorId + "/vault_front_small"));
            ((ModelBuilderMixinDuck)provider.models().withExistingParent("block/" + colorId + "_packager/hatch_open", CreateVibrantVaults.asResource("block/" + colorId + "_packager/hatch_closed"))).createVibrantVaults$uncheckedTexture("3", Create.asResource((String)"block/packager_iris_open"));
            BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_packager/item")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/packager/item")));
            ((ModelBuilderMixinDuck)builder).createVibrantVaults$uncheckedTexture("0", Create.asResource((String)"block/packager_frame"));
            ((BlockModelBuilder)builder.texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"))).texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_unpowered"));
            ((ModelBuilderMixinDuck)builder).createVibrantVaults$uncheckedTexture("3", Create.asResource((String)"block/packager_iris_closed"));
            builder.texture("particle", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_particle"));
            ((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_packager/tray")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/packager/tray")))).texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"));
        }
    }

    private static void provideGaugeModels(RegistrateBlockstateProvider provider) {
        ModBlocks.VibrantVaultColor[] colors;
        for (ModBlocks.VibrantVaultColor color : colors = ModBlocks.VibrantVaultColor.values()) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            String colorId = color.asId();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_factory_gauge/panel_restocker")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/factory_gauge/panel")))).texture("0", CreateVibrantVaults.asResource("block/factory_gauge/" + colorId + "/factory_panel_packager_mode"))).texture("particle", CreateVibrantVaults.asResource("block/factory_gauge/" + colorId + "/factory_panel_packager_mode"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + colorId + "_factory_gauge/panel_restocker_with_bulb")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/factory_gauge/panel_with_bulb")))).texture("0", CreateVibrantVaults.asResource("block/factory_gauge/" + colorId + "/factory_panel_packager_mode"))).texture("particle", CreateVibrantVaults.asResource("block/factory_gauge/" + colorId + "/factory_panel_packager_mode"));
        }
    }
}

