/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.SmartMesh;

import com.adonis.createfisheryindustry.block.SmartMesh.SmartMeshBlockEntity;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmItem;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SmartMeshBlock
extends Block
implements EntityBlock,
ProperWaterloggedBlock,
IWrenchable {
    public SmartMeshBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isSolidRender(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_20162_()) {
            super.m_142072_(level, state, pos, entity, fallDistance);
        } else {
            entity.m_142535_(fallDistance, 0.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter level, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(level, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    protected void bounceEntity(Entity entity) {
        Vec3 vec3d = entity.m_20184_();
        if (vec3d.f_82480_ < 0.0) {
            double entityWeightOffset = entity instanceof LivingEntity ? 0.6 : 0.8;
            entity.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * entityWeightOffset, vec3d.f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof WrenchItem) {
            InteractionResult result;
            UseOnContext wrenchContext = new UseOnContext(level, player, hand, stack, hitResult);
            InteractionResult interactionResult = result = player.m_6144_() ? this.onSneakWrenched(state, wrenchContext) : this.onWrenched(state, wrenchContext);
            if (result != InteractionResult.PASS) {
                return result;
            }
        }
        if (stack.m_41720_() instanceof ArmItem) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof SmartMeshBlockEntity)) {
            return InteractionResult.FAIL;
        }
        SmartMeshBlockEntity smartTrap = (SmartMeshBlockEntity)be;
        ItemStackHandler inventory = smartTrap.getInventory();
        if (inventory == null) {
            return InteractionResult.FAIL;
        }
        ItemStack extracted = ItemStack.f_41583_;
        int totalItems = 0;
        for (i = 0; i < inventory.getSlots(); ++i) {
            ItemStack slotStack = inventory.getStackInSlot(i);
            if (slotStack.m_41619_()) continue;
            totalItems += slotStack.m_41613_();
        }
        for (i = 0; i < inventory.getSlots() && (extracted = inventory.extractItem(i, 64, false)).m_41619_(); ++i) {
        }
        if (!extracted.m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted);
            player.m_5661_((Component)Component.m_237110_((String)"create_fishery.smart_mesh.extracted", (Object[])new Object[]{extracted.m_41613_(), Component.m_237115_((String)extracted.m_41778_())}), true);
            return InteractionResult.m_19078_((boolean)false);
        }
        if (totalItems > 0) {
            player.m_5661_((Component)Component.m_237115_((String)"create_fishery.smart_mesh.extraction_failed"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"create_fishery.smart_mesh.empty"), true);
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withWater(this.m_49966_(), context);
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)CreateFisheryBlockEntities.SMART_MESH.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return type == CreateFisheryBlockEntities.SMART_MESH.get() ? (lvl, pos, blockState, be) -> SmartMeshBlockEntity.tick(lvl, pos, blockState, (SmartMeshBlockEntity)be) : null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof SmartMeshBlockEntity) {
            SmartMeshBlockEntity smartTrap = (SmartMeshBlockEntity)be;
            ItemStackHandler inventory = smartTrap.getInventory();
            ItemStack stack = ItemStack.f_41583_;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack s = inventory.getStackInSlot(i);
                if (s.m_41619_()) continue;
                stack = s;
                break;
            }
            if (stack.m_41619_()) {
                return 0;
            }
            int signal = (int)Math.floor((float)stack.m_41613_() / (float)stack.m_41741_() * 14.0f) + 1;
            return signal;
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof SmartMeshBlockEntity) {
                SmartMeshBlockEntity smartTrap = (SmartMeshBlockEntity)be;
                smartTrap.dropInventory();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
        level.m_46961_(pos, false);
        IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.m_49931_((BlockState)newState, (LevelAccessor)context.m_43725_(), (BlockPos)context.m_8083_());
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }
}

